/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths;

import java.util.ArrayList;
import java.util.List;
import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPlane;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;

public class PathUtilities {
    public static WayPointPath append(WayPointPath path1, WayPointPath path2, boolean removeDuplicateAtEnds) {
        ArrayList<WayPointPath> paths = new ArrayList<WayPointPath>();
        paths.add(path1);
        paths.add(path2);
        return PathUtilities.append(paths, removeDuplicateAtEnds);
    }

    public static WayPointPath append(List<WayPointPath> paths, boolean removeDuplicateAtEnds) {
        WayPointPath path = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        for (WayPointPath currentPath : paths) {
            String newDescription = String.valueOf(path.getDescription()) + "\n\n" + currentPath.getDescription();
            path.setDescription(newDescription);
            int i = 0;
            while (i < currentPath.getPoints().size()) {
                CartesianPositionCoordinates currentWayPoint = (CartesianPositionCoordinates)currentPath.getPoints().get(i);
                if (removeDuplicateAtEnds && i == 0 && path.getPoints().size() > 0) {
                    CartesianPositionCoordinates currentEndPoint = (CartesianPositionCoordinates)path.getPoints().get(path.getPoints().size() - 1);
                    if (!currentWayPoint.equals(currentEndPoint)) {
                        path.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(currentWayPoint));
                    }
                } else {
                    path.getPoints().add((Object)ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(currentWayPoint));
                }
                ++i;
            }
        }
        return path;
    }

    public static double getAngularMotion(CartesianAxis axis, WayPointPath wayPointPath) {
        double angularMotion = 0.0;
        if (wayPointPath.getPoints().size() > 2) {
            Vector3d u = null;
            Vector3d v = null;
            List flattenCoord = Geometry3DUtilities.getFlattenCoordinates((CartesianPlane)Geometry3DUtilities.getPerpendicularPlane((CartesianAxis)axis), (List)wayPointPath.getPoints());
            int i = 0;
            while (i < flattenCoord.size() - 2) {
                CartesianPositionCoordinates p1 = (CartesianPositionCoordinates)flattenCoord.get(i);
                CartesianPositionCoordinates p2 = (CartesianPositionCoordinates)flattenCoord.get(i + 1);
                CartesianPositionCoordinates p3 = (CartesianPositionCoordinates)flattenCoord.get(i + 2);
                u = new Vector3d(p2.getX() - p1.getX(), p2.getY() - p1.getY(), p2.getZ() - p1.getZ());
                v = new Vector3d(p3.getX() - p2.getX(), p3.getY() - p2.getY(), p3.getZ() - p2.getZ());
                if (u.length() > 0.0 && v.length() > 0.0) {
                    angularMotion += u.angle(v);
                }
                ++i;
            }
        }
        return angularMotion;
    }

    public static List<CartesianPositionCoordinates> getLongestSegment(WayPointPath wayPointPath) {
        ArrayList<CartesianPositionCoordinates> longestSegment = new ArrayList<CartesianPositionCoordinates>();
        double maxLength = 0.0;
        if (wayPointPath.getPoints().size() > 1) {
            int i = 0;
            while (i < wayPointPath.getPoints().size() - 1) {
                CartesianPositionCoordinates p2;
                CartesianPositionCoordinates p1 = (CartesianPositionCoordinates)wayPointPath.getPoints().get(i);
                double segmentLength = Geometry3DUtilities.getDistance((CartesianPositionCoordinates)p1, (CartesianPositionCoordinates)(p2 = (CartesianPositionCoordinates)wayPointPath.getPoints().get(i + 1)));
                if (segmentLength >= maxLength) {
                    maxLength = segmentLength;
                    longestSegment.clear();
                    longestSegment.add(p1);
                    longestSegment.add(p2);
                }
                ++i;
            }
        }
        return longestSegment;
    }

    public static double getLongestSegmentLength(WayPointPath wayPointPath) {
        double maximumLength = 0.0;
        List<CartesianPositionCoordinates> longestSegment = PathUtilities.getLongestSegment(wayPointPath);
        if (longestSegment.size() == 2) {
            maximumLength = Geometry3DUtilities.getDistance((CartesianPositionCoordinates)longestSegment.get(0), (CartesianPositionCoordinates)longestSegment.get(1));
        }
        return maximumLength;
    }

    public static List<CartesianPositionCoordinates> getShortestSegment(WayPointPath wayPointPath) {
        ArrayList<CartesianPositionCoordinates> shortestSegment = new ArrayList<CartesianPositionCoordinates>();
        double minLength = Double.POSITIVE_INFINITY;
        if (wayPointPath.getPoints().size() > 1) {
            int i = 0;
            while (i < wayPointPath.getPoints().size() - 1) {
                CartesianPositionCoordinates p2;
                CartesianPositionCoordinates p1 = (CartesianPositionCoordinates)wayPointPath.getPoints().get(i);
                double segmentLength = Geometry3DUtilities.getDistance((CartesianPositionCoordinates)p1, (CartesianPositionCoordinates)(p2 = (CartesianPositionCoordinates)wayPointPath.getPoints().get(i + 1)));
                if (segmentLength <= minLength) {
                    minLength = segmentLength;
                    shortestSegment.clear();
                    shortestSegment.add(p1);
                    shortestSegment.add(p2);
                }
                ++i;
            }
        }
        return shortestSegment;
    }

    public static double getShortestSegmentLength(WayPointPath wayPointPath) {
        double minimumLength = 0.0;
        List<CartesianPositionCoordinates> shortestSegment = PathUtilities.getShortestSegment(wayPointPath);
        if (shortestSegment.size() == 2) {
            minimumLength = Geometry3DUtilities.getDistance((CartesianPositionCoordinates)shortestSegment.get(0), (CartesianPositionCoordinates)shortestSegment.get(1));
        }
        return minimumLength;
    }

    public static WayPointPath applyTransform(WayPointPath path, Matrix4d transform) {
        WayPointPath transformedPath = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        Transform3D transform3d = new Transform3D(transform);
        ArrayList<CartesianPositionCoordinates> points = new ArrayList<CartesianPositionCoordinates>();
        for (CartesianPositionCoordinates point : path.getPoints()) {
            Point3d p = new Point3d(point.getX(), point.getY(), point.getZ());
            transform3d.transform(p);
            CartesianPositionCoordinates newPoint = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(p.x, p.y, p.z);
            points.add(newPoint);
        }
        transformedPath.getPoints().addAll(points);
        return transformedPath;
    }
}

