/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class WayPointPathBinding {
    private Adapter adapter = null;
    private final Map<CartesianPositionCoordinates, CartesianPositionCoordinates> originalToCopy = new HashMap<CartesianPositionCoordinates, CartesianPositionCoordinates>();
    private WayPointPath sourceWayPointPath = null;
    private WayPointPath targetWayPointPath = null;

    public WayPointPathBinding(WayPointPath sourceWayPointPath, WayPointPath targetWayPointPath) {
        this.setTargetWayPointPath(targetWayPointPath);
        this.setSourceWayPointPath(sourceWayPointPath);
    }

    public WayPointPath getSourceWayPointPath() {
        return this.sourceWayPointPath;
    }

    public void setSourceWayPointPath(WayPointPath newSourceWayPointPath) {
        if (this.sourceWayPointPath != null) {
            this.sourceWayPointPath.eAdapters().remove((Object)this.getAdapter());
        }
        if (this.targetWayPointPath != null) {
            this.targetWayPointPath.getPoints().clear();
        }
        this.originalToCopy.clear();
        this.sourceWayPointPath = newSourceWayPointPath;
        if (newSourceWayPointPath != null) {
            if (this.targetWayPointPath != null) {
                this.addPoints((List<CartesianPositionCoordinates>)newSourceWayPointPath.getPoints());
            }
            newSourceWayPointPath.eAdapters().add((Object)this.getAdapter());
        }
    }

    public WayPointPath getTargetWayPointPath() {
        return this.targetWayPointPath;
    }

    public void setTargetWayPointPath(WayPointPath targetWayPointPath) {
        this.targetWayPointPath = targetWayPointPath;
    }

    protected void addPoint(CartesianPositionCoordinates point) {
        if (this.getTargetWayPointPath() != null) {
            CartesianPositionCoordinates pointCopy = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point);
            this.getTargetWayPointPath().getPoints().add((Object)pointCopy);
            this.originalToCopy.put(point, pointCopy);
        }
    }

    protected void addPoints(List<CartesianPositionCoordinates> points) {
        if (this.getTargetWayPointPath() != null) {
            ArrayList<CartesianPositionCoordinates> pointsCopy = new ArrayList<CartesianPositionCoordinates>();
            for (CartesianPositionCoordinates point : points) {
                CartesianPositionCoordinates pointCopy = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(point);
                pointsCopy.add(pointCopy);
                this.originalToCopy.put(point, pointCopy);
            }
            this.getTargetWayPointPath().getPoints().addAll(pointsCopy);
        }
    }

    protected void removePoint(CartesianPositionCoordinates point) {
        CartesianPositionCoordinates pointCopy;
        if (this.getTargetWayPointPath() != null && (pointCopy = this.originalToCopy.get(point)) != null) {
            this.getTargetWayPointPath().getPoints().remove((Object)pointCopy);
            this.originalToCopy.remove(point);
        }
    }

    protected void removePoints(List<CartesianPositionCoordinates> points) {
        if (this.getTargetWayPointPath() != null) {
            for (CartesianPositionCoordinates point : points) {
                CartesianPositionCoordinates pointCopy = this.originalToCopy.get(point);
                if (pointCopy == null) continue;
                this.getTargetWayPointPath().getPoints().remove((Object)pointCopy);
                this.originalToCopy.remove(point);
            }
        }
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof WayPointPath) {
                        int featureId = msg.getFeatureID(WayPointPath.class);
                        switch (featureId) {
                            case 0: {
                                int eventType = msg.getEventType();
                                switch (eventType) {
                                    case 3: {
                                        CartesianPositionCoordinates pointAdded = (CartesianPositionCoordinates)msg.getNewValue();
                                        WayPointPathBinding.this.addPoint(pointAdded);
                                        break;
                                    }
                                    case 5: {
                                        List pointsAdded = (List)msg.getNewValue();
                                        WayPointPathBinding.this.addPoints(pointsAdded);
                                        break;
                                    }
                                    case 4: {
                                        CartesianPositionCoordinates pointRemoved = (CartesianPositionCoordinates)msg.getOldValue();
                                        WayPointPathBinding.this.removePoint(pointRemoved);
                                        break;
                                    }
                                    case 6: {
                                        List pointsRemoved = (List)msg.getOldValue();
                                        WayPointPathBinding.this.removePoints(pointsRemoved);
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

