/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.geometry.paths.impl.ApogyAddonsGeometryPathsFacadeImpl;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.CartesianAxis;
import org.eclipse.apogy.common.geometry.data3d.CartesianPlane;
import org.eclipse.apogy.common.geometry.data3d.CartesianPolygon;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Geometry3DUtilities;
import org.eclipse.apogy.common.math.Matrix4x4;

public class ApogyAddonsGeometryPathsFacadeCustomImpl
extends ApogyAddonsGeometryPathsFacadeImpl {
    @Override
    public WayPointPath createWayPointPath(WayPointPath wayPointPath) {
        WayPointPath path = this.createWayPointPath((List<CartesianPositionCoordinates>)wayPointPath.getPoints());
        path.setDescription(wayPointPath.getDescription());
        return path;
    }

    @Override
    public WayPointPath createWayPointPath(List<CartesianPositionCoordinates> points) {
        WayPointPath path = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        Iterator<CartesianPositionCoordinates> it = points.iterator();
        while (it.hasNext()) {
            CartesianPositionCoordinates wayPointCopy = ApogyCommonGeometryData3DFacade.INSTANCE.createCartesianPositionCoordinates(it.next());
            path.getPoints().add((Object)wayPointCopy);
        }
        return path;
    }

    @Override
    public WayPointPath projectOntoMesh(WayPointPath originalPath, CartesianTriangularMesh mesh, Matrix4x4 meshToPathTransform, CartesianAxis projectionAxis, double heightOffset) {
        Matrix4d transform = meshToPathTransform.asMatrix4d();
        WayPointPath transformedWayPointPath = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        for (CartesianPositionCoordinates point : originalPath.getPoints()) {
            transformedWayPointPath.getPoints().add((Object)Geometry3DUtilities.createTransformedCartesianPositionCoordinates((Matrix4d)transform, (CartesianPositionCoordinates)point));
        }
        WayPointPath temp = this.createWayPointPath(transformedWayPointPath);
        if (transformedWayPointPath.getPoints().size() >= 2) {
            CartesianPositionCoordinates p1 = null;
            CartesianPositionCoordinates p2 = null;
            int j = 1;
            while (j < transformedWayPointPath.getPoints().size()) {
                p1 = (CartesianPositionCoordinates)transformedWayPointPath.getPoints().get(j - 1);
                TreeSet<CartesianPositionCoordinates> crossingPoints = this.getPolygonEdgeCrossingPoints(projectionAxis, p1, p2 = (CartesianPositionCoordinates)transformedWayPointPath.getPoints().get(j), (Collection<CartesianTriangle>)mesh.getPolygons());
                if (!crossingPoints.isEmpty()) {
                    int startIndex = temp.getPoints().indexOf((Object)p1);
                    temp.getPoints().addAll(startIndex, crossingPoints);
                }
                ++j;
            }
        }
        CartesianPositionCoordinates[] projections = Geometry3DUtilities.getProjectionAlongAxisOnToPolygon((CartesianAxis)projectionAxis, (List)temp.getPoints(), (List)mesh.getPolygons());
        int i = 0;
        while (i < projections.length) {
            CartesianPositionCoordinates projection = projections[i];
            if (projection != null) {
                CartesianPositionCoordinates point = (CartesianPositionCoordinates)temp.getPoints().get(i);
                point.setX(projection.getX());
                point.setY(projection.getY());
                point.setZ(projection.getZ());
                switch (projectionAxis.getValue()) {
                    case 0: {
                        point.setX(point.getX() + heightOffset);
                        break;
                    }
                    case 1: {
                        point.setY(point.getY() + heightOffset);
                        break;
                    }
                    case 2: {
                        point.setZ(point.getZ() + heightOffset);
                        break;
                    }
                }
            }
            ++i;
        }
        Matrix4d transformInverse = meshToPathTransform.asMatrix4d();
        transformInverse.invert();
        WayPointPath result = ApogyAddonsGeometryPathsFactory.eINSTANCE.createWayPointPath();
        for (CartesianPositionCoordinates point : temp.getPoints()) {
            result.getPoints().add((Object)Geometry3DUtilities.createTransformedCartesianPositionCoordinates((Matrix4d)transformInverse, (CartesianPositionCoordinates)point));
        }
        return result;
    }

    private TreeSet<CartesianPositionCoordinates> getPolygonEdgeCrossingPoints(CartesianAxis projectionAxis, final CartesianPositionCoordinates p1, CartesianPositionCoordinates p2, Collection<CartesianTriangle> polygons) {
        ArrayList<CartesianPositionCoordinates> crossingPoints = new ArrayList<CartesianPositionCoordinates>();
        CartesianPlane plane = Geometry3DUtilities.getPerpendicularPlane((CartesianAxis)projectionAxis);
        for (CartesianPolygon cartesianPolygon : polygons) {
            if (cartesianPolygon.getVertices().size() <= 2) continue;
            Vector2d u1 = Geometry3DUtilities.getVector2D((CartesianPlane)plane, (CartesianPositionCoordinates)p1);
            Vector2d u2 = Geometry3DUtilities.getVector2D((CartesianPlane)plane, (CartesianPositionCoordinates)p2);
            int i = 0;
            while (i < cartesianPolygon.getVertices().size()) {
                CartesianPositionCoordinates e1 = null;
                CartesianPositionCoordinates e2 = null;
                if (i < cartesianPolygon.getVertices().size() - 1) {
                    e1 = (CartesianPositionCoordinates)cartesianPolygon.getVertices().get(i);
                    e2 = (CartesianPositionCoordinates)cartesianPolygon.getVertices().get(i + 1);
                } else {
                    e1 = (CartesianPositionCoordinates)cartesianPolygon.getVertices().get(cartesianPolygon.getVertices().size() - 1);
                    e2 = (CartesianPositionCoordinates)cartesianPolygon.getVertices().get(0);
                }
                Vector2d v1 = Geometry3DUtilities.getVector2D((CartesianPlane)plane, (CartesianPositionCoordinates)e1);
                Vector2d v2 = Geometry3DUtilities.getVector2D((CartesianPlane)plane, (CartesianPositionCoordinates)e2);
                Vector2d intersect = Geometry3DUtilities.getLineIntersectionPoint((Vector2d)u1, (Vector2d)u2, (Vector2d)v1, (Vector2d)v2);
                if (intersect != null) {
                    double edgeLength = Geometry3DUtilities.getDistance((Vector2d)v1, (Vector2d)v2);
                    double lineLength = Geometry3DUtilities.getDistance((Vector2d)u1, (Vector2d)u2);
                    if (Geometry3DUtilities.getDistance((Vector2d)intersect, (Vector2d)v1) < edgeLength && Geometry3DUtilities.getDistance((Vector2d)intersect, (Vector2d)v1) > 0.0 && Geometry3DUtilities.getDistance((Vector2d)intersect, (Vector2d)v2) < edgeLength && Geometry3DUtilities.getDistance((Vector2d)intersect, (Vector2d)v2) > 0.0 && Geometry3DUtilities.getDistance((Vector2d)intersect, (Vector2d)u1) < lineLength && Geometry3DUtilities.getDistance((Vector2d)intersect, (Vector2d)u1) > 0.0 && Geometry3DUtilities.getDistance((Vector2d)intersect, (Vector2d)u2) < lineLength && Geometry3DUtilities.getDistance((Vector2d)intersect, (Vector2d)u2) > 0.0) {
                        Point3d intersectionPoint = new Point3d(intersect.x, intersect.y, 0.0);
                        crossingPoints.add(Geometry3DUtilities.getProjectionAlongAxisOnToPolygon((CartesianAxis)projectionAxis, (Point3d)intersectionPoint, (CartesianPolygon)cartesianPolygon));
                    }
                }
                ++i;
            }
        }
        TreeSet<CartesianPositionCoordinates> treeSet = new TreeSet<CartesianPositionCoordinates>(new Comparator<CartesianPositionCoordinates>(){

            @Override
            public int compare(CartesianPositionCoordinates arg0, CartesianPositionCoordinates arg1) {
                double d1;
                double d0 = p1.asPoint3d().distance(arg0.asPoint3d());
                if (d0 < (d1 = p1.asPoint3d().distance(arg1.asPoint3d()))) {
                    return -1;
                }
                if (d0 > d1) {
                    return 1;
                }
                return 0;
            }
        });
        treeSet.addAll(crossingPoints);
        return treeSet;
    }
}

