/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.bindings.impl;

import java.util.Map;
import org.eclipse.apogy.addons.sensors.fov.AngularSpan;
import org.eclipse.apogy.addons.sensors.fov.CircularSectorFieldOfView;
import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.addons.sensors.fov.bindings.impl.CircularSectorFieldOfViewBindingImpl;
import org.eclipse.apogy.common.emf.FeatureNodeAdapter;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class CircularSectorFieldOfViewBindingCustomImpl
extends CircularSectorFieldOfViewBindingImpl {
    private AdapterImpl adapter;

    public AbstractTopologyBinding clone(Map<Node, Node> originalToCopyNodeMap) {
        CircularSectorFieldOfViewBindingCustomImpl fovBindingCopy = (CircularSectorFieldOfViewBindingCustomImpl)EcoreUtil.copy((EObject)this);
        fovBindingCopy.setFov((CircularSectorFieldOfView)originalToCopyNodeMap.get(this.getFov()));
        return fovBindingCopy;
    }

    public Class<?> getSupportedFeatureType() {
        return CircularSectorFieldOfView.class;
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(FeatureNodeAdapter.class) == 2) {
                        if (notification.getOldValue() instanceof CircularSectorFieldOfView) {
                            CircularSectorFieldOfView oldFOV = (CircularSectorFieldOfView)notification.getOldValue();
                            oldFOV.eAdapters().remove((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                            if (oldFOV.getAngularSpan() != null) {
                                oldFOV.getAngularSpan().eAdapters().remove((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                            }
                            if (oldFOV.getRange() != null) {
                                oldFOV.getRange().eAdapters().remove((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                            }
                        }
                        CircularSectorFieldOfViewBindingCustomImpl.this.valueChanged(notification.getNewValue());
                        if (notification.getNewValue() instanceof CircularSectorFieldOfView) {
                            CircularSectorFieldOfView newFOV = (CircularSectorFieldOfView)notification.getNewValue();
                            newFOV.eAdapters().add((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                            if (newFOV.getAngularSpan() != null) {
                                newFOV.getAngularSpan().eAdapters().add((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                            }
                            if (newFOV.getRange() != null) {
                                newFOV.getRange().eAdapters().add((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                            }
                        }
                    } else if (notification.getNotifier() instanceof CircularSectorFieldOfView) {
                        if (notification.getFeatureID(CircularSectorFieldOfView.class) == 3) {
                            if (notification.getOldValue() instanceof DistanceRange) {
                                DistanceRange oldDistanceRange = (DistanceRange)notification.getOldValue();
                                oldDistanceRange.eAdapters().remove((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                            }
                            if (notification.getNewValue() instanceof DistanceRange) {
                                DistanceRange newDistanceRange = (DistanceRange)notification.getNewValue();
                                newDistanceRange.eAdapters().add((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                                CircularSectorFieldOfViewBindingCustomImpl.this.updateDistanceRange(newDistanceRange);
                            }
                        } else if (notification.getFeatureID(CircularSectorFieldOfView.class) == 4) {
                            if (notification.getOldValue() instanceof AngularSpan) {
                                AngularSpan oldAngularSpan = (AngularSpan)notification.getOldValue();
                                oldAngularSpan.eAdapters().remove((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                            }
                            if (notification.getNewValue() instanceof AngularSpan) {
                                AngularSpan newAngularSpan = (AngularSpan)notification.getNewValue();
                                newAngularSpan.eAdapters().add((Object)CircularSectorFieldOfViewBindingCustomImpl.this.getAdapter());
                                CircularSectorFieldOfViewBindingCustomImpl.this.updateAngularSpan(newAngularSpan);
                            }
                        }
                    } else if (notification.getNotifier() instanceof DistanceRange) {
                        DistanceRange distanceRange = (DistanceRange)notification.getNotifier();
                        CircularSectorFieldOfViewBindingCustomImpl.this.updateDistanceRange(distanceRange);
                    } else if (notification.getNotifier() instanceof AngularSpan) {
                        AngularSpan angularSpan = (AngularSpan)notification.getNotifier();
                        CircularSectorFieldOfViewBindingCustomImpl.this.updateAngularSpan(angularSpan);
                    }
                }
            };
        }
        return this.adapter;
    }

    private void updateDistanceRange(DistanceRange newDistanceRange) {
        this.getFov().getRange().setMinimumDistance(newDistanceRange.getMinimumDistance());
        this.getFov().getRange().setMaximumDistance(newDistanceRange.getMaximumDistance());
    }

    private void updateAngularSpan(AngularSpan newAngularSpan) {
        this.getFov().getAngularSpan().setMinimumAngle(newAngularSpan.getMinimumAngle());
        this.getFov().getAngularSpan().setMaximumAngle(newAngularSpan.getMaximumAngle());
    }

    protected void valueChanged(Object newValue) {
        if (newValue instanceof CircularSectorFieldOfView) {
            CircularSectorFieldOfView sourceFOV = (CircularSectorFieldOfView)newValue;
            this.getFov().setDescription(sourceFOV.getDescription());
            if (sourceFOV.getRange() != null) {
                this.updateDistanceRange(sourceFOV.getRange());
            } else {
                this.getFov().setRange(null);
            }
            if (sourceFOV.getAngularSpan() != null) {
                this.updateAngularSpan(sourceFOV.getAngularSpan());
            } else {
                this.getFov().setAngularSpan(null);
            }
        }
    }
}

