/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils;

import com.jme3.asset.AssetManager;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.post.MultiTextureProjectorRenderer;
import com.jme3.post.SceneProcessor;
import com.jme3.post.SimpleTextureProjector;
import com.jme3.renderer.Camera;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.ViewPort;
import com.jme3.scene.Spatial;
import com.jme3.scene.control.AbstractControl;
import com.jme3.scene.debug.WireFrustum;
import com.jme3.texture.Texture;
import com.jme3.texture.Texture2D;
import java.awt.image.BufferedImage;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.scene_objects.ProjectorData;
import org.eclipse.apogy.addons.sensors.fov.ui.jme3.utils.JME3FovUtilities;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;

public abstract class ImageProjectorControl<T extends Node>
extends AbstractControl {
    protected T fieldOfView;
    protected JME3Application jm3Application;
    private ProjectorData projectorData;
    public MultiTextureProjectorRenderer multiTextureProjectorRenderer;

    public ImageProjectorControl(JME3Application jm3Application, T node) {
        this.jm3Application = jm3Application;
        this.fieldOfView = node;
    }

    public void setSpatial(Spatial spatial) {
        super.setSpatial(spatial);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            if (!this.jm3Application.getViewPort().getProcessors().contains(this.getMultiTextureProjectorRenderer())) {
                this.jm3Application.getViewPort().addProcessor((SceneProcessor)this.getMultiTextureProjectorRenderer());
            }
        } else if (this.jm3Application.getViewPort().getProcessors().contains(this.getMultiTextureProjectorRenderer())) {
            this.jm3Application.getViewPort().removeProcessor((SceneProcessor)this.getMultiTextureProjectorRenderer());
        }
        super.setEnabled(enabled);
    }

    public void dispose() {
        this.setEnabled(false);
        this.jm3Application.getViewPort().removeProcessor((SceneProcessor)this.getMultiTextureProjectorRenderer());
    }

    public abstract float getHorizontalFOVAngleDegrees();

    public abstract float getTextureHtoVRatio();

    public abstract BufferedImage getProjectedImage();

    public abstract void updateProjectorFOVSettings();

    protected void controlRender(RenderManager arg0, ViewPort arg1) {
    }

    protected void controlUpdate(float arg0) {
        if (this.isEnabled()) {
            if (this.getMultiTextureProjectorRenderer().getTargetGeometryList() == null) {
                this.getMultiTextureProjectorRenderer().setTargetGeometryList(JME3FovUtilities.createGeometryListForImageProjection(this.jm3Application));
            } else {
                JME3FovUtilities.updateGeometryListForImageProjection(this.jm3Application.getJMERenderEngineDelegate(), this.getMultiTextureProjectorRenderer().getTargetGeometryList());
            }
            Camera projectorCamera = this.getProjectorData().projector.getProjectorCamera();
            projectorCamera.setLocation(this.getProjectorLocation());
            projectorCamera.setRotation(this.getProjectorRotation());
        }
    }

    protected MultiTextureProjectorRenderer getMultiTextureProjectorRenderer() {
        if (this.multiTextureProjectorRenderer == null) {
            this.multiTextureProjectorRenderer = new MultiTextureProjectorRenderer(this.jm3Application.getAssetManager());
            this.multiTextureProjectorRenderer.setTargetGeometryList(JME3FovUtilities.createGeometryListForImageProjection(this.jm3Application));
            this.multiTextureProjectorRenderer.getTextureProjectors().add(this.getProjectorData().projector);
        }
        return this.multiTextureProjectorRenderer;
    }

    protected ProjectorData getProjectorData() {
        if (this.projectorData == null) {
            this.projectorData = new ProjectorData();
            Texture2D texture2D = this.createTexture();
            int textureWidth = texture2D.getImage().getWidth();
            int textureHeight = texture2D.getImage().getHeight();
            float textureAspectRatio = (float)textureWidth / (float)textureHeight;
            this.projectorData.projector = new SimpleTextureProjector(texture2D);
            this.projectorData.projector.setFallOffDistance(1000.0f);
            this.projectorData.projector.setFallOffPower(4.0f);
            this.projectorData.projector.setParameter((Object)"CombineMode", (Object)MultiTextureProjectorRenderer.CombineMode.BLEND_COLOR_ADD_ALPHA);
            Camera projectorCamera = this.projectorData.projector.getProjectorCamera();
            projectorCamera.setLocation(this.getProjectorLocation());
            projectorCamera.setRotation(this.getProjectorRotation());
            if (this.getHorizontalFOVAngleDegrees() > 0.0f) {
                projectorCamera.setFrustumPerspective(this.getHorizontalFOVAngleDegrees(), textureAspectRatio, 1.0f, 5.0f);
            } else {
                projectorCamera.setFrustumPerspective(0.1f, textureAspectRatio, 1.0f, 5.0f);
            }
            projectorCamera.setParallelProjection(false);
            this.projectorData.frustumPoints = new Vector3f[8];
            int i = 0;
            while (i < 8) {
                this.projectorData.frustumPoints[i] = new Vector3f();
                ++i;
            }
            this.projectorData.projector.updateFrustumPoints(this.projectorData.frustumPoints);
            this.projectorData.frustum = new WireFrustum(this.projectorData.frustumPoints);
        }
        return this.projectorData;
    }

    protected Texture2D createTexture() {
        BufferedImage image = this.getProjectedImage();
        Texture2D texture2D = JME3Utilities.createTexture2D((BufferedImage)image, (AssetManager)this.jm3Application.getAssetManager());
        texture2D.setMinFilter(Texture.MinFilter.Trilinear);
        texture2D.setMagFilter(Texture.MagFilter.Bilinear);
        texture2D.setAnisotropicFilter(16);
        texture2D.setWrap(Texture.WrapMode.BorderClamp);
        return texture2D;
    }

    protected Quaternion getProjectorRotation() {
        Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(this.fieldOfView);
        Matrix3d rot = new Matrix3d();
        m.get(rot);
        Quaternion q = JME3Utilities.createQuaternion((Matrix3d)rot);
        return q;
    }

    protected Vector3f getProjectorLocation() {
        Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(this.fieldOfView);
        Vector3d v = new Vector3d();
        m.get(v);
        Vector3f location = JME3Utilities.convertToVector3f((Tuple3d)v);
        return location;
    }
}

