/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.fov.ui.wizards;

import org.eclipse.apogy.addons.sensors.fov.DistanceRange;
import org.eclipse.apogy.addons.sensors.fov.ui.composites.DistanceRangeComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class DistanceRangeWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.fov.ui.wizards.DistanceRangeWizardPage";
    private final DistanceRange distanceRange;
    private DistanceRangeComposite distanceRangeComposite;
    private Adapter adapter;

    public DistanceRangeWizardPage(DistanceRange distanceRange) {
        super(WIZARD_PAGE_ID);
        this.distanceRange = distanceRange;
        this.setTitle("Distance Range");
        this.setDescription("Sets the distance range minium and maximum distances.");
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.distanceRangeComposite = new DistanceRangeComposite(top, 0);
        this.distanceRangeComposite.setDistanceRange(this.distanceRange);
        this.setControl((Control)top);
        if (this.distanceRange != null) {
            this.distanceRange.eAdapters().add((Object)this.getAdapter());
        }
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (DistanceRangeWizardPage.this.distanceRange != null) {
                    DistanceRangeWizardPage.this.distanceRange.eAdapters().remove((Object)DistanceRangeWizardPage.this.getAdapter());
                }
            }
        });
        this.validate();
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.distanceRange.getMinimumDistance() < 0.0) {
            this.setErrorMessage("The specified minimum range should equal or greater than zero !");
        }
        if (this.distanceRange.getMaximumDistance() < 0.0) {
            this.setErrorMessage("The specified maximum range should equal or greater than zero !");
        }
        if (this.distanceRange.getMaximumDistance() <= this.distanceRange.getMinimumDistance()) {
            this.setErrorMessage("The specified maximum range should equal or greater than the minimum range !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof DistanceRange) {
                        DistanceRangeWizardPage.this.validate();
                    }
                }
            };
        }
        return this.adapter;
    }
}

