/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.gps.impl;

import org.eclipse.apogy.addons.sensors.gps.GPSReading;
import org.eclipse.apogy.addons.sensors.gps.GPSStatus;
import org.eclipse.apogy.addons.sensors.gps.impl.GPSImpl;
import org.eclipse.apogy.addons.sensors.gps.state.GPSState;
import org.eclipse.apogy.addons.sensors.gps.state.GPSStateFactory;
import org.eclipse.apogy.common.lang.java.Timer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public class GPSCustomImpl
extends GPSImpl {
    private GPSState gpsState;
    private Job gpsJob;

    protected GPSCustomImpl() {
        this.status = GPSStatus.STOPPED;
    }

    @Override
    public GPSReading getReading() {
        this.start();
        if (this.getStatus() != GPSStatus.RUNNING && this.getStatus() != GPSStatus.RECONNECTING && this.getStatus() != GPSStatus.CONNECTING) {
            throw new RuntimeException(this.getLastFailure());
        }
        return this.reading;
    }

    @Override
    public void setStatus(GPSStatus newStatus) {
        GPSStatus oldStatus = this.status;
        GPSStatus gPSStatus = this.status = newStatus == null ? STATUS_EDEFAULT : newStatus;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldStatus, (Object)this.status));
        }
        this.gpsState = null;
    }

    private GPSState getGPSState() {
        if (this.gpsState == null) {
            this.gpsState = GPSStateFactory.createState(this);
        }
        return this.gpsState;
    }

    @Override
    public void start() {
        this.validatePreConditions();
        try {
            this.getGPSState().start();
            this.setLastFailure(null);
            this.getGpsJob().schedule();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void validatePreConditions() {
        if (this.getConnection() == null) {
            throw new IllegalArgumentException("No connection provided");
        }
        if (this.getDataInterpreter() == null) {
            throw new IllegalArgumentException("No interpreter provided");
        }
    }

    @Override
    public void stop() {
        try {
            this.getGPSState().stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Override
    public void reset() {
        try {
            this.getGPSState().reset();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private Job getGpsJob() {
        if (this.gpsJob == null) {
            this.gpsJob = new Job("GPS"){

                protected IStatus run(IProgressMonitor monitor) {
                    Timer t = new Timer();
                    while (GPSCustomImpl.this.getGPSState().isRunning()) {
                        t.start();
                        GPSCustomImpl.this.getGPSState().updateGPS();
                        long time = t.stop();
                        long delta = GPSCustomImpl.this.getUpdateRate() - time;
                        if (delta <= 0L) continue;
                        try {
                            Thread.sleep(delta);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.gpsJob;
    }

    @Override
    public boolean reconnect() {
        try {
            return this.getGPSState().reconnect();
        }
        catch (IllegalStateException e) {
            return false;
        }
    }
}

