/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.gps.state;

import org.eclipse.apogy.addons.sensors.gps.GPS;
import org.eclipse.apogy.addons.sensors.gps.GPSStatus;

public abstract class GPSState {
    private final GPS gps;

    public GPSState(GPS gps) {
        if (gps == null) {
            throw new IllegalArgumentException();
        }
        this.gps = gps;
    }

    public GPS getGPS() {
        return this.gps;
    }

    public void start() throws IllegalStateException {
        throw new IllegalStateException();
    }

    public void stop() throws IllegalStateException {
        throw new IllegalStateException();
    }

    public void reset() throws IllegalStateException {
        this.getGPS().setStatus(GPSStatus.STOPPED);
        this.getGPS().setLastFailure(null);
    }

    public void updateGPS() throws IllegalStateException {
        throw new IllegalStateException();
    }

    public boolean isRunning() {
        return false;
    }

    public boolean reconnect() throws IllegalStateException {
        throw new IllegalStateException();
    }

    public void failure(Exception e) {
        this.getGPS().setLastFailure(e);
    }
}

