/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.gps.state;

import java.io.IOException;
import org.eclipse.apogy.addons.sensors.gps.GPS;
import org.eclipse.apogy.addons.sensors.gps.GPSStatus;
import org.eclipse.apogy.addons.sensors.gps.state.GPSState;
import org.eclipse.apogy.common.lang.java.Timer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPSStateReconnecting
extends GPSState {
    private static final Logger Logger = LoggerFactory.getLogger(GPSStateReconnecting.class);

    public GPSStateReconnecting(GPS gps) {
        super(gps);
    }

    @Override
    public void failure(Exception e) {
        super.failure(e);
        this.getGPS().setStatus(GPSStatus.FAILED);
    }

    @Override
    public boolean isRunning() {
        return true;
    }

    @Override
    public boolean reconnect() throws IllegalStateException {
        if (this.getGPS().getConnection().getInput() == null) {
            IOException e = new IOException("Failed to connect gps");
            this.failure(e);
            return false;
        }
        boolean done = false;
        boolean success = false;
        Timer timer = new Timer();
        timer.start();
        while (!done) {
            try {
                try {
                    this.getGPS().getConnection().reset();
                    done = true;
                    success = true;
                }
                catch (IOException e) {
                    Logger.warn("Problem while reconnecting from gps, retrying: " + e.getMessage(), (Throwable)e);
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (timer.elapsed() <= (long)this.getGPS().getMaxReconnectTime()) continue;
                    done = true;
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (timer.elapsed() > (long)this.getGPS().getMaxReconnectTime()) {
                    done = true;
                }
                throw throwable;
            }
            if (timer.elapsed() <= (long)this.getGPS().getMaxReconnectTime()) continue;
            done = true;
        }
        if (success) {
            this.getGPS().setStatus(GPSStatus.RUNNING);
        } else {
            Logger.error("Error while reading from gps: " + this.getGPS().getLastFailure().getMessage());
            this.getGPS().setStatus(GPSStatus.FAILED);
        }
        return success;
    }
}

