/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.composites;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraImageAnnotation;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraTool;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewUtilities;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.FeaturePathAdapter;
import org.eclipse.apogy.common.emf.impl.FeaturePathAdapterCustomImpl;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.NamedSetting;
import org.eclipse.apogy.common.emf.ui.emfforms.ApogyCommonEMFUiEMFFormsFacade;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CameraImageAnnotationListComposite
extends Composite {
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final TreeViewer treeViewer;
    private final Composite emfFormsComposite;
    private final Button btnNew;
    private final Button btnDelete;
    private final Button btnVisible;
    private CameraViewConfiguration cameraViewConfiguration;
    private EStructuralFeature feature;
    private EStructuralFeature listFeature;
    private List<FeaturePathAdapter> featurePathAdapters;

    public CameraImageAnnotationListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(4, false));
        this.setBackground(this.getDisplay().getSystemColor(1));
        this.setBackgroundMode(2);
        this.treeViewer = new TreeViewer((Composite)this);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 2));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CameraImageAnnotationListComposite.this.newSelection();
                CameraImageAnnotationListComposite.this.updateEMFForms();
                if (CameraImageAnnotationListComposite.this.btnVisible != null) {
                    CameraImageAnnotationListComposite.this.btnVisible.setVisible(CameraImageAnnotationListComposite.this.getSelectedCameraImageAnnotation() != null);
                }
            }
        });
        Composite buttonComposite = new Composite((Composite)this, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 128, false, true, 1, 2));
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(buttonComposite, 0);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NamedSetting namedSettings = ApogyCommonEMFUIFactory.eINSTANCE.createNamedSetting();
                namedSettings.setParent((EObject)CameraImageAnnotationListComposite.this.getCameraViewConfiguration().eGet(CameraImageAnnotationListComposite.this.feature));
                namedSettings.setContainingFeature((ETypedElement)CameraImageAnnotationListComposite.this.listFeature);
                ApogyEObjectWizard wizard = new ApogyEObjectWizard((EReference)CameraImageAnnotationListComposite.this.listFeature, (EObject)CameraImageAnnotationListComposite.this.getCameraViewConfiguration().eGet(CameraImageAnnotationListComposite.this.feature), (EClassSettings)namedSettings, null);
                WizardDialog dialog = new WizardDialog(CameraImageAnnotationListComposite.this.getShell(), (IWizard)wizard);
                dialog.open();
                if (wizard.getCreatedEObject() instanceof CameraTool) {
                    CameraTool cameraTool = (CameraTool)wizard.getCreatedEObject();
                    cameraTool.initializeCamera(CameraImageAnnotationListComposite.this.getCameraViewConfiguration().getCamera());
                }
                CameraImageAnnotationListComposite.this.treeViewer.refresh();
                CameraImageAnnotationListComposite.this.updateEMFForms();
            }
        });
        this.btnDelete = new Button(buttonComposite, 0);
        this.btnDelete.setText("Delete");
        this.btnDelete.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CameraImageAnnotationListComposite.this.getSelectedCameraImageAnnotation() != null) {
                    CameraImageAnnotation cameraImageAnnotation = CameraImageAnnotationListComposite.this.getSelectedCameraImageAnnotation();
                    if (cameraImageAnnotation instanceof CameraTool) {
                        CameraTool cameraTool = (CameraTool)cameraImageAnnotation;
                        CameraViewUtilities.INSTANCE.removeCameraTool(CameraImageAnnotationListComposite.this.getCameraViewConfiguration(), cameraTool);
                    } else {
                        ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)CameraImageAnnotationListComposite.this.getCameraViewConfiguration().eGet(CameraImageAnnotationListComposite.this.feature), CameraImageAnnotationListComposite.this.listFeature, (Object)CameraImageAnnotationListComposite.this.getSelectedCameraImageAnnotation());
                    }
                }
            }
        });
        Label separator = new Label((Composite)this, 2);
        separator.setLayoutData((Object)new GridData(4, 4, false, true, 1, 2));
        Composite toggleVisibleComposite = new Composite((Composite)this, 0);
        toggleVisibleComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        toggleVisibleComposite.setLayout((Layout)new GridLayout(1, false));
        this.btnVisible = new Button(toggleVisibleComposite, 0);
        this.btnVisible.setText("Toggle visible");
        this.btnVisible.setLayoutData((Object)new GridData(16384, 4, false, true, 1, 1));
        this.btnVisible.setVisible(false);
        this.btnVisible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CameraImageAnnotationListComposite.this.getSelectedCameraImageAnnotation() != null) {
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)CameraImageAnnotationListComposite.this.getSelectedCameraImageAnnotation(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_IMAGE_ANNOTATION__VISIBLE, (Object)(!CameraImageAnnotationListComposite.this.getSelectedCameraImageAnnotation().isVisible() ? 1 : 0));
                }
            }
        });
        ScrolledComposite scrolledComposite = new ScrolledComposite((Composite)this, 768);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.emfFormsComposite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)this.emfFormsComposite);
        scrolledComposite.setMinSize(this.emfFormsComposite.computeSize(-1, -1));
        this.updateEMFForms();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CameraImageAnnotationListComposite.this.cameraViewConfiguration != null) {
                    for (FeaturePathAdapter adapter : CameraImageAnnotationListComposite.this.getFeaturePathAdapter()) {
                        adapter.dispose();
                    }
                }
                CameraImageAnnotationListComposite.this.newSelection();
                CameraImageAnnotationListComposite.this.updateEMFForms();
                if (CameraImageAnnotationListComposite.this.btnVisible != null) {
                    CameraImageAnnotationListComposite.this.btnVisible.setVisible(CameraImageAnnotationListComposite.this.getSelectedCameraImageAnnotation() != null);
                }
            }
        });
    }

    private void updateEMFForms() {
        Control[] controlArray = this.emfFormsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        ApogyCommonEMFUiEMFFormsFacade.INSTANCE.createEMFForms(this.emfFormsComposite, (EObject)this.getSelectedCameraImageAnnotation(), "No compatible selection");
        ((ScrolledComposite)this.emfFormsComposite.getParent()).setMinSize(this.emfFormsComposite.computeSize(-1, -1));
    }

    protected void newSelection() {
    }

    public CameraImageAnnotation getSelectedCameraImageAnnotation() {
        Object object;
        if (this.treeViewer.getStructuredSelection() != null && this.treeViewer.getStructuredSelection().getFirstElement() != null && (object = this.treeViewer.getStructuredSelection().getFirstElement()) instanceof CameraImageAnnotation) {
            return (CameraImageAnnotation)object;
        }
        return null;
    }

    public CameraViewConfiguration getCameraViewConfiguration() {
        return this.cameraViewConfiguration;
    }

    public void setCameraViewConfiguration(CameraViewConfiguration cameraViewConfiguration, EStructuralFeature feature) {
        if (this.cameraViewConfiguration != null) {
            for (FeaturePathAdapter adapter : this.getFeaturePathAdapter()) {
                adapter.dispose();
            }
        }
        this.cameraViewConfiguration = cameraViewConfiguration;
        this.feature = feature;
        if (this.cameraViewConfiguration != null && this.feature != null) {
            EList eRefs = ApogyCommonEMFFacade.INSTANCE.getSettableEReferences((EObject)this.cameraViewConfiguration.eGet(feature));
            for (EReference reference : eRefs) {
                if (!reference.isMany()) continue;
                this.listFeature = reference;
            }
            this.treeViewer.setInput(this.cameraViewConfiguration.eGet(this.feature));
            for (FeaturePathAdapter adapter : this.getFeaturePathAdapter()) {
                adapter.init((EObject)this.cameraViewConfiguration);
            }
            this.btnNew.setEnabled(true);
            this.btnDelete.setEnabled(true);
        } else {
            this.treeViewer.setInput(null);
            this.btnNew.setEnabled(false);
            this.btnDelete.setEnabled(false);
        }
    }

    private List<FeaturePathAdapter> getFeaturePathAdapter() {
        if (this.featurePathAdapters == null) {
            this.featurePathAdapters = new ArrayList<FeaturePathAdapter>();
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(CameraImageAnnotationListComposite.this.feature);
                    list.add(CameraImageAnnotationListComposite.this.listFeature);
                    list.add(ApogyCommonEMFPackage.Literals.NAMED__NAME);
                    return list;
                }

                public void notifyChanged(Notification msg) {
                    CameraImageAnnotationListComposite.this.treeViewer.refresh();
                }
            });
            this.featurePathAdapters.add((FeaturePathAdapter)new FeaturePathAdapterCustomImpl(){

                public List<? extends EStructuralFeature> getFeatureList() {
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(CameraImageAnnotationListComposite.this.feature);
                    list.add(CameraImageAnnotationListComposite.this.listFeature);
                    list.add(ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_IMAGE_ANNOTATION__VISIBLE);
                    return list;
                }

                public void notifyChanged(Notification msg) {
                    CameraImageAnnotationListComposite.this.treeViewer.refresh();
                }
            });
        }
        return this.featurePathAdapters;
    }

    protected AdapterFactoryContentProvider getContentProvider() {
        return new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                if (CameraImageAnnotationListComposite.this.cameraViewConfiguration != null && CameraImageAnnotationListComposite.this.cameraViewConfiguration.eGet(CameraImageAnnotationListComposite.this.feature) != null && ((EObject)CameraImageAnnotationListComposite.this.cameraViewConfiguration.eGet(CameraImageAnnotationListComposite.this.feature)).eGet(CameraImageAnnotationListComposite.this.listFeature) != null) {
                    return ((EList)((EObject)CameraImageAnnotationListComposite.this.cameraViewConfiguration.eGet(CameraImageAnnotationListComposite.this.feature)).eGet(CameraImageAnnotationListComposite.this.listFeature)).toArray();
                }
                return null;
            }

            public Object[] getChildren(Object object) {
                return null;
            }
        };
    }

    protected AdapterFactoryLabelProvider getLabelProvider() {
        return new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory){

            public String getText(Object object) {
                if (object instanceof CameraImageAnnotation) {
                    CameraImageAnnotation annotation = (CameraImageAnnotation)object;
                    String label = annotation.getName();
                    if (annotation.isVisible()) {
                        label = String.valueOf(label) + " <visible>";
                    }
                    return label;
                }
                return "";
            }

            public Image getImage(Object object) {
                return super.getImage(object);
            }
        };
    }
}

