/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.parts;

import java.util.Collections;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraFactory;
import org.eclipse.apogy.addons.sensors.imaging.camera.ApogyAddonsSensorsImagingCameraPackage;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfiguration;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewConfigurationReference;
import org.eclipse.apogy.addons.sensors.imaging.camera.CameraViewUtilities;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.CameraViewComposite;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.parts.ToolBarMenuPart;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.invocator.ui.ApogyCoreInvocatorUIFacade;
import org.eclipse.apogy.core.invocator.ui.parts.AbstractSessionBasedPart;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.widgets.Composite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CameraViewPart
extends AbstractSessionBasedPart
implements ToolBarMenuPart {
    private static final Logger Logger = LoggerFactory.getLogger(CameraViewPart.class);
    public static final String CameraViewConfigurationID = "CameraViewConfiguration";
    protected String partName = "Camera View";
    private CameraViewConfiguration cameraViewConfiguration;
    @Inject
    ECommandService commandService;
    @Inject
    EHandlerService handlerService;

    @PostConstruct
    public void createPartControl(Composite parent, MPerspective perspective) {
        super.createPartControl(parent, perspective);
    }

    protected void newInvocatorSession(InvocatorSession invocatorSession) {
        CameraViewComposite cameraViewComposite = (CameraViewComposite)this.getActualComposite();
        cameraViewComposite.setCameraViewConfigurationList(CameraViewUtilities.INSTANCE.getActiveCameraViewConfigurationList());
        if (invocatorSession != null) {
            CameraViewConfigurationReference ref = (CameraViewConfigurationReference)ApogyCoreInvocatorUIFacade.INSTANCE.readFromPersistedState(this.mPart, CameraViewConfigurationID);
            if (ref != null) {
                this.cameraViewConfiguration = ref.getCameraViewConfiguration();
            } else {
                Logger.warn("No Camera View Configuration could be read back, setting it to null.");
            }
            cameraViewComposite.setCameraViewConfiguration(this.cameraViewConfiguration);
        }
    }

    protected void createContentComposite(Composite parent, int style) {
        new CameraViewComposite(parent, style){

            @Override
            protected void newCameraViewConfigurationSelected(CameraViewConfiguration newCameraViewConfiguration) {
                CameraViewPart.this.cameraViewConfiguration = newCameraViewConfiguration;
                CameraViewPart.this.selectionService.setSelection((Object)CameraViewPart.this.cameraViewConfiguration);
                if (CameraViewPart.this.cameraViewConfiguration != null) {
                    CameraViewPart.this.mPart.setLabel(String.valueOf(CameraViewPart.this.partName) + " - " + CameraViewPart.this.cameraViewConfiguration.getName());
                }
                ParameterizedCommand command = CameraViewPart.this.commandService.createCommand("org.eclipse.apogy.addons.sensors.imaging.camera.command.updateCameraViewToolbar", Collections.emptyMap());
                CameraViewPart.this.handlerService.executeHandler(command);
            }

            @Override
            protected void newTabFolderSelection(String parameterID) {
                HashMap<String, String> parameters = new HashMap<String, String>(1);
                parameters.put("org.eclipse.apogy.common.ui.opentoolbarmenu.commandparameter.ID", parameterID);
                ParameterizedCommand command = CameraViewPart.this.commandService.createCommand("org.eclipse.apogy.common.ui.command.openToolBarMenu", parameters);
                CameraViewPart.this.handlerService.executeHandler(command);
            }
        };
    }

    public void userPersistState(MPart mPart) {
        try {
            if (this.cameraViewConfiguration != null) {
                CameraViewConfigurationReference ref = ApogyAddonsSensorsImagingCameraFactory.eINSTANCE.createCameraViewConfigurationReference();
                ref.setCameraViewConfiguration(this.cameraViewConfiguration);
                ApogyCoreInvocatorUIFacade.INSTANCE.saveToPersistedState(mPart, CameraViewConfigurationID, (EObject)ref);
            }
            mPart.setLabel(this.partName);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    public void setDisplayRectifiedImage(boolean value) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)((CameraViewComposite)this.getActualComposite()).getSelectedCameraViewConfiguration(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__DISPLAY_RECTIFIED_IMAGE, (Object)value);
    }

    public void setImageAutoSaveEnable(boolean value) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)((CameraViewComposite)this.getActualComposite()).getSelectedCameraViewConfiguration(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__IMAGE_AUTO_SAVE_ENABLE, (Object)value);
    }

    public void setSaveImageWithOverlays(boolean value) {
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)((CameraViewComposite)this.getActualComposite()).getSelectedCameraViewConfiguration(), (EStructuralFeature)ApogyAddonsSensorsImagingCameraPackage.Literals.CAMERA_VIEW_CONFIGURATION__SAVE_IMAGE_WITH_OVERLAYS, (Object)value);
    }

    public void toolItemSelectedChanged(String parameterID, boolean selected) {
        ((CameraViewComposite)this.getActualComposite()).updatetoolbarMenuComposite(parameterID, selected);
    }

    public boolean canExecute() {
        return this.getActualComposite() instanceof CameraViewComposite && ((CameraViewComposite)this.getActualComposite()).getSelectedCameraViewConfiguration() != null;
    }
}

