/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.wizards;

import org.eclipse.apogy.addons.sensors.imaging.camera.ContrastAndBrightnessFilter;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.ContrastAndBrightnessFilterComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ContrastAndBrightnessFilterWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.imaging.camera.wizards.ContrastAndBrightnessFilterWizardPage";
    private final ContrastAndBrightnessFilter contrastAndBrightnessFilter;
    private ContrastAndBrightnessFilterComposite contrastAndBrightnessFilterComposite;
    private DataBindingContext m_bindingContext;

    public ContrastAndBrightnessFilterWizardPage(ContrastAndBrightnessFilter contrastAndBrightnessFilter) {
        super(WIZARD_PAGE_ID);
        this.contrastAndBrightnessFilter = contrastAndBrightnessFilter;
        this.setTitle("Contrast and Brightness Filter.");
        this.setDescription("Select filter settings.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.contrastAndBrightnessFilterComposite = new ContrastAndBrightnessFilterComposite(top, 0){

            @Override
            protected void newContrastSelected(double contrast) {
                ContrastAndBrightnessFilterWizardPage.this.validate();
            }

            @Override
            protected void newBrightnessSelected(double brightness) {
                ContrastAndBrightnessFilterWizardPage.this.validate();
            }
        };
        this.contrastAndBrightnessFilterComposite.setLayoutData(new GridData(4, 4, true, true));
        this.contrastAndBrightnessFilterComposite.setContrastAndBrightnessFilter(this.contrastAndBrightnessFilter);
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ContrastAndBrightnessFilterWizardPage.this.m_bindingContext != null) {
                    ContrastAndBrightnessFilterWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.contrastAndBrightnessFilter.getBrightness() < 0.0) {
            this.setErrorMessage("Invalid brightness specified ! Must be greater than zero.");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

