/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.camera.wizards;

import java.text.DecimalFormat;
import org.eclipse.apogy.addons.sensors.imaging.camera.EMFFeatureOverlay;
import org.eclipse.apogy.addons.sensors.imaging.camera.composites.EMFFeatureOverlayComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class EMFFeatureOverlayWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.sensors.imaging.camera.wizards.EMFFeatureOverlayWizardPage";
    private final EMFFeatureOverlay emfFeatureOverlay;
    private EMFFeatureOverlayComposite emfFeatureOverlayComposite;
    private DataBindingContext m_bindingContext;

    public EMFFeatureOverlayWizardPage(EMFFeatureOverlay emfFeatureOverlay) {
        super(WIZARD_PAGE_ID);
        this.emfFeatureOverlay = emfFeatureOverlay;
        this.setTitle("EMF Feature Overlay.");
        this.setDescription("Select the feature to display.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.emfFeatureOverlayComposite = new EMFFeatureOverlayComposite(top, 2048){

            @Override
            protected void newVariableFeatureReferenceSelected(ISelection selection) {
                EMFFeatureOverlayWizardPage.this.validate();
            }

            @Override
            protected void newNumberFormatSelected(String numberFormat) {
                EMFFeatureOverlayWizardPage.this.validate();
            }
        };
        this.emfFeatureOverlayComposite.setLayoutData(new GridData(4, 4, true, true));
        this.emfFeatureOverlayComposite.setEmfFeatureOverlay(this.emfFeatureOverlay);
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EMFFeatureOverlayWizardPage.this.m_bindingContext != null) {
                    EMFFeatureOverlayWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.emfFeatureOverlay.getVariableFeatureReference().getVariable() == null) {
            this.setErrorMessage("No variable selected !");
        }
        if (this.emfFeatureOverlay.getNumberFormat() == null) {
            this.setErrorMessage("Number format is not defined !");
        } else {
            try {
                DecimalFormat format = new DecimalFormat(this.emfFeatureOverlay.getNumberFormat());
                format.format(1.234);
            }
            catch (Throwable t) {
                this.setErrorMessage("Invalid number format specified !");
            }
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

