/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.imaging.ui.composites;

import org.eclipse.apogy.addons.sensors.imaging.AbstractCamera;
import org.eclipse.apogy.addons.sensors.imaging.ImageSnapshot;
import org.eclipse.apogy.addons.sensors.imaging.RectifiedImageSnapshot;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ui.ImageProvider;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class CameraImageComposite
extends Composite
implements ImageProvider {
    private AbstractCamera camera = null;
    private Adapter abstractCameraAdapter = null;
    private boolean displayRectifiedImage = true;
    private ImageDisplayComposite imageDisplayComposite = null;
    private Button showRectifiedButton = null;
    private ImageSnapshot imageSnapshot = null;
    private AbstractEImage abstractEImage = null;

    public CameraImageComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, true));
        this.showRectifiedButton = new Button((Composite)this, 32);
        GridData gridData1 = new GridData(0x1000000, 0x1000000, false, false);
        this.showRectifiedButton.setLayoutData((Object)gridData1);
        this.showRectifiedButton.setText("Show Rectified Image");
        this.showRectifiedButton.setToolTipText("Show Rectified Image if available.");
        this.showRectifiedButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CameraImageComposite.this.setDisplayRectifiedImage(CameraImageComposite.this.showRectifiedButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.imageDisplayComposite = new ImageDisplayComposite((Composite)this, 2048);
        GridData gridData2 = new GridData(4, 4, true, true);
        this.imageDisplayComposite.setLayoutData((Object)gridData2);
        this.setDisplayRectifiedImage(this.showRectifiedButton.getSelection());
    }

    public AbstractCamera getCamera() {
        return this.camera;
    }

    public AbstractEImage getImage() {
        return this.abstractEImage;
    }

    public void setCamera(AbstractCamera newCamera) {
        if (this.camera != null) {
            this.camera.eAdapters().remove((Object)this.getAbstractCameraAdapter());
        }
        this.camera = newCamera;
        if (newCamera != null) {
            if (this.getCamera().getLatestImageSnapshot() != null) {
                this.imageSnapshot = this.getCamera().getLatestImageSnapshot();
                this.updateDisplayedImage(this.getCamera().getLatestImageSnapshot().getImage());
            }
            newCamera.eAdapters().add((Object)this.getAbstractCameraAdapter());
        }
    }

    public boolean isDisplayRectifiedImage() {
        return this.displayRectifiedImage;
    }

    public void setDisplayRectifiedImage(boolean displayRectifiedImage) {
        this.displayRectifiedImage = displayRectifiedImage;
        if (displayRectifiedImage) {
            if (this.imageSnapshot instanceof RectifiedImageSnapshot) {
                RectifiedImageSnapshot rectifiedImageSnapshot = (RectifiedImageSnapshot)this.imageSnapshot;
                this.updateDisplayedImage(rectifiedImageSnapshot.getRectifiedImage());
                this.abstractEImage = rectifiedImageSnapshot.getRectifiedImage();
            }
        } else if (this.imageSnapshot instanceof ImageSnapshot) {
            this.updateDisplayedImage(this.imageSnapshot.getImage());
            this.abstractEImage = this.imageSnapshot.getImage();
        }
    }

    protected void updateDisplayedImage(final AbstractEImage newImage) {
        this.abstractEImage = newImage;
        if (this.imageDisplayComposite != null && !this.imageDisplayComposite.isDisposed() && newImage != null) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (newImage.asBufferedImage() != null) {
                        ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(newImage.asBufferedImage());
                        CameraImageComposite.this.imageDisplayComposite.setImageData(imageData);
                    }
                }
            });
        }
    }

    protected Adapter getAbstractCameraAdapter() {
        if (this.abstractCameraAdapter == null) {
            this.abstractCameraAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(AbstractCamera.class) == 7) {
                        if (CameraImageComposite.this.isDisplayRectifiedImage() && msg.getNewValue() instanceof RectifiedImageSnapshot) {
                            RectifiedImageSnapshot rectifiedImageSnapshot = (RectifiedImageSnapshot)msg.getNewValue();
                            CameraImageComposite.this.updateDisplayedImage(rectifiedImageSnapshot.getRectifiedImage());
                            CameraImageComposite.this.imageSnapshot = (ImageSnapshot)rectifiedImageSnapshot;
                        } else if (msg.getNewValue() instanceof ImageSnapshot) {
                            ImageSnapshot newImageSnapshot = (ImageSnapshot)msg.getNewValue();
                            CameraImageComposite.this.updateDisplayedImage(newImageSnapshot.getImage());
                            CameraImageComposite.this.imageSnapshot = newImageSnapshot;
                        } else {
                            CameraImageComposite.this.updateDisplayedImage(null);
                            CameraImageComposite.this.imageSnapshot = null;
                        }
                    }
                }
            };
        }
        return this.abstractCameraAdapter;
    }
}

