/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors.pose;

import javax.media.j3d.Transform3D;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFacade;
import org.eclipse.apogy.common.geometry.data3d.Pose;
import org.eclipse.apogy.common.math.GeometricUtils;

public class PoseUtils {
    public static Transform3D getTransformFromSensorFrameToNewPose(Pose currentPoseInSensorFrame, Pose newCurrentPose) {
        Matrix4d currentPoseMatrix = GeometricUtils.packXYZ((double)currentPoseInSensorFrame.getX(), (double)currentPoseInSensorFrame.getY(), (double)currentPoseInSensorFrame.getZ(), (double)currentPoseInSensorFrame.getXRotation(), (double)currentPoseInSensorFrame.getYRotation(), (double)currentPoseInSensorFrame.getZRotation());
        Transform3D currentPose = new Transform3D(currentPoseMatrix);
        Matrix4d newPoseMatrix = GeometricUtils.packXYZ((double)newCurrentPose.getX(), (double)newCurrentPose.getY(), (double)newCurrentPose.getZ(), (double)newCurrentPose.getXRotation(), (double)newCurrentPose.getYRotation(), (double)newCurrentPose.getZRotation());
        Transform3D newPose = new Transform3D(newPoseMatrix);
        Transform3D invertedCurrentPose = new Transform3D(currentPose);
        invertedCurrentPose.invert();
        newPose.mul(invertedCurrentPose);
        return newPose;
    }

    public static Pose applyTransform(Transform3D transform, Pose initialPose) {
        Transform3D initialPoseTransform = new Transform3D(GeometricUtils.packXYZ((double)initialPose.getX(), (double)initialPose.getY(), (double)initialPose.getZ(), (double)initialPose.getXRotation(), (double)initialPose.getYRotation(), (double)initialPose.getZRotation()));
        Transform3D t = new Transform3D(transform);
        t.mul(initialPoseTransform);
        Matrix3d rot = new Matrix3d();
        t.get(rot);
        Vector3d rotation = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)rot);
        Vector3d position = new Vector3d();
        t.get(position);
        Pose pose = ApogyCommonGeometryData3DFacade.INSTANCE.createPose(position.x, position.y, position.z, rotation.x, rotation.y, rotation.z);
        return pose;
    }
}

