/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.sensors;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SensorStatus implements Enumerator
{
    OFF(0, "OFF", "OFF"),
    READY(1, "READY", "READY"),
    BUSY(2, "BUSY", "BUSY"),
    FAILED(3, "FAILED", "FAILED");

    public static final int OFF_VALUE = 0;
    public static final int READY_VALUE = 1;
    public static final int BUSY_VALUE = 2;
    public static final int FAILED_VALUE = 3;
    private static final SensorStatus[] VALUES_ARRAY;
    public static final List<SensorStatus> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new SensorStatus[]{OFF, READY, BUSY, FAILED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static SensorStatus get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SensorStatus result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SensorStatus getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            SensorStatus result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static SensorStatus get(int value) {
        switch (value) {
            case 0: {
                return OFF;
            }
            case 1: {
                return READY;
            }
            case 2: {
                return BUSY;
            }
            case 3: {
                return FAILED;
            }
        }
        return null;
    }

    private SensorStatus(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

