/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.converters.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.converters.ChainedConverter;
import org.eclipse.apogy.common.converters.ChainedFileExporter;
import org.eclipse.apogy.common.converters.ConverterEdge;
import org.eclipse.apogy.common.converters.IConverter;
import org.eclipse.apogy.common.converters.IFileExporter;
import org.eclipse.apogy.common.converters.TypeCastConverter;
import org.eclipse.apogy.common.converters.impl.ApogyCommonConvertersGraphsFacadeImpl;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.KShortestPaths;
import org.jgrapht.graph.SimpleDirectedWeightedGraph;

public class ApogyCommonConvertersGraphsFacadeCustomImpl
extends ApogyCommonConvertersGraphsFacadeImpl {
    @Override
    public synchronized SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> createGraph(List<IConverter> converters) {
        SimpleDirectedWeightedGraph simpleDirectedWeightedGraph = new SimpleDirectedWeightedGraph<Class<?>, ConverterEdge>(ConverterEdge.class){
            private static final long serialVersionUID = 8784085872291647017L;

            public double getEdgeWeight(ConverterEdge e) {
                return 1.0;
            }
        };
        this.addConverters(simpleDirectedWeightedGraph, converters);
        return simpleDirectedWeightedGraph;
    }

    @Override
    public synchronized void addConverters(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph, List<IConverter> converters) {
        Iterator<IConverter> itConverters = converters.iterator();
        HashSet typeSet = new HashSet();
        while (itConverters.hasNext()) {
            IConverter converter = itConverters.next();
            typeSet.add(converter.getInputType());
            typeSet.add(converter.getOutputType());
        }
        Iterator typeIt = typeSet.iterator();
        while (typeIt.hasNext()) {
            graph.addVertex((Object)((Class)typeIt.next()));
        }
        for (IConverter converter : converters) {
            ConverterEdge edge = new ConverterEdge(converter.getInputType(), converter.getOutputType(), converter);
            graph.addEdge(converter.getInputType(), converter.getOutputType(), (Object)edge);
        }
    }

    @Override
    public synchronized List<IConverter> generateTypeCastConverters(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph) {
        ArrayList<IConverter> castConverters = new ArrayList<IConverter>();
        ArrayList vertices = new ArrayList();
        vertices.addAll(graph.vertexSet());
        for (Class currentVertex : graph.vertexSet()) {
            vertices = new ArrayList();
            vertices.addAll(graph.vertexSet());
            for (Class potentialSuperType : vertices) {
                if (potentialSuperType == currentVertex || !potentialSuperType.isAssignableFrom(currentVertex)) continue;
                boolean converterAlreadyExist = false;
                Set outgoingEdges = graph.outgoingEdgesOf((Object)currentVertex);
                Iterator outIterator = outgoingEdges.iterator();
                while (outIterator.hasNext() && !converterAlreadyExist) {
                    ConverterEdge edge = (ConverterEdge)outIterator.next();
                    if (edge.getTo() != potentialSuperType) continue;
                    converterAlreadyExist = true;
                }
                if (converterAlreadyExist) continue;
                TypeCastConverter converter = new TypeCastConverter(currentVertex, potentialSuperType);
                castConverters.add(converter);
            }
        }
        return castConverters;
    }

    @Override
    public synchronized Object convert(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph, Object input, Class<?> outputType) {
        Object result = null;
        if (input != null) {
            List<Class<?>> potentialSources = this.getSourceVertex(graph, input.getClass());
            List<Class<?>> potentialDestination = this.getDestinationVertex(graph, outputType);
            Iterator<Class<?>> sourcesIterator = potentialSources.iterator();
            while (sourcesIterator.hasNext() && result == null) {
                Class<?> sourceVertex = sourcesIterator.next();
                Iterator<Class<?>> destinationIterator = potentialDestination.iterator();
                while (destinationIterator.hasNext() && result == null) {
                    Class<?> destinationVertex = destinationIterator.next();
                    SortedSet<ChainedConverter> convertersSet = this.findAllConvertersBetweenVertices(graph, sourceVertex, destinationVertex);
                    Iterator it = convertersSet.iterator();
                    while (it.hasNext() && result == null) {
                        try {
                            ChainedConverter converter = (ChainedConverter)it.next();
                            result = converter.convert(input);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return result;
    }

    @Override
    public synchronized SortedSet<ChainedConverter> findAllConvertersBetweenVertices(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph, Class<?> inputType, Class<?> outputType) {
        TreeSet<ChainedConverter> convertersSet = new TreeSet<ChainedConverter>(this.createComparator());
        KShortestPaths kShortestPaths = new KShortestPaths(graph, inputType, 10);
        List shortestPath = kShortestPaths.getPaths(outputType);
        if (shortestPath != null) {
            for (GraphPath graphPath : shortestPath) {
                if (graphPath.getEdgeList() == null) continue;
                ArrayList<IConverter> converters = new ArrayList<IConverter>();
                for (ConverterEdge edge : graphPath.getEdgeList()) {
                    IConverter converter = edge.getConverter();
                    converters.add(converter);
                }
                convertersSet.add(new ChainedConverter(converters));
            }
        }
        return convertersSet;
    }

    @Override
    public synchronized ChainedConverter findConverter(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph, Class<?> inputType, Class<?> outputType) {
        try {
            SortedSet<ChainedConverter> converters = this.findAllConvertersBetweenVertices(graph, inputType, outputType);
            if (!converters.isEmpty()) {
                return converters.first();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public synchronized Set<Class<?>> getAllInputTypes(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph) {
        HashSet inputTypes = new HashSet();
        for (ConverterEdge edge : graph.edgeSet()) {
            inputTypes.add(edge.getFrom());
        }
        return inputTypes;
    }

    @Override
    public synchronized Set<Class<?>> getAllOutputTypes(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph) {
        HashSet inputTypes = new HashSet();
        for (ConverterEdge edge : graph.edgeSet()) {
            inputTypes.add(edge.getTo());
        }
        return inputTypes;
    }

    @Override
    public synchronized List<Class<?>> getSourceVertex(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph, Class<?> inputType) {
        ArrayList potentialSourceVertices = new ArrayList();
        ArrayList classes = new ArrayList();
        classes.addAll(this.getAllInputTypes(graph));
        boolean done = false;
        while (classes.size() > 0 && !done) {
            Class<?> bestMatch = this.findClosestSuperType(classes, inputType);
            if (bestMatch != null) {
                potentialSourceVertices.add(bestMatch);
                classes.remove(bestMatch);
                continue;
            }
            done = true;
        }
        return potentialSourceVertices;
    }

    @Override
    public synchronized List<Class<?>> getDestinationVertex(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph, Class<?> outputType) {
        ArrayList potentialDestinationVertices = new ArrayList();
        ArrayList classes = new ArrayList();
        classes.addAll(this.getAllOutputTypes(graph));
        boolean done = false;
        while (classes.size() > 0 && !done) {
            Class<?> bestMatch = this.findClosestSubType(classes, outputType);
            if (bestMatch != null) {
                potentialDestinationVertices.add(bestMatch);
                classes.remove(bestMatch);
                continue;
            }
            done = true;
        }
        return potentialDestinationVertices;
    }

    @Override
    public synchronized Class<?> findClosestSuperType(List<Class<?>> classes, Class<?> targetType) {
        Class<?> closestMatch = null;
        for (Class<?> c : classes) {
            if (!c.isAssignableFrom(targetType) || closestMatch != null && !closestMatch.isAssignableFrom(c)) continue;
            closestMatch = c;
        }
        return closestMatch;
    }

    @Override
    public synchronized Class<?> findClosestSubType(List<Class<?>> classes, Class<?> targetType) {
        Class<?> closestMatch = null;
        for (Class<?> c : classes) {
            if (!targetType.isAssignableFrom(c) || closestMatch != null && !c.isAssignableFrom(closestMatch)) continue;
            closestMatch = c;
        }
        return closestMatch;
    }

    @Override
    public synchronized List<IConverter> getAllConverters(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph) {
        ArrayList<IConverter> converters = new ArrayList<IConverter>();
        for (ConverterEdge edge : graph.edgeSet()) {
            converters.add(edge.getConverter());
        }
        return converters;
    }

    @Override
    public synchronized List<IConverter> getAllNonTypeCastConverters(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph) {
        ArrayList<IConverter> converters = new ArrayList<IConverter>();
        for (ConverterEdge edge : graph.edgeSet()) {
            if (edge.getConverter() instanceof TypeCastConverter) continue;
            converters.add(edge.getConverter());
        }
        return converters;
    }

    @Override
    public synchronized Map<Class<?>, List<Class<?>>> getAvailableDestinationTypeMap(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph) {
        HashMap map = new HashMap();
        Set<Class<?>> inputTypes = this.getAllInputTypes(graph);
        for (Class<?> inputType : inputTypes) {
            ArrayList outputTypes = new ArrayList();
            Set<Class<?>> graphOutputTypes = this.getAllOutputTypes(graph);
            for (Class<?> outputType : graphOutputTypes) {
                ChainedConverter c;
                if (outputType == inputType || (c = this.findConverter(graph, inputType, outputType)) == null) continue;
                outputTypes.add(outputType);
            }
            map.put(inputType, outputTypes);
        }
        return map;
    }

    @Override
    public synchronized Comparator<ChainedConverter> createComparator() {
        Comparator<ChainedConverter> comparator = new Comparator<ChainedConverter>(){

            @Override
            public int compare(ChainedConverter o1, ChainedConverter o2) {
                if (o1.getChainSize() < o2.getChainSize()) {
                    return -1;
                }
                if (o1.getChainSize() > o2.getChainSize()) {
                    return 1;
                }
                return o1.getClass().getName().compareTo(o2.getClass().getName());
            }
        };
        return comparator;
    }

    @Override
    public IFileExporter findIFileExporter(SimpleDirectedWeightedGraph<Class<?>, ConverterEdge> graph, Object input) {
        ChainedFileExporter iFileExporter = null;
        if (input != null) {
            Class<?> inputType = input.getClass();
            Class<File> outputType = File.class;
            List<Class<?>> potentialSources = this.getSourceVertex(graph, inputType);
            List<Class<?>> potentialDestination = this.getDestinationVertex(graph, outputType);
            Iterator<Class<?>> sourcesIterator = potentialSources.iterator();
            Object result = null;
            while (sourcesIterator.hasNext() && iFileExporter == null) {
                Class<?> sourceVertex = sourcesIterator.next();
                Iterator<Class<?>> destinationIterator = potentialDestination.iterator();
                while (destinationIterator.hasNext() && iFileExporter == null) {
                    Class<?> destinationVertex = destinationIterator.next();
                    SortedSet<ChainedConverter> convertersSet = this.findAllConvertersBetweenVertices(graph, sourceVertex, destinationVertex);
                    Iterator it = convertersSet.iterator();
                    while (it.hasNext() && iFileExporter == null) {
                        try {
                            ChainedConverter converter = (ChainedConverter)it.next();
                            result = converter.convert(input);
                            if (result == null) continue;
                            iFileExporter = new ChainedFileExporter(converter.getConverters());
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        return iFileExporter;
    }
}

