/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.emfforms.renderers;

import javax.inject.Inject;
import javax.vecmath.Color3f;
import org.eclipse.apogy.common.emf.ui.emfforms.renderers.AbstractColorControlSWTRenderer;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.template.model.VTViewTemplateProvider;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.core.services.label.EMFFormsLabelProvider;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Color3fControlSWTRenderer
extends AbstractColorControlSWTRenderer {
    private static final Logger Logger = LoggerFactory.getLogger(Color3fControlSWTRenderer.class);

    @Inject
    public Color3fControlSWTRenderer(VControl vElement, ViewModelContext viewContext, ReportService reportService, EMFFormsDatabinding emfFormsDatabinding, EMFFormsLabelProvider emfFormsLabelProvider, VTViewTemplateProvider vtViewTemplateProvider) {
        super(vElement, viewContext, reportService, emfFormsDatabinding, emfFormsLabelProvider, vtViewTemplateProvider);
    }

    @Override
    protected RGB getRGB() {
        Object obj = this.getValue();
        if (obj instanceof Color3f) {
            Color3f color = (Color3f)obj;
            int red = Math.round(255.0f * color.getX());
            int green = Math.round(255.0f * color.getY());
            int blue = Math.round(255.0f * color.getZ());
            if (red >= 0 && green >= 0 && blue >= 0) {
                return new RGB(red, green, blue);
            }
        }
        return null;
    }

    @Override
    protected Object convert(RGB rgb) {
        if (rgb != null) {
            Color3f color = new Color3f((float)rgb.red / 255.0f, (float)rgb.green / 255.0f, (float)rgb.blue / 255.0f);
            return color;
        }
        return this.getNullObj();
    }

    @Override
    protected Object getNullObj() {
        return new Color3f(-1.0f, -1.0f, -1.0f);
    }

    @Override
    protected Object getValue() {
        try {
            Color3f color;
            Object obj = this.getModelValue().getValue();
            if (obj instanceof Color3f && (color = (Color3f)obj).getX() >= 0.0f && color.getY() >= 0.0f && color.getZ() >= 0.0f) {
                return color;
            }
            return null;
        }
        catch (DatabindingFailedException e) {
            Logger.error("Unable to set the RGB value.");
            return null;
        }
    }
}

