/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.apogy.common.databinding.converters.DateToStringConverter;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.BrowseableTimeSource;
import org.eclipse.apogy.common.emf.CollectionTimedTimeSource;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.BrowseableTimeSourceComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class CollectionTimedTimeSourceComposite
extends BrowseableTimeSourceComposite {
    private CollectionTimedTimeSource collectionTimedTimeSource;
    protected Adapter collectionTimedTimeSourceAdapter = null;
    protected Button loopingEnabledButton;
    protected Button jumpToNextButton;
    protected Button jumpToPreviousButton;
    protected Label timeLineStartTimeValueLabel = null;
    protected Label timeLineEndTimeValueLabel = null;
    protected Slider timeScale;

    public CollectionTimedTimeSourceComposite(Composite parent, int style, CollectionTimedTimeSource acceleratedTimeSource) {
        super(parent, style, (BrowseableTimeSource)acceleratedTimeSource);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CollectionTimedTimeSourceComposite.this.collectionTimedTimeSource != null) {
                    CollectionTimedTimeSourceComposite.this.collectionTimedTimeSource.eAdapters().remove((Object)CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSourceAdapter());
                }
                if (CollectionTimedTimeSourceComposite.this.bindingContext != null) {
                    CollectionTimedTimeSourceComposite.this.bindingContext.dispose();
                }
            }
        });
        this.setCollectionTimedTimeSource(acceleratedTimeSource);
    }

    public CollectionTimedTimeSource getCollectionTimedTimeSource() {
        return this.collectionTimedTimeSource;
    }

    public void setCollectionTimedTimeSource(CollectionTimedTimeSource collectionTimedTimeSource) {
        if (this.collectionTimedTimeSource != null) {
            this.collectionTimedTimeSource.eAdapters().remove((Object)this.getCollectionTimedTimeSourceAdapter());
        }
        this.collectionTimedTimeSource = collectionTimedTimeSource;
        if (collectionTimedTimeSource != null) {
            collectionTimedTimeSource.eAdapters().add((Object)this.getCollectionTimedTimeSourceAdapter());
        }
        super.setBrowseableTimeSource((BrowseableTimeSource)collectionTimedTimeSource);
    }

    @Override
    protected void createContent() {
        Composite top = new Composite((Composite)this, 0);
        top.setLayoutData((Object)new GridData(4, 128, true, false));
        top.setLayout((Layout)new GridLayout(1, true));
        Composite setupComposite = this.createSettingsComposite(top, 0);
        setupComposite.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        Composite timeLineComposite = this.createTimeLineComposite(top, 0);
        timeLineComposite.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Composite buttonsComposite = this.createButtonsComposite(top, 0);
        buttonsComposite.setLayoutData((Object)new GridData(16384, 128, true, false, 1, 1));
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
    }

    @Override
    protected Composite createButtonsComposite(Composite parent, int style) {
        Composite buttonsComposite = new Composite(parent, style);
        buttonsComposite.setLayout((Layout)new GridLayout(6, false));
        this.playResetButton = new Button(buttonsComposite, 8);
        GridData resetButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        resetButtonGridData.minimumWidth = 75;
        resetButtonGridData.widthHint = 75;
        this.playResetButton.setLayoutData((Object)resetButtonGridData);
        this.playResetButton.setText("Reset");
        this.playResetButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource().reset();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.jumpToPreviousButton = new Button(buttonsComposite, 8);
        GridData jumpToPreviousButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        jumpToPreviousButtonGridData.minimumWidth = 75;
        jumpToPreviousButtonGridData.widthHint = 75;
        this.jumpToPreviousButton.setLayoutData((Object)jumpToPreviousButtonGridData);
        this.jumpToPreviousButton.setText("Previous");
        this.jumpToPreviousButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSource().jumpToPrevious();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.playReverseButton = new Button(buttonsComposite, 8);
        GridData reverseButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        reverseButtonGridData.minimumWidth = 75;
        reverseButtonGridData.widthHint = 75;
        this.playReverseButton.setLayoutData((Object)reverseButtonGridData);
        this.playReverseButton.setText("Reverse");
        this.playReverseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource().playReverse();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.playPauseButton = new Button(buttonsComposite, 8);
        GridData pauseButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        pauseButtonGridData.minimumWidth = 75;
        pauseButtonGridData.widthHint = 75;
        this.playPauseButton.setLayoutData((Object)pauseButtonGridData);
        this.playPauseButton.setText("Pause");
        this.playPauseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource().pause();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.playForwardButton = new Button(buttonsComposite, 8);
        GridData forwardButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        forwardButtonGridData.minimumWidth = 75;
        forwardButtonGridData.widthHint = 75;
        this.playForwardButton.setLayoutData((Object)forwardButtonGridData);
        this.playForwardButton.setText("Forward");
        this.playForwardButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource().playForward();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.jumpToNextButton = new Button(buttonsComposite, 8);
        GridData jumpToNextButtonGridData = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        jumpToNextButtonGridData.minimumWidth = 75;
        jumpToNextButtonGridData.widthHint = 75;
        this.jumpToNextButton.setLayoutData((Object)jumpToNextButtonGridData);
        this.jumpToNextButton.setText("Next");
        this.jumpToNextButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource() != null) {
                    CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSource().jumpToNext();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return buttonsComposite;
    }

    @Override
    protected Composite createSettingsComposite(Composite parent, int style) {
        Composite settingsComposite = new Composite(parent, 2048);
        settingsComposite.setLayout((Layout)new GridLayout(2, false));
        Label updatePeriodLabel = new Label(settingsComposite, 0);
        updatePeriodLabel.setText("Update period (s):");
        this.updatePeriodSpinner = new Spinner(settingsComposite, 2048);
        this.updatePeriodSpinner.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false, 1, 1));
        GridData updatePeriodSpinnerGridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        updatePeriodSpinnerGridData.widthHint = 100;
        updatePeriodSpinnerGridData.minimumWidth = 100;
        this.updatePeriodSpinner.setLayoutData((Object)updatePeriodSpinnerGridData);
        this.updatePeriodSpinner.setDigits(3);
        this.updatePeriodSpinner.setMinimum(1);
        this.updatePeriodSpinner.setMaximum(60000);
        this.updatePeriodSpinner.setIncrement(1);
        this.updatePeriodSpinner.setSelection(1000);
        this.updatePeriodSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = CollectionTimedTimeSourceComposite.this.updatePeriodSpinner.getSelection();
                int digits = CollectionTimedTimeSourceComposite.this.updatePeriodSpinner.getDigits();
                int period = (int)Math.round((double)selection / Math.pow(10.0, digits) * 1000.0);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__UPDATE_PERIOD, (Object)period);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label timeAccelerationLabel = new Label(settingsComposite, 0);
        timeAccelerationLabel.setText("Time Acceleration:");
        this.timeAccelerationSpinner = new Spinner(settingsComposite, 2048);
        GridData timeAccelerationSpinnerGridData = new GridData(16384, 0x1000000, false, false, 1, 1);
        timeAccelerationSpinnerGridData.widthHint = 100;
        timeAccelerationSpinnerGridData.minimumWidth = 100;
        this.timeAccelerationSpinner.setLayoutData((Object)timeAccelerationSpinnerGridData);
        this.timeAccelerationSpinner.setDigits(1);
        this.timeAccelerationSpinner.setMinimum(1);
        this.timeAccelerationSpinner.setMaximum(100000);
        this.timeAccelerationSpinner.setIncrement(1);
        this.timeAccelerationSpinner.setSelection(100);
        this.timeAccelerationSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = CollectionTimedTimeSourceComposite.this.timeAccelerationSpinner.getSelection();
                int digits = CollectionTimedTimeSourceComposite.this.timeAccelerationSpinner.getDigits();
                float acceleration = (float)((double)selection / Math.pow(10.0, digits));
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)CollectionTimedTimeSourceComposite.this.getBrowseableTimeSource(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.BROWSEABLE_TIME_SOURCE__TIME_ACCERATION, (Object)Float.valueOf(acceleration));
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label loopingEnabledLabel = new Label(settingsComposite, 0);
        loopingEnabledLabel.setText("Loop Enable");
        this.loopingEnabledButton = new Button(settingsComposite, 0x800020);
        this.loopingEnabledButton.setLayoutData((Object)new GridData(0x1000000, 4, true, false, 1, 1));
        return settingsComposite;
    }

    protected Composite createTimeLineComposite(Composite parent, int style) {
        Composite timeLineComposite = new Composite(parent, style);
        timeLineComposite.setLayout((Layout)new GridLayout(3, false));
        Composite composite_1 = new Composite(timeLineComposite, 0);
        composite_1.setLayout((Layout)new GridLayout(2, false));
        Label startTimeLabel = new Label(composite_1, 0);
        startTimeLabel.setText("Start Time:");
        this.timeLineStartTimeValueLabel = new Label(composite_1, 0);
        this.timeLineStartTimeValueLabel.setAlignment(16384);
        this.timeLineStartTimeValueLabel.setText("N/A");
        Composite composite_2 = new Composite(timeLineComposite, 0);
        composite_2.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        composite_2.setLayout((Layout)new GridLayout(2, false));
        Label endTimeLabel = new Label(composite_2, 0);
        endTimeLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        endTimeLabel.setAlignment(131072);
        endTimeLabel.setText("End Time:");
        this.timeLineEndTimeValueLabel = new Label(composite_2, 0);
        this.timeLineEndTimeValueLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false, 1, 1));
        this.timeLineEndTimeValueLabel.setAlignment(131072);
        this.timeLineEndTimeValueLabel.setText("N/A");
        new Label(timeLineComposite, 0);
        this.timeScale = new Slider(timeLineComposite, 256);
        this.timeScale.setDragDetect(true);
        this.timeScale.setThumb(1);
        this.timeScale.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.timeScale.setMinimum(0);
        this.timeScale.setMaximum(100);
        new Label(timeLineComposite, 0);
        this.timeScale.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                if (CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSource() != null) {
                    int selection = CollectionTimedTimeSourceComposite.this.timeScale.getSelection();
                    Date earliest = CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSource().getEarliestDate();
                    Date latest = CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSource().getLatestDate();
                    if (earliest != null && latest != null) {
                        long startTime = earliest.getTime();
                        long endTime = latest.getTime();
                        long delta = Math.round((double)selection / 100.0 * (double)(endTime - startTime));
                        Date selectedTime = new Date(startTime + delta);
                        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSource(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.TIMED__TIME, (Object)selectedTime);
                    }
                }
            }

            public void mouseDown(MouseEvent e) {
                if (CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSource() != null) {
                    CollectionTimedTimeSourceComposite.this.getCollectionTimedTimeSource().pause();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        return timeLineComposite;
    }

    @Override
    protected DataBindingContext initDataBindings() {
        DataBindingContext dataBindingContext = super.initDataBindings();
        TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.getTimeSource());
        if (this.timeLineStartTimeValueLabel != null) {
            IObservableValue startTimeLabelValue = PojoProperties.value((String)"text").observe((Object)this.timeLineStartTimeValueLabel);
            IObservableValue startTimeObserveValue = domain != null ? EMFEditProperties.value((EditingDomain)domain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__EARLIEST_DATE})).observe((Object)this.getTimeSource()) : EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__EARLIEST_DATE})).observe((Object)this.getTimeSource());
            UpdateValueStrategy startTimeValueStrategy = new UpdateValueStrategy();
            startTimeValueStrategy.setConverter((IConverter)new DateToStringConverter(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS z")));
            dataBindingContext.bindValue(startTimeLabelValue, startTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), startTimeValueStrategy);
        }
        if (this.timeLineEndTimeValueLabel != null) {
            IObservableValue endTimeLabelValue = PojoProperties.value((String)"text").observe((Object)this.timeLineEndTimeValueLabel);
            IObservableValue endTimeObserveValue = domain != null ? EMFEditProperties.value((EditingDomain)domain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__LATEST_DATE})).observe((Object)this.getTimeSource()) : EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__LATEST_DATE})).observe((Object)this.getTimeSource());
            UpdateValueStrategy endTimeValueStrategy = new UpdateValueStrategy();
            endTimeValueStrategy.setConverter((IConverter)new DateToStringConverter(new SimpleDateFormat("yyyy.MM.dd HH:mm:ss.SSS z")));
            dataBindingContext.bindValue(endTimeLabelValue, endTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), endTimeValueStrategy);
        }
        if (this.loopingEnabledButton != null) {
            ISWTObservableValue loopButtonValue = WidgetProperties.selection().observe((Widget)this.loopingEnabledButton);
            IObservableValue loopObserveValue = domain != null ? EMFEditProperties.value((EditingDomain)domain, (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__LOOP_ENABLE})).observe((Object)this.getTimeSource()) : EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.COLLECTION_TIMED_TIME_SOURCE__LOOP_ENABLE})).observe((Object)this.getTimeSource());
            UpdateValueStrategy loopValueStrategy = new UpdateValueStrategy();
            dataBindingContext.bindValue((IObservableValue)loopButtonValue, loopObserveValue, loopValueStrategy, loopValueStrategy);
        }
        return dataBindingContext;
    }

    protected void setTimeScaleTime(Date time) {
        if (!this.timeScale.isDisposed()) {
            if (this.getCollectionTimedTimeSource() != null) {
                if (this.timeScale != null && time != null) {
                    Date earliest = this.getCollectionTimedTimeSource().getEarliestDate();
                    Date latest = this.getCollectionTimedTimeSource().getLatestDate();
                    long timeSpan = latest.getTime() - earliest.getTime();
                    long delta = time.getTime() - earliest.getTime();
                    double ratio = 0.0;
                    if ((double)timeSpan != 0.0) {
                        ratio = (double)delta / (double)timeSpan;
                    }
                    int selection = (int)Math.round((double)this.timeScale.getMaximum() * ratio);
                    this.timeScale.setSelection(selection);
                    this.timeScale.setToolTipText(time.toString());
                }
            } else {
                this.timeScale.setSelection(0);
            }
        }
    }

    protected Adapter getCollectionTimedTimeSourceAdapter() {
        if (this.collectionTimedTimeSourceAdapter == null) {
            this.collectionTimedTimeSourceAdapter = new AdapterImpl(){

                public void notifyChanged(final Notification msg) {
                    if (msg.getNotifier() instanceof TimeSource) {
                        int featureId = msg.getFeatureID(TimeSource.class);
                        switch (featureId) {
                            case 2: {
                                if (!(msg.getNewValue() instanceof Date)) break;
                                Display.getDefault().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        Date currentTime = (Date)msg.getNewValue();
                                        CollectionTimedTimeSourceComposite.this.setTimeScaleTime(currentTime);
                                    }
                                });
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.collectionTimedTimeSourceAdapter;
    }
}

