/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.parts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PreDestroy;
import org.eclipse.apogy.common.emf.ui.parts.AbstractPart;
import org.eclipse.apogy.common.ui.composites.NoContentComposite;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractEObjectSelectionPart
extends AbstractPart {
    protected EObject eObject;
    protected final ISelectionListener DEFAULT_LISTENER = new ISelectionListener(){

        public void selectionChanged(MPart part, Object selection) {
            if (selection == null || selection instanceof EObject) {
                AbstractEObjectSelectionPart.this.setEObject((EObject)selection);
            }
        }
    };

    @Override
    protected EObject getInitializeObject() {
        HashMap<String, ISelectionListener> map = this.getSelectionProvidersIdsToSelectionListeners();
        if (map != null) {
            Iterator<ISelectionListener> iteListeners = map.values().iterator();
            ArrayList<Object> selectedObjects = new ArrayList<Object>();
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String id = this.verifyID(iterator.next());
                this.selectionService.addSelectionListener(id, iteListeners.next());
                selectedObjects.add(this.selectionService.getSelection(id));
            }
            for (Object e : selectedObjects) {
                if (e != this.selectionService.getSelection()) continue;
                this.eObject = (EObject)e;
            }
            if (this.eObject == null) {
                for (Object e : selectedObjects) {
                    if (e == null) continue;
                    this.eObject = (EObject)e;
                    break;
                }
            }
        }
        return this.eObject;
    }

    private String verifyID(String id) {
        String endNumber;
        Pattern idNumberEndPattern = Pattern.compile("[^0-9]+([0-9]+)$");
        Matcher matcher = idNumberEndPattern.matcher(this.mPart.getElementId().substring(0, this.mPart.getElementId().indexOf("_" + this.perspectiveID)));
        if (matcher.find() && !id.endsWith(endNumber = matcher.group(1))) {
            id = id.concat("_" + endNumber);
        }
        id = id.concat("_" + this.perspectiveID);
        return id;
    }

    @Override
    protected final void setCompositeContent(EObject eObject) {
        this.eObject = eObject;
        this.setCompositeContents(eObject);
    }

    protected abstract void setCompositeContents(EObject var1);

    @Override
    protected void createNoContentComposite(Composite parent, int style) {
        new NoContentComposite(parent, style){

            protected String getMessage() {
                return "No compatible selection";
            }
        };
    }

    @Override
    protected abstract void createContentComposite(Composite var1, int var2);

    protected abstract HashMap<String, ISelectionListener> getSelectionProvidersIdsToSelectionListeners();

    @Override
    @PreDestroy
    public void dispose() {
        HashMap<String, ISelectionListener> map = this.getSelectionProvidersIdsToSelectionListeners();
        if (map != null) {
            for (String id : map.keySet()) {
                String uniqueID = this.verifyID(id);
                this.selectionService.removeSelectionListener(uniqueID, map.get(id));
            }
        }
    }
}

