/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.impl;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.Duration;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.common.emf.impl.DurationImpl;

public class DurationCustomImpl
extends DurationImpl {
    private static long MILLISEC_PER_SECOND = 1000L;
    private static long MILLISEC_PER_MINUTE = 60L * MILLISEC_PER_SECOND;
    private static long MILLISEC_PER_HOUR = 60L * MILLISEC_PER_MINUTE;
    private static long MILLISEC_PER_DAY = 24L * MILLISEC_PER_HOUR;

    @Override
    public byte getDays() {
        return (byte)Math.floorDiv(this.getValue(), MILLISEC_PER_DAY);
    }

    @Override
    public byte getHours() {
        long hours = this.getValue() - (long)this.getDays() * MILLISEC_PER_DAY;
        return (byte)Math.floorDiv(hours, MILLISEC_PER_HOUR);
    }

    @Override
    public byte getMinutes() {
        long minutes = this.getValue() - (long)this.getDays() * MILLISEC_PER_DAY - (long)this.getHours() * MILLISEC_PER_HOUR;
        return (byte)Math.floorDiv(minutes, MILLISEC_PER_MINUTE);
    }

    @Override
    public byte getSeconds() {
        long seconds = this.getValue() - (long)this.getDays() * MILLISEC_PER_DAY - (long)this.getHours() * MILLISEC_PER_HOUR - (long)this.getMinutes() * MILLISEC_PER_MINUTE;
        return (byte)Math.floorDiv(seconds, MILLISEC_PER_SECOND);
    }

    @Override
    public int getMilliseconds() {
        long milliseconds = this.getValue() - (long)this.getDays() * MILLISEC_PER_DAY - (long)this.getHours() * MILLISEC_PER_HOUR - (long)this.getMinutes() * MILLISEC_PER_MINUTE - (long)this.getSeconds() * MILLISEC_PER_SECOND;
        return (int)milliseconds;
    }

    @Override
    public Duration getDuration(Timed firstEvent, Timed secondEvent) {
        Duration duration = ApogyCommonEMFFactory.eINSTANCE.createDuration();
        long durationValue = 0L;
        if (firstEvent != null & firstEvent.getTime() != null && secondEvent != null && secondEvent.getTime() != null) {
            durationValue = secondEvent.getTime().getTime() - firstEvent.getTime().getTime();
        }
        duration.setValue(durationValue);
        return duration;
    }
}

