/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.commands;

import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.Data3DIO;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveTriangularMeshToFileCommandHandler
extends AbstractHandler
implements IHandler {
    private static final Logger Logger = LoggerFactory.getLogger(SaveTriangularMeshToFileCommandHandler.class);
    protected static String currentDir = System.getProperty("user.dir");

    public Object execute(ExecutionEvent event) throws ExecutionException {
        for (Object selection : (IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)) {
            if (!(selection instanceof CartesianTriangularMesh)) continue;
            CartesianTriangularMesh mesh = (CartesianTriangularMesh)selection;
            IWorkbench wb = PlatformUI.getWorkbench();
            Shell shell = wb.getActiveWorkbenchWindow().getShell();
            this.saveToFile(shell, mesh);
        }
        return null;
    }

    protected void saveToFile(Shell shell, CartesianTriangularMesh mesh) {
        FileDialog fileChooser = new FileDialog(shell, 8192);
        fileChooser.setText("Save Mesh (" + mesh.getPoints().size() + " points, " + mesh.getPolygons().size() + " triangles) to files");
        fileChooser.setFilterPath(currentDir);
        fileChooser.setFilterExtensions(new String[]{"*.tri;"});
        String filename = fileChooser.open();
        if (filename != null) {
            try {
                if (filename.endsWith(".tri")) {
                    String filePrefix = filename.substring(0, filename.lastIndexOf(".tri"));
                    this.saveTriangularMeshAsASCII(mesh, filePrefix);
                } else {
                    String fileExtension = "";
                    if (filename.lastIndexOf(".") > 0) {
                        fileExtension = filename.substring(filename.lastIndexOf("."));
                    }
                    String message = "Failed to save the image. The specified file extension <" + fileExtension + "> is not supported.";
                    Logger.error(message);
                    MessageBox messageBox = new MessageBox(shell, 33);
                    messageBox.setMessage(message);
                    messageBox.open();
                }
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
            currentDir = fileChooser.getFilterPath();
        }
    }

    protected void saveTriangularMeshAsASCII(CartesianTriangularMesh mesh, String filePrefix) {
        Logger.info("Saving mesh to file <" + filePrefix + ".tri" + " and " + filePrefix + ".xyz.");
        try {
            Data3DIO.INSTANCE.saveTriangularMeshAsASCII(mesh, filePrefix);
            Logger.info("Saved mesh to file <" + filePrefix + ".tri" + " and " + filePrefix + ".xyz.");
        }
        catch (Throwable t) {
            Logger.error("Failed to save mesh to file <" + filePrefix + ".tri" + " and " + filePrefix + ".xyz.", t);
        }
    }
}

