/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.shape.Sphere;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.SpherePrimitive;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpherePrimitiveJME3SceneObject
extends DefaultJME3SceneObject<SpherePrimitive> {
    private static final Logger Logger = LoggerFactory.getLogger(SpherePrimitiveJME3SceneObject.class);
    public static int Z_SAMPLES = 100;
    public static int RADIAL_SAMPLES = 36;
    private Adapter sphereAdapter;
    private Geometry sphereGeometry = null;
    private AssetManager assetManager = this.jme3Application.getAssetManager();

    public SpherePrimitiveJME3SceneObject(SpherePrimitive topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)topologyNode, jme3RenderEngineDelegate);
        Job job = new Job("SpherePrimitiveJME3SceneObject : Initialize Geometry."){

            protected IStatus run(IProgressMonitor monitor) {
                SpherePrimitiveJME3SceneObject.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        SpherePrimitiveJME3SceneObject.this.createGeometry();
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        topologyNode.eAdapters().add((Object)this.getSphereAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.sphereGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.sphereGeometry);
        }
        this.sphereGeometry = this.createSphereGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.sphereGeometry);
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.sphereGeometry);
        return geometries;
    }

    private void createGeometry() {
        this.sphereGeometry = this.createSphereGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.sphereGeometry);
    }

    private Geometry createSphereGeometry() {
        Mesh mesh = this.createMesh();
        Geometry geometry = new Geometry("Sphere", mesh);
        geometry.setMaterial(this.createMaterial());
        return geometry;
    }

    private Mesh createMesh() {
        Sphere sphere = new Sphere(Z_SAMPLES, RADIAL_SAMPLES, (float)((SpherePrimitive)this.getTopologyNode()).getRadius());
        return sphere;
    }

    public void setColor(final RGB rgb) {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    if (SpherePrimitiveJME3SceneObject.this.sphereGeometry != null) {
                        Material mat = SpherePrimitiveJME3SceneObject.this.createMaterial();
                        mat.setColor("Diffuse", JME3Utilities.convertToColorRGBA((RGB)rgb));
                        mat.setColor("Ambient", JME3Utilities.convertToColorRGBA((RGB)rgb));
                        mat.setColor("Specular", JME3Utilities.convertToColorRGBA((RGB)rgb));
                        SpherePrimitiveJME3SceneObject.this.sphereGeometry.setMaterial(mat);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Failed to set color to <" + rgb + ">.", t);
                }
                return null;
            }
        });
    }

    private Material createMaterial() {
        Material mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.getColor() != null) {
            mat.setColor("Diffuse", JME3Utilities.convertToColorRGBA((RGB)this.getColor()));
            mat.setColor("Ambient", JME3Utilities.convertToColorRGBA((RGB)this.getColor()));
            mat.setColor("Specular", JME3Utilities.convertToColorRGBA((RGB)this.getColor()));
        } else {
            mat.setColor("Diffuse", ColorRGBA.White);
            mat.setColor("Ambient", ColorRGBA.White);
            mat.setColor("Specular", ColorRGBA.White);
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        return mat;
    }

    private Adapter getSphereAdapter() {
        if (this.sphereAdapter == null) {
            this.sphereAdapter = new Adapter(){

                public Notifier getTarget() {
                    return null;
                }

                public boolean isAdapterForType(Object type) {
                    return false;
                }

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(SpherePrimitive.class) == 5) {
                        SpherePrimitiveJME3SceneObject.this.requestUpdate();
                    }
                }

                public void setTarget(Notifier newTarget) {
                }
            };
        }
        return this.sphereAdapter;
    }
}

