/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.wizards;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.ui.composites.TypedElementSimpleUnitsComposite;
import org.eclipse.apogy.common.topology.addons.primitives.ApogyCommonTopologyAddonsPrimitivesPackage;
import org.eclipse.apogy.common.topology.addons.primitives.SpotLight;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class SpotLightWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.addons.primitives.ui.wizards.SpotLightWizardPage";
    public static String NO_VALUE_AVAILABLE_STRING = "N/A";
    private final int LABEL_WIDTH = 200;
    private final int VALUE_WIDTH = 100;
    private final int BUTTON_WIDTH = 50;
    private final SpotLight spotLight;
    private Adapter adapter;
    private TypedElementSimpleUnitsComposite rangeComposite;
    private TypedElementSimpleUnitsComposite spreadAngleComposite;

    public SpotLightWizardPage(SpotLight spotLight) {
        super(WIZARD_PAGE_ID);
        this.spotLight = spotLight;
        this.setTitle("Spot Light");
        this.setDescription("Select the Spot Light range and spread angle.");
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)top);
        this.rangeComposite = new TypedElementSimpleUnitsComposite(top, 0, true, true, true, NO_VALUE_AVAILABLE_STRING, 200, 100, 50){
            DecimalFormat format;
            {
                this.format = new DecimalFormat("0.0");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected String getLabelText() {
                return "Range :";
            }
        };
        this.rangeComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.rangeComposite.setTypedElement(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonTopologyAddonsPrimitivesPackage.Literals.SPOT_LIGHT__SPOT_RANGE}), (EObject)this.spotLight);
        this.spreadAngleComposite = new TypedElementSimpleUnitsComposite(top, 0, true, true, true, NO_VALUE_AVAILABLE_STRING, 200, 100, 50){
            DecimalFormat format;
            {
                this.format = new DecimalFormat("0.0");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected String getLabelText() {
                return "Spread Angle :";
            }
        };
        this.spreadAngleComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.spreadAngleComposite.setTypedElement(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonTopologyAddonsPrimitivesPackage.Literals.SPOT_LIGHT__SPREAD_ANGLE}), (EObject)this.spotLight);
        if (this.spotLight != null) {
            this.spotLight.eAdapters().add((Object)this.getAdapter());
        }
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (SpotLightWizardPage.this.spotLight != null) {
                    SpotLightWizardPage.this.spotLight.eAdapters().remove((Object)SpotLightWizardPage.this.getAdapter());
                }
            }
        });
        this.validate();
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.spotLight.getSpotRange() <= 0.0f) {
            this.setErrorMessage("The specified range must be greater than zero !");
        }
        if (this.spotLight.getSpreadAngle() <= 0.0f) {
            this.setErrorMessage("The specified spread angle must be greater than zero !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof SpotLight) {
                        SpotLightWizardPage.this.validate();
                    }
                }
            };
        }
        return this.adapter;
    }
}

