/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3.internal;

import com.jme3.app.Application;
import com.jme3.app.state.AbstractAppState;
import com.jme3.app.state.AppStateManager;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.post.SceneProcessor;
import com.jme3.renderer.RenderManager;
import com.jme3.renderer.Renderer;
import com.jme3.renderer.ViewPort;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.texture.FrameBuffer;
import com.jme3.util.BufferUtils;
import com.jme3.util.Screenshots;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.List;

public class CustomScreenshotAppState
extends AbstractAppState
implements ActionListener,
SceneProcessor {
    private boolean capture = false;
    private boolean busy = false;
    private Renderer renderer;
    private ByteBuffer outBuf;
    private BufferedImage awtImage;
    private BufferedImage latestImage;

    public BufferedImage getCapturedImage() {
        return this.latestImage;
    }

    public void takeSnapshot() {
        if (!this.busy) {
            this.latestImage = null;
            this.capture = true;
        }
    }

    public void initialize(AppStateManager stateManager, Application app) {
        if (!super.isInitialized()) {
            InputManager inputManager = app.getInputManager();
            inputManager.addMapping("ScreenShot", new Trigger[]{new KeyTrigger(183)});
            inputManager.addListener((InputListener)this, new String[]{"ScreenShot"});
            List vps = app.getRenderManager().getPostViews();
            ViewPort last = (ViewPort)vps.get(vps.size() - 1);
            last.addProcessor((SceneProcessor)this);
        }
        super.initialize(stateManager, app);
    }

    public void onAction(String name, boolean value, float tpf) {
    }

    public void initialize(RenderManager rm, ViewPort vp) {
        this.renderer = rm.getRenderer();
        this.reshape(vp, vp.getCamera().getWidth(), vp.getCamera().getHeight());
    }

    public boolean isInitialized() {
        return super.isInitialized() && this.renderer != null;
    }

    public void reshape(ViewPort vp, int w, int h) {
        this.outBuf = BufferUtils.createByteBuffer((int)(w * h * 4));
        this.awtImage = new BufferedImage(w, h, 6);
    }

    public void preFrame(float tpf) {
    }

    public void postQueue(RenderQueue rq) {
    }

    public void postFrame(FrameBuffer out) {
        if (this.capture) {
            this.busy = true;
            this.capture = false;
            this.renderer.readFrameBuffer(out, this.outBuf);
            Screenshots.convertScreenShot((ByteBuffer)this.outBuf, (BufferedImage)this.awtImage);
            BufferedImage tempImage = new BufferedImage(this.awtImage.getWidth(), this.awtImage.getHeight(), 2);
            Graphics g = tempImage.getGraphics();
            g.drawImage(this.awtImage, 0, 0, null);
            g.dispose();
            this.latestImage = tempImage;
            this.busy = false;
        }
    }
}

