/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ShadowMode implements Enumerator
{
    INHERIT(0, "INHERIT", "INHERIT"),
    OFF(1, "OFF", "OFF"),
    CAST(2, "CAST", "CAST"),
    RECEIVE(3, "RECEIVE", "RECEIVE"),
    CAST_AND_RECEIVE(4, "CAST_AND_RECEIVE", "CAST_AND_RECEIVE");

    public static final int INHERIT_VALUE = 0;
    public static final int OFF_VALUE = 1;
    public static final int CAST_VALUE = 2;
    public static final int RECEIVE_VALUE = 3;
    public static final int CAST_AND_RECEIVE_VALUE = 4;
    private static final ShadowMode[] VALUES_ARRAY;
    public static final List<ShadowMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ShadowMode[]{INHERIT, OFF, CAST, RECEIVE, CAST_AND_RECEIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ShadowMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShadowMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShadowMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShadowMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShadowMode get(int value) {
        switch (value) {
            case 0: {
                return INHERIT;
            }
            case 1: {
                return OFF;
            }
            case 2: {
                return CAST;
            }
            case 3: {
                return RECEIVE;
            }
            case 4: {
                return CAST_AND_RECEIVE;
            }
        }
        return null;
    }

    private ShadowMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

