/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.composites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.NodeDescriptionFilter;
import org.eclipse.apogy.common.topology.NodeFilterChain;
import org.eclipse.apogy.common.topology.NodeIdFilter;
import org.eclipse.apogy.common.topology.NodeTypeFilter;
import org.eclipse.apogy.common.topology.ui.composites.NodeTypeComboComposite;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractNodeSearchComposite
extends Composite {
    protected ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    public static final int ID_COLUMN_INDEX = 0;
    public static final int DESCRIPTION_COLUMN_INDEX = 1;
    protected List<Node> filteredNodes = new ArrayList<Node>();
    protected Node selectedNode = null;
    protected List<Node> selectedNodes = new ArrayList<Node>();
    protected EClass nodeFilterType = null;
    private final NodeTypeComboComposite nodeClassFilterCombo;
    private final Button btnClearTypeFilter;
    private final Text nodeIDFilterText;
    private final Button btnClearIDFilter;
    private final Text nodeDescriptionFilterText;
    private final Button btnClearDescriptionFilter;
    private final Table filteredNodesTable;
    private final TableViewer filteredNodesTableViewer;
    private final Button btnApply;

    public AbstractNodeSearchComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblTypeFilter = new Label((Composite)this, 0);
        lblTypeFilter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblTypeFilter.setText("Type Filter");
        this.nodeClassFilterCombo = new NodeTypeComboComposite(this, 0){

            @Override
            public void typeSelected(EClass eClass) {
                AbstractNodeSearchComposite.this.setTypeFilter(eClass);
            }
        };
        this.nodeClassFilterCombo.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnClearTypeFilter = new Button((Composite)this, 0);
        this.btnClearTypeFilter.setText("Clear");
        this.btnClearTypeFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNodeSearchComposite.this.nodeClassFilterCombo.clearSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblIdFilter = new Label((Composite)this, 0);
        lblIdFilter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblIdFilter.setText("ID Filter");
        this.nodeIDFilterText = new Text((Composite)this, 2048);
        this.nodeIDFilterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.nodeIDFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNodeSearchComposite.this.applyFilters();
            }
        });
        this.btnClearIDFilter = new Button((Composite)this, 0);
        this.btnClearIDFilter.setText("Clear");
        this.btnClearIDFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNodeSearchComposite.this.nodeIDFilterText.setText("");
                AbstractNodeSearchComposite.this.applyFilters();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label lblDescriptionFilter = new Label((Composite)this, 0);
        lblDescriptionFilter.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblDescriptionFilter.setText("Description Filter");
        this.nodeDescriptionFilterText = new Text((Composite)this, 2048);
        this.nodeDescriptionFilterText.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        this.nodeDescriptionFilterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractNodeSearchComposite.this.applyFilters();
            }
        });
        this.btnClearDescriptionFilter = new Button((Composite)this, 0);
        this.btnClearDescriptionFilter.setText("Clear");
        this.btnClearDescriptionFilter.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNodeSearchComposite.this.nodeDescriptionFilterText.setText("");
                AbstractNodeSearchComposite.this.applyFilters();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnApply = new Button((Composite)this, 0);
        this.btnApply.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 1, 1));
        this.btnApply.setText("Update");
        this.btnApply.setToolTipText("Force the topology to be updated and the filters re-applied.");
        this.btnApply.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractNodeSearchComposite.this.applyFilters();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        this.filteredNodesTableViewer = new TableViewer((Composite)this, 68352);
        this.filteredNodesTable = this.filteredNodesTableViewer.getTable();
        this.filteredNodesTable.setHeaderVisible(true);
        this.filteredNodesTable.setLinesVisible(true);
        GridData gd_filteredNodesTable = new GridData(4, 128, true, false, 3, 1);
        gd_filteredNodesTable.heightHint = 300;
        gd_filteredNodesTable.minimumHeight = 300;
        this.filteredNodesTable.setLayoutData((Object)gd_filteredNodesTable);
        TableColumn tblclmnNodeId = new TableColumn(this.filteredNodesTable, 0);
        tblclmnNodeId.setWidth(200);
        tblclmnNodeId.setText("Id");
        TableColumn tblclmnNodeDescription = new TableColumn(this.filteredNodesTable, 0);
        tblclmnNodeDescription.setWidth(400);
        tblclmnNodeDescription.setText("Description");
        this.filteredNodesTableViewer.setContentProvider((IContentProvider)this.createContentProvider());
        this.filteredNodesTableViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider());
        this.filteredNodesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)event.getSelection();
                    AbstractNodeSearchComposite.this.selectedNodes.clear();
                    if (!iStructuredSelection.isEmpty()) {
                        AbstractNodeSearchComposite.this.nodeSelectedChanged((Node)iStructuredSelection.getFirstElement());
                        ArrayList<Node> nodesSelected = new ArrayList<Node>();
                        List selectedObjects = iStructuredSelection.toList();
                        for (Object object : selectedObjects) {
                            if (!(object instanceof Node)) continue;
                            nodesSelected.add((Node)object);
                        }
                        AbstractNodeSearchComposite.this.selectedNodes.addAll(nodesSelected);
                        AbstractNodeSearchComposite.this.nodesSelectedChanged(nodesSelected);
                    } else {
                        AbstractNodeSearchComposite.this.nodeSelectedChanged(null);
                        AbstractNodeSearchComposite.this.nodesSelectedChanged(new ArrayList<Node>());
                    }
                }
            }
        });
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
    }

    public void nodeSelectedChanged(Node nodeSelected) {
    }

    protected void nodesSelectedChanged(Collection<Node> nodesSelected) {
    }

    public void initializeTypeFilter(final EClass eClass) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (AbstractNodeSearchComposite.this.nodeClassFilterCombo != null && !AbstractNodeSearchComposite.this.nodeClassFilterCombo.isDisposed()) {
                    AbstractNodeSearchComposite.this.nodeClassFilterCombo.selectType(eClass);
                }
            }
        });
    }

    public void setTypeFilter(EClass eClass) {
        this.nodeFilterType = eClass;
        this.applyFilters();
    }

    public Node getSelectedNode() {
        return this.selectedNode;
    }

    public Collection<Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public void applyFilters() {
        NodeFilterChain nodeFilterChain = ApogyCommonTopologyFactory.eINSTANCE.createNodeFilterChain();
        if (this.nodeFilterType != null) {
            NodeTypeFilter nodeTypeFilter = ApogyCommonTopologyFactory.eINSTANCE.createNodeTypeFilter();
            nodeTypeFilter.setClazz(this.nodeFilterType);
            nodeFilterChain.getFilters().add((Object)nodeTypeFilter);
        }
        if (this.nodeIDFilterText.getText() != null && this.nodeIDFilterText.getText().length() > 0) {
            NodeIdFilter nodeIdFilter = ApogyCommonTopologyFactory.eINSTANCE.createNodeIdFilter();
            nodeIdFilter.setRegex(this.convertFilterStringToRegex(this.nodeIDFilterText.getText()));
            nodeFilterChain.getFilters().add((Object)nodeIdFilter);
        }
        if (this.nodeDescriptionFilterText.getText() != null && this.nodeDescriptionFilterText.getText().length() > 0) {
            NodeDescriptionFilter nodeDescriptionFilter = ApogyCommonTopologyFactory.eINSTANCE.createNodeDescriptionFilter();
            nodeDescriptionFilter.setRegex(this.convertFilterStringToRegex(this.nodeDescriptionFilterText.getText()));
            nodeFilterChain.getFilters().add((Object)nodeDescriptionFilter);
        }
        Collection matches = nodeFilterChain.filter(this.getUnfilteredNodes());
        this.filteredNodes.clear();
        this.filteredNodes.addAll(matches);
        this.filteredNodesTableViewer.setInput(this.filteredNodes);
    }

    protected abstract Set<Node> getUnfilteredNodes();

    protected String convertFilterStringToRegex(String filterString) {
        String regex = new String(filterString);
        if (filterString.indexOf("*") >= 0) {
            regex = regex.replace("*", ".*");
        }
        if (!regex.startsWith(".*")) {
            regex = "^" + regex;
        }
        if (!regex.endsWith(".*")) {
            regex = String.valueOf(regex) + ".*";
        }
        return regex;
    }

    protected abstract AdapterFactoryContentProvider createContentProvider();

    protected abstract AdapterFactoryLabelProvider createLabelProvider();
}

