/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;

public class MultiNodeListener {
    private Adapter nodeAdapter = null;
    private final List<Node> registeredNodes = new ArrayList<Node>();

    public void registerNode(Node node) {
        if (node != null && !this.registeredNodes.contains(node)) {
            this.registeredNodes.add(node);
            node.eAdapters().add((Object)this.getNodeAdapter());
        }
    }

    public void unregisterNode(Node node) {
        if (node != null && this.registeredNodes.contains(node)) {
            this.registeredNodes.remove(node);
            node.eAdapters().remove((Object)this.getNodeAdapter());
        }
    }

    protected Adapter getNodeAdapter() {
        if (this.nodeAdapter == null) {
            this.nodeAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof GroupNode) {
                        GroupNode parent = (GroupNode)msg.getNotifier();
                        int featureId = msg.getFeatureID(GraphicsContext.class);
                        block0 : switch (featureId) {
                            case 3: {
                                int eventType = msg.getEventType();
                                switch (eventType) {
                                    case 3: {
                                        if (!(msg.getNewValue() instanceof Node)) break block0;
                                        Node node = (Node)msg.getNewValue();
                                        MultiNodeListener.this.nodeAdded(parent, node);
                                        break block0;
                                    }
                                    case 5: {
                                        List nodesAdded = (List)msg.getNewValue();
                                        MultiNodeListener.this.nodesAdded(parent, nodesAdded);
                                        break block0;
                                    }
                                    case 4: {
                                        if (!(msg.getOldValue() instanceof Node)) break block0;
                                        Node node = (Node)msg.getOldValue();
                                        MultiNodeListener.this.nodeRemoved(parent, node);
                                        break block0;
                                    }
                                    case 6: {
                                        List nodesRemoved = (List)msg.getOldValue();
                                        MultiNodeListener.this.nodesRemoved(parent, nodesRemoved);
                                        break block0;
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.nodeAdapter;
    }

    protected void nodeAdded(GroupNode parent, Node nodeAdded) {
    }

    protected void nodeRemoved(GroupNode parent, Node nodeRemoved) {
    }

    protected void nodesAdded(GroupNode parent, List<Node> nodesAdded) {
    }

    protected void nodesRemoved(GroupNode parent, List<Node> nodesRemoved) {
    }
}

