/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.atmosphere.ui.composites;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFactory;
import org.eclipse.apogy.common.emf.ui.EClassSettings;
import org.eclipse.apogy.common.emf.ui.MapBasedEClassSettings;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.WorksitesList;
import org.eclipse.apogy.core.environment.earth.atmosphere.ApogyEarthAtmosphereEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.atmosphere.EarthAtmosphereWorksite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthAtmosphereWorksiteListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(EarthAtmosphereWorksiteListComposite.class);
    private WorksitesList worksitesList;
    private EarthAtmosphereWorksite selectedEarthSurfaceWorksite;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private final Button btnActivate;
    private final Button btnImport;
    private final Button btnExport;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;

    public EarthAtmosphereWorksiteListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CompositeFilterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EarthAtmosphereWorksiteListComposite.this.selectedEarthSurfaceWorksite = (EarthAtmosphereWorksite)((IStructuredSelection)event.getSelection()).getFirstElement();
                EarthAtmosphereWorksiteListComposite.this.newSelection(EarthAtmosphereWorksiteListComposite.this.selectedEarthSurfaceWorksite);
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    MapBasedEClassSettings settings = ApogyCommonEMFUIFactory.eINSTANCE.createMapBasedEClassSettings();
                    String name = ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)EarthAtmosphereWorksiteListComposite.this.getWorksitesList(), null, (ETypedElement)ApogyCoreEnvironmentPackage.Literals.WORKSITES_LIST__WORKSITES);
                    settings.getUserDataMap().put("name", name);
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCoreEnvironmentPackage.Literals.WORKSITES_LIST__WORKSITES, (EObject)EarthAtmosphereWorksiteListComposite.this.getWorksitesList(), (EClassSettings)settings, ApogyEarthAtmosphereEnvironmentPackage.Literals.EARTH_ATMOSPHERE_WORKSITE);
                    WizardDialog dialog = new WizardDialog(EarthAtmosphereWorksiteListComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    if (!EarthAtmosphereWorksiteListComposite.this.treeViewer.isBusy()) {
                        EarthAtmosphereWorksiteListComposite.this.treeViewer.setInput((Object)EarthAtmosphereWorksiteListComposite.this.getWorksitesList());
                    }
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String worksitesToDeleteMessage = "";
                Iterator<EarthAtmosphereWorksite> worksites = EarthAtmosphereWorksiteListComposite.this.getSelectedEarthAtmosphereWorksites().iterator();
                while (worksites.hasNext()) {
                    EarthAtmosphereWorksite worksite = worksites.next();
                    worksitesToDeleteMessage = String.valueOf(worksitesToDeleteMessage) + worksite.getName();
                    if (!worksites.hasNext()) continue;
                    worksitesToDeleteMessage = String.valueOf(worksitesToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected Earth Surface Worksites", null, "Are you sure to delete these Earth Surface Worksites: " + worksitesToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (EarthAtmosphereWorksite worksite : EarthAtmosphereWorksiteListComposite.this.getSelectedEarthAtmosphereWorksites()) {
                        try {
                            ApogyEnvironment apogyEnvironment;
                            if (worksite.getWorksitesList().eContainer() instanceof ApogyEnvironment && (apogyEnvironment = (ApogyEnvironment)worksite.getWorksitesList().eContainer()).getActiveWorksite() == worksite) {
                                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)apogyEnvironment, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_WORKSITE, null);
                            }
                            ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)worksite.getWorksitesList(), (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.WORKSITES_LIST__WORKSITES, (Object)worksite);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the Earth Surface Worksite <" + worksite.getName() + ">", (Throwable)e);
                        }
                    }
                }
                if (!EarthAtmosphereWorksiteListComposite.this.treeViewer.isBusy()) {
                    EarthAtmosphereWorksiteListComposite.this.treeViewer.setInput((Object)EarthAtmosphereWorksiteListComposite.this.getWorksitesList());
                }
            }
        });
        this.btnActivate = new Button(composite, 0);
        this.btnActivate.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnActivate.setSize(74, 29);
        this.btnActivate.setText("Activate");
        this.btnActivate.setEnabled(false);
        this.btnActivate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApogyEnvironment env = ApogyCoreEnvironmentFacade.INSTANCE.getActiveApogyEnvironment();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)env, (EStructuralFeature)ApogyCoreEnvironmentPackage.Literals.APOGY_ENVIRONMENT__ACTIVE_WORKSITE, (Object)EarthAtmosphereWorksiteListComposite.this.getSelectedEarthAtmosphereWorksite());
            }
        });
        this.btnImport = new Button(composite, 0);
        this.btnImport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnImport.setSize(74, 29);
        this.btnImport.setText("Import Worksite");
        this.btnImport.setToolTipText("Import an existing Earth Atmosphere Worksite.");
        this.btnImport.setEnabled(false);
        this.btnImport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.btnExport = new Button(composite, 0);
        this.btnExport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnExport.setSize(74, 29);
        this.btnExport.setText("Export Worksite");
        this.btnExport.setToolTipText("Export the selected Earth Atmosphere Worksite to file.");
        this.btnExport.setEnabled(false);
        this.btnExport.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EarthAtmosphereWorksiteListComposite.this.getSelectedEarthAtmosphereWorksites().size() > 0) {
                    EarthAtmosphereWorksite tmp = EarthAtmosphereWorksiteListComposite.this.getSelectedEarthAtmosphereWorksites().get(0);
                    EarthAtmosphereWorksite worksite = (EarthAtmosphereWorksite)EcoreUtil.copy((EObject)tmp);
                    try {
                        FileDialog fileChooser = new FileDialog(Display.getDefault().getActiveShell(), 8192);
                        String defaultFilename = worksite.getName();
                        if (defaultFilename != null) {
                            fileChooser.setFileName(defaultFilename);
                        }
                        String currentDir = System.getProperty("user.dir");
                        fileChooser.setText("Save Worksite to File");
                        fileChooser.setFilterPath(currentDir);
                        fileChooser.setFilterExtensions(new String[]{"*.ws"});
                        String filename = fileChooser.open();
                        if (filename != null) {
                            Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
                            Map m = reg.getExtensionToFactoryMap();
                            m.put("key", new XMIResourceFactoryImpl());
                            ResourceSetImpl resSet = new ResourceSetImpl();
                            Resource resource = resSet.createResource(URI.createFileURI((String)filename));
                            resource.getContents().add((Object)worksite);
                            resource.save(Collections.EMPTY_MAP);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EarthAtmosphereWorksiteListComposite.this.m_bindingContext != null) {
                    EarthAtmosphereWorksiteListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public WorksitesList getWorksitesList() {
        return this.worksitesList;
    }

    public void setWorksitesList(WorksitesList worksitesList) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.worksitesList = worksitesList;
        if (worksitesList != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.treeViewer.setInput((Object)worksitesList);
            EarthAtmosphereWorksite earthAtmosphereWorksite = this.getFirstEarthAtmosphereWorksite(worksitesList);
            this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)earthAtmosphereWorksite), true);
        }
    }

    public EarthAtmosphereWorksite getSelectedEarthAtmosphereWorksite() {
        return this.selectedEarthSurfaceWorksite;
    }

    public List<EarthAtmosphereWorksite> getSelectedEarthAtmosphereWorksites() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected EarthAtmosphereWorksite getFirstEarthAtmosphereWorksite(WorksitesList worksitesList) {
        List<EarthAtmosphereWorksite> earthAtmosphereWorksites = this.filterEarthSurfaceWorksite(worksitesList);
        if (!earthAtmosphereWorksites.isEmpty()) {
            return earthAtmosphereWorksites.get(0);
        }
        return null;
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeEnabledBtnActivateObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnActivate);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnActivateObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeEnabledBtnExportObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnExport);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnExportObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    protected void newSelection(EarthAtmosphereWorksite earthAtmosphereWorksite) {
    }

    private List<EarthAtmosphereWorksite> filterEarthSurfaceWorksite(WorksitesList worksitesList) {
        ArrayList<EarthAtmosphereWorksite> earthSurfaceWorksites = new ArrayList<EarthAtmosphereWorksite>();
        for (AbstractWorksite worksite : worksitesList.getWorksites()) {
            if (!(worksite instanceof EarthAtmosphereWorksite)) continue;
            earthSurfaceWorksites.add((EarthAtmosphereWorksite)worksite);
        }
        return earthSurfaceWorksites;
    }

    private class CompositeFilterContentProvider
    implements ITreeContentProvider {
        private CompositeFilterContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof WorksitesList) {
                WorksitesList worksitesList = (WorksitesList)inputElement;
                return EarthAtmosphereWorksiteListComposite.this.filterEarthSurfaceWorksite(worksitesList).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof WorksitesList) {
                WorksitesList worksitesList = (WorksitesList)parentElement;
                return EarthAtmosphereWorksiteListComposite.this.filterEarthSurfaceWorksite(worksitesList).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof WorksitesList) {
                WorksitesList worksitesList = (WorksitesList)element;
                return !EarthAtmosphereWorksiteListComposite.this.filterEarthSurfaceWorksite(worksitesList).isEmpty();
            }
            return false;
        }
    }
}

