/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.orbit.ui.impl;

import java.util.Date;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.core.environment.earth.ApogyEarthEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.apogy.core.environment.earth.surface.EarthSurfaceWorksite;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.ApogyEarthSurfaceOrbitEnvironmentUIFactory;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.ApogyEarthSurfaceOrbitEnvironmentUIPackage;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.EarthOrbitingSpacecraftLocationToolNode;
import org.eclipse.apogy.core.environment.earth.surface.orbit.ui.impl.EarthOrbitingSpacecraftLocationToolImpl;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitModel;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EarthOrbitingSpacecraftLocationToolCustomImpl
extends EarthOrbitingSpacecraftLocationToolImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EarthOrbitingSpacecraftLocationToolImpl.class);
    private EarthSurfaceLocation earthSurfaceLocation;

    @Override
    public void setEarthOrbitModel(EarthOrbitModel newEarthOrbitModel) {
        super.setEarthOrbitModel(newEarthOrbitModel);
        try {
            this.update();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public EarthOrbitModel getEarthOrbitModel() {
        EarthOrbitModel tmp = super.getEarthOrbitModel();
        return tmp;
    }

    @Override
    public void setActiveEarthSurfaceWorksite(EarthSurfaceWorksite newActiveEarthSurfaceWorksite) {
        this.detachToolNode();
        super.setActiveEarthSurfaceWorksite(newActiveEarthSurfaceWorksite);
        if (newActiveEarthSurfaceWorksite != null && newActiveEarthSurfaceWorksite.getGeographicalCoordinates() != null) {
            this.earthSurfaceLocation = ApogyEarthEnvironmentFactory.eINSTANCE.createEarthSurfaceLocation();
            this.earthSurfaceLocation.setLatitude(this.getActiveEarthSurfaceWorksite().getGeographicalCoordinates().getLatitude());
            this.earthSurfaceLocation.setLongitude(this.getActiveEarthSurfaceWorksite().getGeographicalCoordinates().getLongitude());
            this.earthSurfaceLocation.setElevation(this.getActiveEarthSurfaceWorksite().getGeographicalCoordinates().getElevation());
        } else {
            this.earthSurfaceLocation = null;
        }
        this.attachToolNode();
    }

    public void setActive(boolean newActive) {
        super.setActive(newActive);
        if (newActive) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void initialise() {
        EarthOrbitingSpacecraftLocationToolNode toolNode = ApogyEarthSurfaceOrbitEnvironmentUIFactory.eINSTANCE.createEarthOrbitingSpacecraftLocationToolNode();
        if (this.getName() != null) {
            toolNode.setDescription("Node associated with the EarthOrbitingSpacecraftLocationToo named <" + this.getName() + ">");
            toolNode.setNodeId("Earth_Orbiting_Spacecraft_Location_Tool_" + this.getName().replaceAll(" ", "_"));
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBITING_SPACECRAFT_LOCATION_TOOL__EARTH_ORBITING_SPACECRAFT_LOCATION_TOOL_NODE, (Object)toolNode, true);
        if (this.getActiveEarthSurfaceWorksite() != null && this.getActiveEarthSurfaceWorksite().getGeographicalCoordinates() != null) {
            this.earthSurfaceLocation = ApogyEarthEnvironmentFactory.eINSTANCE.createEarthSurfaceLocation();
            this.earthSurfaceLocation.setLatitude(this.getActiveEarthSurfaceWorksite().getGeographicalCoordinates().getLatitude());
            this.earthSurfaceLocation.setLongitude(this.getActiveEarthSurfaceWorksite().getGeographicalCoordinates().getLongitude());
            this.earthSurfaceLocation.setElevation(this.getActiveEarthSurfaceWorksite().getGeographicalCoordinates().getElevation());
        } else {
            this.earthSurfaceLocation = null;
        }
        super.initialise();
    }

    @Override
    public void dispose() {
        this.detachToolNode();
        super.dispose();
    }

    @Override
    public void update() throws Exception {
        if (this.isAutoUpdateEnabled() && !this.isUpdating() && this.getActiveTimeSource() != null) {
            this.updateTime(this.getActiveTimeSource().getTime());
        }
    }

    @Override
    public void updateTime(Date newTime) {
        if (this.getEarthOrbitModel() != null && this.isAutoUpdateEnabled()) {
            try {
                if (this.earthSurfaceLocation != null) {
                    SpacecraftState spacecraftState = this.getEarthOrbitModel().propagate(newTime);
                    double elevationAngle = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.getSpacecraftElevationAngle(spacecraftState, this.earthSurfaceLocation);
                    double azimuthAngle = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.getSpacecraftAzimuthAngle(spacecraftState, this.earthSurfaceLocation);
                    double range = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.getRange(spacecraftState, this.earthSurfaceLocation);
                    HorizontalCoordinates coord = ApogyEarthEnvironmentFactory.eINSTANCE.createHorizontalCoordinates();
                    coord.setAltitude(elevationAngle);
                    coord.setAzimuth(azimuthAngle);
                    coord.setRadius(range);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyEarthSurfaceOrbitEnvironmentUIPackage.Literals.EARTH_ORBITING_SPACECRAFT_LOCATION_TOOL__SPACECRAFT_POSITION, (Object)coord);
                }
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        this.attachToolNode();
        try {
            this.update();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void variablesInstantiated() {
        super.variablesInstantiated();
        this.attachToolNode();
        try {
            this.update();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void attachToolNode() {
        if (this.getEarthOrbitingSpacecraftLocationToolNode() != null) {
            EarthSky earthSky;
            this.detachToolNode();
            if (this.getActiveEarthSurfaceWorksite() != null && (earthSky = this.getActiveEarthSurfaceWorksite().getEarthSky()) != null && earthSky.getSkyNode() != null) {
                earthSky.getSkyNode().getChildren().add((Object)this.getEarthOrbitingSpacecraftLocationToolNode());
            }
        }
    }

    protected void detachToolNode() {
        if (this.getEarthOrbitingSpacecraftLocationToolNode() != null && this.getEarthOrbitingSpacecraftLocationToolNode().getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.getEarthOrbitingSpacecraftLocationToolNode().getParent();
            parent.getChildren().remove((Object)this.getEarthOrbitingSpacecraftLocationToolNode());
        }
    }
}

