/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.composites;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFactory;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.Duration;
import org.eclipse.apogy.core.environment.earth.EarthWorksite;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.EarthSky;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EarthSkyDayComposite
extends Composite {
    private EarthSky earthSky = null;
    private final SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss");
    private final DecimalFormat durationFormat = new DecimalFormat("00");
    private final Text sunRiseTime;
    private final Text sunSetTime;
    private final Text dayDuration;
    private DataBindingContext m_bindingContext;

    public EarthSkyDayComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        Label sunRiseLabel = new Label((Composite)this, 0);
        sunRiseLabel.setText("Sunrise Time (local) :");
        GridData gridData1 = new GridData();
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.widthHint = 70;
        gridData1.minimumWidth = 70;
        gridData1.horizontalAlignment = 16384;
        this.sunRiseTime = new Text((Composite)this, 131072);
        this.sunRiseTime.setLayoutData((Object)gridData1);
        this.sunRiseTime.setText("HH:MM:ss");
        this.sunRiseTime.setEditable(false);
        this.sunRiseTime.setToolTipText("Time, in local time, when the sun will cross the horizon at sunrise (does not include refraction).");
        Label sunSetLabel = new Label((Composite)this, 0);
        sunSetLabel.setText("Sunset Time (local) :");
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.widthHint = 70;
        gridData2.minimumWidth = 70;
        gridData2.horizontalAlignment = 16384;
        this.sunSetTime = new Text((Composite)this, 131072);
        this.sunSetTime.setLayoutData((Object)gridData2);
        this.sunSetTime.setText("HH:MM:ss");
        this.sunSetTime.setEditable(false);
        this.sunSetTime.setToolTipText("Time, in local time, when the sun will cross the horizon at sunset (does not include refraction).");
        Label sunHoursDurationLabel = new Label((Composite)this, 0);
        sunHoursDurationLabel.setText("Duration :");
        GridData gridData3 = new GridData();
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.widthHint = 70;
        gridData3.minimumWidth = 70;
        gridData3.horizontalAlignment = 16384;
        this.dayDuration = new Text((Composite)this, 131072);
        this.dayDuration.setLayoutData((Object)gridData3);
        this.dayDuration.setText("HH:MM:ss");
        this.dayDuration.setEditable(false);
        this.dayDuration.setToolTipText("Duration of day, from sunrise to sunset (does not include refraction) in hh:mm:ss format.");
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EarthSkyDayComposite.this.m_bindingContext != null) {
                    EarthSkyDayComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public EarthSky getEarthSky() {
        return this.earthSky;
    }

    public void setEarthSky(EarthSky earthSky) {
        this.setEarthSky(earthSky, true);
    }

    public void setEarthSky(EarthSky newEarthSky, boolean update) {
        this.earthSky = newEarthSky;
        if (update) {
            if (this.m_bindingContext != null) {
                this.m_bindingContext.dispose();
                this.m_bindingContext = null;
            }
            if (newEarthSky != null) {
                this.m_bindingContext = this.initDataBindings();
            }
        }
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue localTimeObserveValue = EMFProperties.value((FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyCommonEMFPackage.Literals.TIMED__TIME})).observe((Object)this.getEarthSky());
        IObservableValue sunRiseTimeText = PojoProperties.value((String)"text").observe((Object)this.sunRiseTime);
        bindingContext.bindValue(sunRiseTimeText, localTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(Date.class, String.class){

            public Object convert(Object arg0) {
                if (arg0 instanceof Date && EarthSkyDayComposite.this.getEarthSky().getWorksite() instanceof EarthWorksite) {
                    EarthWorksite earthWorksite = (EarthWorksite)EarthSkyDayComposite.this.getEarthSky().getWorksite();
                    Date date = (Date)arg0;
                    Date sunRise = AstronomyUtils.INSTANCE.getSunRiseTime(date, earthWorksite.getGeographicalCoordinates().getLongitude(), earthWorksite.getGeographicalCoordinates().getLatitude());
                    return EarthSkyDayComposite.this.timeFormat.format(sunRise);
                }
                return "?";
            }
        }));
        IObservableValue sunSetTimeText = PojoProperties.value((String)"text").observe((Object)this.sunSetTime);
        bindingContext.bindValue(sunSetTimeText, localTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(Date.class, String.class){

            public Object convert(Object arg0) {
                if (arg0 instanceof Date && EarthSkyDayComposite.this.getEarthSky().getWorksite() instanceof EarthWorksite) {
                    EarthWorksite earthWorksite = (EarthWorksite)EarthSkyDayComposite.this.getEarthSky().getWorksite();
                    Date date = (Date)arg0;
                    Date sunSet = AstronomyUtils.INSTANCE.getSunSetTime(date, earthWorksite.getGeographicalCoordinates().getLongitude(), earthWorksite.getGeographicalCoordinates().getLatitude());
                    return EarthSkyDayComposite.this.timeFormat.format(sunSet);
                }
                return "?";
            }
        }));
        IObservableValue dayDurationText = PojoProperties.value((String)"text").observe((Object)this.dayDuration);
        bindingContext.bindValue(dayDurationText, localTimeObserveValue, new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER), new UpdateValueStrategy().setConverter((IConverter)new Converter(Date.class, String.class){

            public Object convert(Object arg0) {
                if (arg0 instanceof Date && EarthSkyDayComposite.this.getEarthSky().getWorksite() instanceof EarthWorksite) {
                    EarthWorksite earthWorksite = (EarthWorksite)EarthSkyDayComposite.this.getEarthSky().getWorksite();
                    Date date = (Date)arg0;
                    Date sunRise = AstronomyUtils.INSTANCE.getSunRiseTime(date, earthWorksite.getGeographicalCoordinates().getLongitude(), earthWorksite.getGeographicalCoordinates().getLatitude());
                    Date sunSet = AstronomyUtils.INSTANCE.getSunSetTime(date, earthWorksite.getGeographicalCoordinates().getLongitude(), earthWorksite.getGeographicalCoordinates().getLatitude());
                    long delta = sunSet.getTime() - sunRise.getTime();
                    Duration duration = ApogyCommonEMFFactory.eINSTANCE.createDuration();
                    duration.setValue(delta);
                    return String.valueOf(EarthSkyDayComposite.this.durationFormat.format(duration.getHours())) + ":" + EarthSkyDayComposite.this.durationFormat.format(duration.getMinutes()) + ":" + EarthSkyDayComposite.this.durationFormat.format(duration.getSeconds());
                }
                return "?";
            }
        }));
        return bindingContext;
    }
}

