/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.surface.ui.impl;

import java.util.Calendar;
import java.util.Date;
import javax.vecmath.Matrix4d;
import org.eclipse.apogy.addons.ApogyAddonsPackage;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.NodePath;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.Sun;
import org.eclipse.apogy.core.environment.earth.EarthWorksite;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.environment.earth.surface.AstronomyUtils;
import org.eclipse.apogy.core.environment.earth.surface.AtmosphereUtils;
import org.eclipse.apogy.core.environment.earth.surface.ui.ApogyCoreEnvironmentSurfaceEarthUIFactory;
import org.eclipse.apogy.core.environment.earth.surface.ui.ApogyCoreEnvironmentSurfaceEarthUIPackage;
import org.eclipse.apogy.core.environment.earth.surface.ui.SunVector3DToolNode;
import org.eclipse.apogy.core.environment.earth.surface.ui.impl.SunVector3DToolImpl;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.core.topology.ApogyCoreTopologyFacade;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SunVector3DToolCustomImpl
extends SunVector3DToolImpl {
    private Date previousTime = null;

    @Override
    public void setVectorLength(double newVectorLength) {
        super.setVectorLength(Math.abs(newVectorLength));
    }

    public void initialise() {
        super.initialise();
        SunVector3DToolNode toolNode = ApogyCoreEnvironmentSurfaceEarthUIFactory.eINSTANCE.createSunVector3DToolNode();
        if (this.getName() != null) {
            toolNode.setDescription("Node associated with the SunVectorTool named <" + this.getName() + ">");
            toolNode.setNodeId("SUN_VECTOR_TOOL_" + this.getName().replaceAll(" ", "_"));
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentSurfaceEarthUIPackage.Literals.SUN_VECTOR3_DTOOL__SUN_VECTOR3_DTOOL_NODE, (Object)toolNode);
        this.attachSunVector3DToolNode();
        this.updateSunVector();
    }

    public void setRootNode(Node newRootNode) {
        super.setRootNode(newRootNode);
        this.attachSunVector3DToolNode();
        this.updateSunVector();
    }

    public void variablesInstantiated() {
        super.variablesInstantiated();
        this.attachSunVector3DToolNode();
        this.updateSunVector();
    }

    public void selectionChanged(NodeSelection nodeSelection) {
        if (!this.isDisposed()) {
            Node node = nodeSelection.getSelectedNode();
            Tuple3d relativePosition = null;
            if (nodeSelection.getRelativeIntersectionPoint() != null) {
                relativePosition = ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)nodeSelection.getRelativeIntersectionPoint());
            }
            if (!this.isToNodeLock()) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE, (Object)node);
                GroupNode root = ApogyCoreTopologyFacade.INSTANCE.getApogyTopology().getRootNode();
                NodePath nodePath = ApogyCommonTopologyFacade.INSTANCE.createNodePath((Node)root, node);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_NODE_NODE_PATH, (Object)nodePath);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__TO_RELATIVE_POSITION, (Object)relativePosition);
            }
            this.attachSunVector3DToolNode();
            this.updateSunVector();
        }
    }

    public void pointsRelativePoseChanged(Matrix4d newPose) {
        if (!this.isDisposed()) {
            this.updateSunVector();
        }
    }

    public boolean isFromNodeLock() {
        return true;
    }

    public Node getFromNode() {
        if (super.getFromNode() == null) {
            Sun sun = ApogyCoreEnvironmentFacade.INSTANCE.getActiveSun();
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyAddonsPackage.Literals.ABSTRACT_TWO_POINTS3_DTOOL__FROM_NODE, (Object)sun);
        }
        return super.getFromNode();
    }

    public void dispose() {
        super.dispose();
        if (this.sunVector3DToolNode != null && this.sunVector3DToolNode.getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.sunVector3DToolNode.getParent();
            parent.getChildren().remove((Object)this.sunVector3DToolNode);
            this.sunVector3DToolNode.setParent(null);
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentSurfaceEarthUIPackage.Literals.SUN_VECTOR3_DTOOL_NODE__SUN_VECTOR3_DTOOL, null);
    }

    protected void updateSunVector() {
        if (!this.isDisposed()) {
            this.updateSunIntensity();
        }
    }

    protected void updateSunIntensity() {
        double sunIntensity = 0.0;
        double currentSunIntensityPercentage = 0.0;
        EarthWorksite earthSurfaceWorksite = this.getActiveEarthWorksite();
        if (earthSurfaceWorksite != null) {
            Date date = earthSurfaceWorksite.getSky().getTime();
            double observerLongitude = earthSurfaceWorksite.getGeographicalCoordinates().getLongitude();
            double observerLatitude = earthSurfaceWorksite.getGeographicalCoordinates().getLatitude();
            HorizontalCoordinates sunCoordinates = AstronomyUtils.INSTANCE.getHorizontalSunPosition(date, observerLongitude, observerLatitude);
            sunIntensity = AtmosphereUtils.INSTANCE.getDirectSunIntensity(sunCoordinates.getAltitude(), earthSurfaceWorksite.getGeographicalCoordinates().getElevation());
            this.updateMaximumSunIntensity(earthSurfaceWorksite, date, observerLongitude, observerLatitude);
            currentSunIntensityPercentage = sunIntensity / this.getCurrentDayMaximumSunIntensity() * 100.0;
            if (currentSunIntensityPercentage > 100.0) {
                currentSunIntensityPercentage = 100.0;
            }
        }
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentSurfaceEarthUIPackage.Literals.SUN_VECTOR3_DTOOL__SUN_INTENSITY, (Object)sunIntensity);
        ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentSurfaceEarthUIPackage.Literals.SUN_VECTOR3_DTOOL__CURRENT_SUN_INTENSITY_PERCENTAGE, (Object)currentSunIntensityPercentage);
    }

    protected EarthWorksite getActiveEarthWorksite() {
        ApogyEnvironment apogyEnvironment;
        Environment environment;
        InvocatorSession invocatorSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        if (invocatorSession != null && (environment = invocatorSession.getEnvironment()) instanceof ApogyEnvironment && (apogyEnvironment = (ApogyEnvironment)environment).getActiveWorksite() instanceof EarthWorksite) {
            return (EarthWorksite)apogyEnvironment.getActiveWorksite();
        }
        return null;
    }

    private boolean dayHasChanged(Date currentDate, Date previousDate) {
        Calendar calendarCurrent = Calendar.getInstance();
        calendarCurrent.setTime(currentDate);
        Calendar calendarPrevious = Calendar.getInstance();
        calendarPrevious.setTime(previousDate);
        if (calendarCurrent.get(1) != calendarPrevious.get(1)) {
            return true;
        }
        if (calendarCurrent.get(2) != calendarPrevious.get(2)) {
            return true;
        }
        return calendarCurrent.get(5) != calendarPrevious.get(5);
    }

    private void updateMaximumSunIntensity(EarthWorksite earthSurfaceWorksite, Date date, double observerLongitude, double observerLatitude) {
        Date highestSunTime;
        if ((this.previousTime == null || this.dayHasChanged(date, this.previousTime)) && (highestSunTime = AstronomyUtils.INSTANCE.getSunHighestElevationTime(date, observerLongitude, observerLatitude)) != null) {
            HorizontalCoordinates highestSunCoordinates = AstronomyUtils.INSTANCE.getHorizontalSunPosition(highestSunTime, observerLongitude, observerLatitude);
            double maximumSunIntensity = AtmosphereUtils.INSTANCE.getDirectSunIntensity(highestSunCoordinates.getAltitude(), earthSurfaceWorksite.getGeographicalCoordinates().getElevation());
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCoreEnvironmentSurfaceEarthUIPackage.Literals.SUN_VECTOR3_DTOOL__CURRENT_DAY_MAXIMUM_SUN_INTENSITY, (Object)maximumSunIntensity);
        }
        this.previousTime = date;
    }

    protected void attachSunVector3DToolNode() {
        if (this.getSunVector3DToolNode() != null) {
            GroupNode groupNode = null;
            if (this.getToNode() == null) {
                this.detachSunVector3DToolNode();
            } else {
                if (this.getToNode() instanceof GroupNode) {
                    groupNode = (GroupNode)this.getToNode();
                } else if (this.getToNode().getParent() instanceof GroupNode) {
                    groupNode = (GroupNode)this.getToNode().getParent();
                }
                if (groupNode != null && !groupNode.getChildren().contains((Object)this.getSunVector3DToolNode())) {
                    groupNode.getChildren().add((Object)this.getSunVector3DToolNode());
                }
            }
        }
    }

    protected void detachSunVector3DToolNode() {
        if (this.getSunVector3DToolNode() != null && this.getSunVector3DToolNode().getParent() instanceof GroupNode) {
            GroupNode parent = (GroupNode)this.getSunVector3DToolNode().getParent();
            parent.getChildren().remove((Object)this.getSunVector3DToolNode());
        }
    }
}

