/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.earth.impl;

import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.math.ApogyCommonMathPackage;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.bindings.ApogyCommonTopologyBindingsPackage;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.ApogyEarthEnvironmentFactory;
import org.eclipse.apogy.core.environment.earth.ApogyEarthEnvironmentPackage;
import org.eclipse.apogy.core.environment.earth.ApogyEarthFacade;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.EarthWorksite;
import org.eclipse.apogy.core.environment.earth.EclipticCoordinates;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.earth.HorizontalCoordinates;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.impl.EPackageImpl;

public class ApogyEarthEnvironmentPackageImpl
extends EPackageImpl
implements ApogyEarthEnvironmentPackage {
    private EClass geographicCoordinatesEClass = null;
    private EClass earthSurfaceLocationEClass = null;
    private EClass horizontalCoordinatesEClass = null;
    private EClass eclipticCoordinatesEClass = null;
    private EClass earthWorksiteEClass = null;
    private EClass apogyEarthFacadeEClass = null;
    private EDataType listEDataType = null;
    private EDataType exceptionEDataType = null;
    private static boolean isInited = false;
    private boolean isCreated = false;
    private boolean isInitialized = false;

    private ApogyEarthEnvironmentPackageImpl() {
        super("org.eclipse.apogy.core.environment.earth", (EFactory)ApogyEarthEnvironmentFactory.eINSTANCE);
    }

    public static ApogyEarthEnvironmentPackage init() {
        if (isInited) {
            return (ApogyEarthEnvironmentPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment.earth");
        }
        Object registeredApogyEarthEnvironmentPackage = EPackage.Registry.INSTANCE.get((Object)"org.eclipse.apogy.core.environment.earth");
        ApogyEarthEnvironmentPackageImpl theApogyEarthEnvironmentPackage = registeredApogyEarthEnvironmentPackage instanceof ApogyEarthEnvironmentPackageImpl ? (ApogyEarthEnvironmentPackageImpl)registeredApogyEarthEnvironmentPackage : new ApogyEarthEnvironmentPackageImpl();
        isInited = true;
        EcorePackage.eINSTANCE.eClass();
        ApogyCoreEnvironmentPackage.eINSTANCE.eClass();
        ApogyCommonEMFPackage.eINSTANCE.eClass();
        ApogyCommonMathPackage.eINSTANCE.eClass();
        ApogyCorePackage.eINSTANCE.eClass();
        ApogyCoreInvocatorPackage.eINSTANCE.eClass();
        ApogyCommonTopologyPackage.eINSTANCE.eClass();
        ApogyCommonTopologyBindingsPackage.eINSTANCE.eClass();
        theApogyEarthEnvironmentPackage.createPackageContents();
        theApogyEarthEnvironmentPackage.initializePackageContents();
        theApogyEarthEnvironmentPackage.freeze();
        EPackage.Registry.INSTANCE.put((Object)"org.eclipse.apogy.core.environment.earth", (Object)theApogyEarthEnvironmentPackage);
        return theApogyEarthEnvironmentPackage;
    }

    @Override
    public EClass getGeographicCoordinates() {
        return this.geographicCoordinatesEClass;
    }

    @Override
    public EAttribute getGeographicCoordinates_Longitude() {
        return (EAttribute)this.geographicCoordinatesEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getGeographicCoordinates_Latitude() {
        return (EAttribute)this.geographicCoordinatesEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getGeographicCoordinates_Elevation() {
        return (EAttribute)this.geographicCoordinatesEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getEarthSurfaceLocation() {
        return this.earthSurfaceLocationEClass;
    }

    @Override
    public EClass getHorizontalCoordinates() {
        return this.horizontalCoordinatesEClass;
    }

    @Override
    public EAttribute getHorizontalCoordinates_Altitude() {
        return (EAttribute)this.horizontalCoordinatesEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getHorizontalCoordinates_Azimuth() {
        return (EAttribute)this.horizontalCoordinatesEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getHorizontalCoordinates_Radius() {
        return (EAttribute)this.horizontalCoordinatesEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getEclipticCoordinates() {
        return this.eclipticCoordinatesEClass;
    }

    @Override
    public EAttribute getEclipticCoordinates_Longitude() {
        return (EAttribute)this.eclipticCoordinatesEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getEclipticCoordinates_Latitude() {
        return (EAttribute)this.eclipticCoordinatesEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EAttribute getEclipticCoordinates_Radius() {
        return (EAttribute)this.eclipticCoordinatesEClass.getEStructuralFeatures().get(2);
    }

    @Override
    public EClass getEarthWorksite() {
        return this.earthWorksiteEClass;
    }

    @Override
    public EReference getEarthWorksite_GeographicalCoordinates() {
        return (EReference)this.earthWorksiteEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EAttribute getEarthWorksite_SunIntensity() {
        return (EAttribute)this.earthWorksiteEClass.getEStructuralFeatures().get(1);
    }

    @Override
    public EClass getApogyEarthFacade() {
        return this.apogyEarthFacadeEClass;
    }

    @Override
    public EReference getApogyEarthFacade_ActiveEarthWorksite() {
        return (EReference)this.apogyEarthFacadeEClass.getEStructuralFeatures().get(0);
    }

    @Override
    public EOperation getApogyEarthFacade__GetMoonVector__ApogySystem_String_Environment() {
        return (EOperation)this.apogyEarthFacadeEClass.getEOperations().get(0);
    }

    @Override
    public EOperation getApogyEarthFacade__GetMoonVector__Node_Environment() {
        return (EOperation)this.apogyEarthFacadeEClass.getEOperations().get(1);
    }

    @Override
    public EOperation getApogyEarthFacade__CreateGeographicCoordinates__double_double_double() {
        return (EOperation)this.apogyEarthFacadeEClass.getEOperations().get(2);
    }

    @Override
    public EOperation getApogyEarthFacade__CreateEarthSurfaceLocation__String_String_double_double_double() {
        return (EOperation)this.apogyEarthFacadeEClass.getEOperations().get(3);
    }

    @Override
    public EOperation getApogyEarthFacade__LoadGeographicCoordinatesFromURL__String() {
        return (EOperation)this.apogyEarthFacadeEClass.getEOperations().get(4);
    }

    @Override
    public EDataType getList() {
        return this.listEDataType;
    }

    @Override
    public EDataType getException() {
        return this.exceptionEDataType;
    }

    @Override
    public ApogyEarthEnvironmentFactory getApogyEarthEnvironmentFactory() {
        return (ApogyEarthEnvironmentFactory)this.getEFactoryInstance();
    }

    public void createPackageContents() {
        if (this.isCreated) {
            return;
        }
        this.isCreated = true;
        this.geographicCoordinatesEClass = this.createEClass(0);
        this.createEAttribute(this.geographicCoordinatesEClass, 0);
        this.createEAttribute(this.geographicCoordinatesEClass, 1);
        this.createEAttribute(this.geographicCoordinatesEClass, 2);
        this.earthSurfaceLocationEClass = this.createEClass(1);
        this.horizontalCoordinatesEClass = this.createEClass(2);
        this.createEAttribute(this.horizontalCoordinatesEClass, 0);
        this.createEAttribute(this.horizontalCoordinatesEClass, 1);
        this.createEAttribute(this.horizontalCoordinatesEClass, 2);
        this.eclipticCoordinatesEClass = this.createEClass(3);
        this.createEAttribute(this.eclipticCoordinatesEClass, 0);
        this.createEAttribute(this.eclipticCoordinatesEClass, 1);
        this.createEAttribute(this.eclipticCoordinatesEClass, 2);
        this.earthWorksiteEClass = this.createEClass(4);
        this.createEReference(this.earthWorksiteEClass, 6);
        this.createEAttribute(this.earthWorksiteEClass, 7);
        this.apogyEarthFacadeEClass = this.createEClass(5);
        this.createEReference(this.apogyEarthFacadeEClass, 0);
        this.createEOperation(this.apogyEarthFacadeEClass, 0);
        this.createEOperation(this.apogyEarthFacadeEClass, 1);
        this.createEOperation(this.apogyEarthFacadeEClass, 2);
        this.createEOperation(this.apogyEarthFacadeEClass, 3);
        this.createEOperation(this.apogyEarthFacadeEClass, 4);
        this.listEDataType = this.createEDataType(6);
        this.exceptionEDataType = this.createEDataType(7);
    }

    public void initializePackageContents() {
        if (this.isInitialized) {
            return;
        }
        this.isInitialized = true;
        this.setName("earth");
        this.setNsPrefix("earth");
        this.setNsURI("org.eclipse.apogy.core.environment.earth");
        EcorePackage theEcorePackage = (EcorePackage)EPackage.Registry.INSTANCE.getEPackage("http://www.eclipse.org/emf/2002/Ecore");
        ApogyCoreEnvironmentPackage theApogyCoreEnvironmentPackage = (ApogyCoreEnvironmentPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.environment");
        ApogyCommonMathPackage theApogyCommonMathPackage = (ApogyCommonMathPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.math");
        ApogyCorePackage theApogyCorePackage = (ApogyCorePackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core");
        ApogyCoreInvocatorPackage theApogyCoreInvocatorPackage = (ApogyCoreInvocatorPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.core.invocator");
        ApogyCommonTopologyPackage theApogyCommonTopologyPackage = (ApogyCommonTopologyPackage)EPackage.Registry.INSTANCE.getEPackage("org.eclipse.apogy.common.topology");
        this.addETypeParameter((EClassifier)this.listEDataType, "T");
        this.earthSurfaceLocationEClass.getESuperTypes().add((Object)this.getGeographicCoordinates());
        this.earthSurfaceLocationEClass.getESuperTypes().add((Object)theApogyCoreEnvironmentPackage.getAbstractSurfaceLocation());
        this.earthWorksiteEClass.getESuperTypes().add((Object)theApogyCoreEnvironmentPackage.getWorksite());
        this.initEClass(this.geographicCoordinatesEClass, GeographicCoordinates.class, "GeographicCoordinates", false, false, true);
        this.initEAttribute(this.getGeographicCoordinates_Longitude(), (EClassifier)theEcorePackage.getEDouble(), "longitude", null, 0, 1, GeographicCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getGeographicCoordinates_Latitude(), (EClassifier)theEcorePackage.getEDouble(), "latitude", null, 0, 1, GeographicCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getGeographicCoordinates_Elevation(), (EClassifier)theEcorePackage.getEDouble(), "elevation", null, 0, 1, GeographicCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.earthSurfaceLocationEClass, EarthSurfaceLocation.class, "EarthSurfaceLocation", false, false, true);
        this.initEClass(this.horizontalCoordinatesEClass, HorizontalCoordinates.class, "HorizontalCoordinates", false, false, true);
        this.initEAttribute(this.getHorizontalCoordinates_Altitude(), (EClassifier)theEcorePackage.getEDouble(), "altitude", null, 0, 1, HorizontalCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getHorizontalCoordinates_Azimuth(), (EClassifier)theEcorePackage.getEDouble(), "azimuth", null, 0, 1, HorizontalCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getHorizontalCoordinates_Radius(), (EClassifier)theEcorePackage.getEDouble(), "radius", null, 0, 1, HorizontalCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.eclipticCoordinatesEClass, EclipticCoordinates.class, "EclipticCoordinates", false, false, true);
        this.initEAttribute(this.getEclipticCoordinates_Longitude(), (EClassifier)theEcorePackage.getEDouble(), "longitude", null, 0, 1, EclipticCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getEclipticCoordinates_Latitude(), (EClassifier)theEcorePackage.getEDouble(), "latitude", null, 0, 1, EclipticCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEAttribute(this.getEclipticCoordinates_Radius(), (EClassifier)theEcorePackage.getEDouble(), "radius", null, 0, 1, EclipticCoordinates.class, false, false, true, false, false, false, false, true);
        this.initEClass(this.earthWorksiteEClass, EarthWorksite.class, "EarthWorksite", true, false, true);
        this.initEReference(this.getEarthWorksite_GeographicalCoordinates(), (EClassifier)this.getGeographicCoordinates(), null, "geographicalCoordinates", null, 1, 1, EarthWorksite.class, false, false, true, true, false, false, true, false, true);
        this.initEAttribute(this.getEarthWorksite_SunIntensity(), (EClassifier)theEcorePackage.getEDouble(), "sunIntensity", "0", 0, 1, EarthWorksite.class, true, false, true, false, false, false, false, true);
        this.initEClass(this.apogyEarthFacadeEClass, ApogyEarthFacade.class, "ApogyEarthFacade", false, false, true);
        this.initEReference(this.getApogyEarthFacade_ActiveEarthWorksite(), (EClassifier)this.getEarthWorksite(), null, "activeEarthWorksite", null, 0, 1, ApogyEarthFacade.class, true, false, true, false, true, false, true, false, true);
        EOperation op = this.initEOperation(this.getApogyEarthFacade__GetMoonVector__ApogySystem_String_Environment(), (EClassifier)theApogyCommonMathPackage.getTuple3d(), "getMoonVector", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCorePackage.getApogySystem(), "apogySystem", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEString(), "nodeID", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreInvocatorPackage.getEnvironment(), "environment", 0, 1, false, true);
        op = this.initEOperation(this.getApogyEarthFacade__GetMoonVector__Node_Environment(), (EClassifier)theApogyCommonMathPackage.getTuple3d(), "getMoonVector", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCommonTopologyPackage.getNode(), "node", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theApogyCoreInvocatorPackage.getEnvironment(), "environment", 0, 1, false, true);
        op = this.initEOperation(this.getApogyEarthFacade__CreateGeographicCoordinates__double_double_double(), (EClassifier)this.getGeographicCoordinates(), "createGeographicCoordinates", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "longitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "latitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "altitude", 0, 1, false, true);
        op = this.initEOperation(this.getApogyEarthFacade__CreateEarthSurfaceLocation__String_String_double_double_double(), (EClassifier)this.getEarthSurfaceLocation(), "createEarthSurfaceLocation", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEString(), "name", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEString(), "description", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "longitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "latitude", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEDouble(), "elevation", 0, 1, false, true);
        op = this.initEOperation(this.getApogyEarthFacade__LoadGeographicCoordinatesFromURL__String(), null, "loadGeographicCoordinatesFromURL", 0, 1, false, true);
        this.addEParameter(op, (EClassifier)theEcorePackage.getEString(), "url", 0, 1, false, true);
        this.addEException(op, (EClassifier)this.getException());
        EGenericType g1 = this.createEGenericType((EClassifier)this.getList());
        EGenericType g2 = this.createEGenericType((EClassifier)this.getGeographicCoordinates());
        g1.getETypeArguments().add((Object)g2);
        this.initEOperation(op, g1);
        this.initEDataType(this.listEDataType, List.class, "List", true, false);
        this.initEDataType(this.exceptionEDataType, Exception.class, "Exception", true, false);
        this.createResource("org.eclipse.apogy.core.environment.earth");
        this.createGenModelAnnotations();
        this.createApogyAnnotations();
    }

    protected void createGenModelAnnotations() {
        String source = "http://www.eclipse.org/emf/2002/GenModel";
        this.addAnnotation((ENamedElement)this, source, new String[]{"prefix", "ApogyEarthEnvironment", "childCreationExtenders", "true", "extensibleProviderFactory", "true", "multipleEditorPages", "false", "copyrightText", "*******************************************************************************\nCopyright (c) 2018 Agence spatiale canadienne / Canadian Space Agency \nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\nwhich accompanies this distribution, and is available at\nhttp://www.eclipse.org/legal/epl-v10.html\n\nContributors:\n     Pierre Allard - initial API and implementation\n     Regent L'Archeveque \n        \nSPDX-License-Identifier: EPL-1.0    \n*******************************************************************************", "modelName", "ApogyCoreEnvironment", "complianceLevel", "8.0", "suppressGenModelAnnotations", "false", "dynamicTemplates", "true", "templateDirectory", "platform:/plugin/org.eclipse.apogy.common.emf.codegen/templates", "modelDirectory", "/org.eclipse.apogy.core.environment.earth/src-gen", "editDirectory", "/org.eclipse.apogy.core.environment.earth.edit/src-gen", "basePackage", "org.eclipse.apogy.core.environment"});
        this.addAnnotation((ENamedElement)this.geographicCoordinatesEClass, source, new String[]{"documentation", "A location on Earth."});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinates_Longitude(), source, new String[]{"documentation", "*\nThe longitude, in radians. Longitude east of Greenwich, UK  are positive\nwhile those west of Greenwich are negative.", "propertyCategory", "GEOGRAPHIC_COORDINATES"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinates_Latitude(), source, new String[]{"documentation", "*\nThe latitude, in radians. Latitude north of the equator are positive while those\nsouth of the equator are negative.", "propertyCategory", "GEOGRAPHIC_COORDINATES"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinates_Elevation(), source, new String[]{"documentation", "*\nHeight above the Earth's sea level, in meters.", "propertyCategory", "GEOGRAPHIC_COORDINATES"});
        this.addAnnotation((ENamedElement)this.earthSurfaceLocationEClass, source, new String[]{"documentation", "*\nDefines a location on the surface of the Earth."});
        this.addAnnotation((ENamedElement)this.horizontalCoordinatesEClass, source, new String[]{"documentation", "*\nThe horizontal coordinate system is a celestial coordinate system that uses the\nobserver's local horizon as the fundamental plane. This conveniently divides the\nsky into the upper hemisphere that you can see, and the lower hemisphere that you\ncannot (because the Earth is in the way). The pole of the upper hemisphere is called\nthe zenith. The pole of the lower hemisphere is called the nadir."});
        this.addAnnotation((ENamedElement)this.getHorizontalCoordinates_Altitude(), source, new String[]{"documentation", "*\nSometimes referred to as elevation, that is the angle between the\nobject and the observer's local horizon. Negative altitude means the\nobject is below the local horizon."});
        this.addAnnotation((ENamedElement)this.getHorizontalCoordinates_Azimuth(), source, new String[]{"documentation", "*\nThe angle of the object around the horizon, measured from the\nnorth point towards the east."});
        this.addAnnotation((ENamedElement)this.getHorizontalCoordinates_Radius(), source, new String[]{"documentation", "*\nThe distance from the observer."});
        this.addAnnotation((ENamedElement)this.eclipticCoordinatesEClass, source, new String[]{"documentation", "*\nThe ecliptic coordinate system is a celestial coordinate system that uses the ecliptic\nfor its fundamental plane. The ecliptic is the path that the sun appears to follow across\nthe sky over the course of a year. It is also the projection of the Earth's orbital plane\nonto the celestial sphere. The latitudinal angle is called the ecliptic latitude or celestial\nlatitude (denoted \u03b2), measured positive towards the north. The longitudinal angle is called\nthe ecliptic longitude or celestial longitude (denoted \u03bb), measured eastwards from 0\u00b0 to 360\u00b0.\nLike right ascension in the equatorial coordinate system, 0\u00b0 ecliptic longitude is pointing\ntowards the Sun from the Earth at the Northern hemisphere vernal equinox. This choice makes\nthe coordinates of the fixed stars subject to shifts due to the precession, so that always a\nreference epoch should be specified. Usually epoch J2000.0 is taken, but the instantaneous\nequinox of the day (called the epoch of date) is possible too. This coordinate system can be\nparticularly useful for charting solar system objects. Most planets (except Mercury), and many\nsmall solar system bodies have orbits with small inclinations to the ecliptic plane, and therefore\ntheir ecliptic latitude \u03b2 is always small. Because of the planets' small deviation from the plane\nof the ecliptic, ecliptic coordinates were used historically to compute their positions. (Aaboe 2001, 17-19)"});
        this.addAnnotation((ENamedElement)this.getEclipticCoordinates_Longitude(), source, new String[]{"documentation", "*\nThe ecliptic longitude or celestial longitude (denoted \u03bb), measured eastwards from 0\u00b0 to 360\u00b0."});
        this.addAnnotation((ENamedElement)this.getEclipticCoordinates_Latitude(), source, new String[]{"documentation", "*\nThe ecliptic latitude or celestial latitude (denoted \u03b2), measured positive towards the north."});
        this.addAnnotation((ENamedElement)this.getEclipticCoordinates_Radius(), source, new String[]{"documentation", "*\nThe distance from the center of the Sun."});
        this.addAnnotation((ENamedElement)this.earthWorksiteEClass, source, new String[]{"documentation", "*\nWorksite defined for Earth"});
        this.addAnnotation((ENamedElement)this.getEarthWorksite_GeographicalCoordinates(), source, new String[]{"documentation", "The geographical coordinates of the origin of the worksite, in the WS84 datum."});
        this.addAnnotation((ENamedElement)this.getEarthWorksite_SunIntensity(), source, new String[]{"documentation", "*\nThe current sun intensity at the surface of the worksite.", "property", "Readonly"});
        this.addAnnotation((ENamedElement)this.apogyEarthFacadeEClass, source, new String[]{"documentation", "*\nFacade for Earth Environment."});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade__GetMoonVector__ApogySystem_String_Environment(), source, new String[]{"documentation", "*\nReturn a unit vector pointing toward the Moon. The vector is defined for a specified topology node within a specified ApogySystem.\n@param apogySystem The ApogySystem containing the specified Node.\n@param nodeID The ID of the specified Node.\n@return The unit vector pointing toward the Moon, defined in the specified node coordinates, null if none is found."});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade__GetMoonVector__Node_Environment(), source, new String[]{"documentation", "*\nReturn a unit vector pointing toward the Moon. The vector is defined for a specified topology node.\n@param nodeID The ID of the specified Node.\n@return The unit vector pointing toward the Moon, defined in the specified node coordinates, null if none is found."});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade__CreateGeographicCoordinates__double_double_double(), source, new String[]{"documentation", "*\nCreate a GeographicCoordinates.\n@param longitude The longitude, in radians.\n@param latitude The latitude, in radians.\n@param altitude The altitude, in meters."});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade__CreateEarthSurfaceLocation__String_String_double_double_double(), source, new String[]{"documentation", "Creates an EarthSurfaceLocation from parameters.\n@param name The name of the location.\n@param description The description of the location.\n@param longitude The longitude of the location, in radians.\n@param latitude The latitude of the location, in radians.\n@param elevation The elevation of the location, in meters.\n@return The EarthSurfaceLocation."});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade__LoadGeographicCoordinatesFromURL__String(), source, new String[]{"documentation", "*\nLoads a list of GeographicCoordinates from a CSV formated file (Longitude, Latitude, Altitude). Longitude, Latitude are expected in degrees, Altitude in meters.\n@param url File URL.\n@return The list of GeographicCoordinates. Never null, but can be empty.\n@throws An exception if a probelm occures during load."});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade_ActiveEarthWorksite(), source, new String[]{"documentation", "*\nRefers to the active EarthWorksite. May be null."});
    }

    protected void createApogyAnnotations() {
        String source = "http://www.eclipse.org/apogy";
        this.addAnnotation((ENamedElement)this.geographicCoordinatesEClass, source, new String[]{"hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinates_Longitude(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinates_Latitude(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getGeographicCoordinates_Elevation(), source, new String[]{"units", "m"});
        this.addAnnotation((ENamedElement)this.earthSurfaceLocationEClass, source, new String[]{"hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.horizontalCoordinatesEClass, source, new String[]{"hasCustomItemProvider", "true"});
        this.addAnnotation((ENamedElement)this.getHorizontalCoordinates_Altitude(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getHorizontalCoordinates_Azimuth(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getHorizontalCoordinates_Radius(), source, new String[]{"units", "m"});
        this.addAnnotation((ENamedElement)this.getEclipticCoordinates_Longitude(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getEclipticCoordinates_Latitude(), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getEclipticCoordinates_Radius(), source, new String[]{"units", "m"});
        this.addAnnotation((ENamedElement)this.getEarthWorksite_SunIntensity(), source, new String[]{"units", "W/m^2"});
        this.addAnnotation((ENamedElement)this.apogyEarthFacadeEClass, source, new String[]{"isSingleton", "true", "hasCustomClass", "true"});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade__CreateEarthSurfaceLocation__String_String_double_double_double().getEParameters().get(2), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade__CreateEarthSurfaceLocation__String_String_double_double_double().getEParameters().get(3), source, new String[]{"units", "rad"});
        this.addAnnotation((ENamedElement)this.getApogyEarthFacade__CreateEarthSurfaceLocation__String_String_double_double_double().getEParameters().get(4), source, new String[]{"units", "m"});
    }
}

