/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.ui.composites;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.environment.orbit.earth.GroundStation;
import org.eclipse.apogy.core.environment.orbit.earth.SpacecraftsVisibilitySet;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.core.environment.orbit.earth.ui.composites.SpacecraftVisibilitySetViewerComparator;
import org.eclipse.apogy.core.environment.orbit.earth.ui.composites.ViewerElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.progress.UIJob;

public class SpacecraftsVisibilitySetComposite
extends Composite {
    public static final String DEGREE_STRING = "\u00b0";
    public static final String UPWARDS_ARROW_STRING = "\u2191";
    public static final String DOWNWARDS_ARROW_STRING = "\u2193";
    private final SpacecraftVisibilitySetViewerComparator viewerComparator;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private Adapter spacecraftsVisibilitySetAdapter = null;
    private SpacecraftsVisibilitySet spacecraftsVisibilitySet;
    private final TableViewer viewer;

    public SpacecraftsVisibilitySetComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.viewer = this.createTableViewer(this);
        this.viewerComparator = new SpacecraftVisibilitySetViewerComparator();
        this.viewer.setComparator((ViewerComparator)this.viewerComparator);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ViewerElement selectedViewerElement = (ViewerElement)((StructuredSelection)event.getSelection()).getFirstElement();
                SpacecraftsVisibilitySetComposite.this.newViewerElementSelected(selectedViewerElement);
            }
        });
    }

    public SpacecraftsVisibilitySet getSpacecraftsVisibilitySet() {
        return this.spacecraftsVisibilitySet;
    }

    public void setSpacecraftsVisibilitySet(SpacecraftsVisibilitySet newSpacecraftsVisibilitySet) {
        if (this.spacecraftsVisibilitySet != null) {
            this.spacecraftsVisibilitySet.eAdapters().remove((Object)this.getSpacecraftsVisibilitySetAdapter());
        }
        this.spacecraftsVisibilitySet = newSpacecraftsVisibilitySet;
        if (newSpacecraftsVisibilitySet != null) {
            ViewerElement[] elements = this.getEntries(this.spacecraftsVisibilitySet);
            this.viewer.setInput((Object)elements);
            newSpacecraftsVisibilitySet.eAdapters().add((Object)this.getSpacecraftsVisibilitySetAdapter());
        }
    }

    protected void newViewerElementSelected(ViewerElement viewerElement) {
    }

    protected ViewerElement[] getEntries(SpacecraftsVisibilitySet spacecraftsVisibilitySet) {
        ArrayList<ViewerElement> elements = new ArrayList<ViewerElement>();
        for (GroundStation groundStation : spacecraftsVisibilitySet.getGroundStationToVisibilityMap().keySet()) {
            List passes = (List)spacecraftsVisibilitySet.getGroundStationToVisibilityMap().get(groundStation);
            for (VisibilityPass pass : passes) {
                ViewerElement element = new ViewerElement(groundStation, pass);
                elements.add(element);
            }
        }
        return elements.toArray(new ViewerElement[elements.size()]);
    }

    protected TableViewer createTableViewer(Composite parent) {
        TableViewer viewer = new TableViewer(parent, 68354);
        this.createColumns(parent, viewer);
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        return viewer;
    }

    protected void createColumns(Composite parent, TableViewer viewer) {
        TableViewerColumn colStation = this.createTableViewerColumn(viewer, SpacecraftsVisibilitySetColumns.GROUND_STATION);
        colStation.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ViewerElement) {
                    String text = "";
                    ViewerElement viewerElement = (ViewerElement)element;
                    GroundStation groundStation = viewerElement.groundStation;
                    if (groundStation.getName() != null) {
                        text = String.valueOf(text) + groundStation.getName();
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("0.00");
                    text = String.valueOf(text) + " (lat " + decimalFormat.format(Math.toDegrees(groundStation.getLatitude())) + SpacecraftsVisibilitySetComposite.DEGREE_STRING;
                    text = String.valueOf(text) + ", lon " + decimalFormat.format(Math.toDegrees(groundStation.getLongitude())) + SpacecraftsVisibilitySetComposite.DEGREE_STRING;
                    text = String.valueOf(text) + ")";
                    return text;
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colSpacecraft = this.createTableViewerColumn(viewer, SpacecraftsVisibilitySetColumns.SPACECRAFT);
        colSpacecraft.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ViewerElement) {
                    ViewerElement viewerElement = (ViewerElement)element;
                    VisibilityPass pass = viewerElement.pass;
                    if (pass.getOrbitModel() != null) {
                        return pass.getOrbitModel().getName();
                    }
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colStartDate = this.createTableViewerColumn(viewer, SpacecraftsVisibilitySetColumns.START_DATE);
        colStartDate.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ViewerElement) {
                    ViewerElement viewerElement = (ViewerElement)element;
                    VisibilityPass pass = viewerElement.pass;
                    return SpacecraftsVisibilitySetComposite.this.dateFormat.format(pass.getStartTime());
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colEndDate = this.createTableViewerColumn(viewer, SpacecraftsVisibilitySetColumns.END_DATE);
        colEndDate.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ViewerElement) {
                    ViewerElement viewerElement = (ViewerElement)element;
                    VisibilityPass pass = viewerElement.pass;
                    return SpacecraftsVisibilitySetComposite.this.dateFormat.format(pass.getEndTime());
                }
                return super.getText(element);
            }
        });
        TableViewerColumn colDuration = this.createTableViewerColumn(viewer, SpacecraftsVisibilitySetColumns.DURATION);
        colDuration.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof ViewerElement) {
                    ViewerElement viewerElement = (ViewerElement)element;
                    VisibilityPass pass = viewerElement.pass;
                    DecimalFormat decimalFormat = new DecimalFormat("0.0");
                    return decimalFormat.format(pass.getDuration());
                }
                return super.getText(element);
            }
        });
    }

    private TableViewerColumn createTableViewerColumn(TableViewer viewer, SpacecraftsVisibilitySetColumns col) {
        TableViewerColumn viewerColumn = new TableViewerColumn(viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(String.valueOf(col.getName()) + UPWARDS_ARROW_STRING);
        column.setWidth(col.columnWidth);
        column.setResizable(true);
        column.setMoveable(true);
        column.addSelectionListener((SelectionListener)this.getSelectionAdapter(column, col));
        return viewerColumn;
    }

    public Adapter getSpacecraftsVisibilitySetAdapter() {
        if (this.spacecraftsVisibilitySetAdapter == null) {
            this.spacecraftsVisibilitySetAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof SpacecraftsVisibilitySet) {
                        int featureId = msg.getFeatureID(SpacecraftsVisibilitySet.class);
                        switch (featureId) {
                            case 9: {
                                if (msg.getNewValue() == null) break;
                                UIJob uiJob = new UIJob("SpacecraftsVisibilitySetComposite update"){

                                    public IStatus runInUIThread(IProgressMonitor monitor) {
                                        ViewerElement[] elements = SpacecraftsVisibilitySetComposite.this.getEntries(SpacecraftsVisibilitySetComposite.this.spacecraftsVisibilitySet);
                                        SpacecraftsVisibilitySetComposite.this.viewer.setInput((Object)elements);
                                        return Status.OK_STATUS;
                                    }
                                };
                                uiJob.schedule();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.spacecraftsVisibilitySetAdapter;
    }

    private SelectionAdapter getSelectionAdapter(final TableColumn column, final SpacecraftsVisibilitySetColumns col) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpacecraftsVisibilitySetComposite.this.viewerComparator.setColumn(col);
                int dir = SpacecraftsVisibilitySetComposite.this.viewerComparator.getDirection();
                SpacecraftsVisibilitySetComposite.this.viewer.getTable().setSortDirection(dir);
                SpacecraftsVisibilitySetComposite.this.viewer.getTable().setSortColumn(column);
                if (e.widget instanceof TableColumn) {
                    TableColumn tableColumn = (TableColumn)e.widget;
                    if (dir == 1) {
                        tableColumn.setText(String.valueOf(col.getName()) + SpacecraftsVisibilitySetComposite.DOWNWARDS_ARROW_STRING);
                    } else {
                        tableColumn.setText(String.valueOf(col.getName()) + SpacecraftsVisibilitySetComposite.UPWARDS_ARROW_STRING);
                    }
                }
                SpacecraftsVisibilitySetComposite.this.viewer.refresh();
            }
        };
        return selectionAdapter;
    }

    public static enum SpacecraftsVisibilitySetColumns {
        GROUND_STATION("Ground Station", 0, 250),
        SPACECRAFT("Spacecraft", 1, 100),
        START_DATE("Start Date", 2, 250),
        END_DATE("End Date", 3, 250),
        DURATION("Duration", 4, 100);

        private final String name;
        private final int columnIndex;
        private final int columnWidth;

        private SpacecraftsVisibilitySetColumns(String name, int columnIndex, int columnWidth) {
            this.name = name;
            this.columnIndex = columnIndex;
            this.columnWidth = columnWidth;
        }

        public String getName() {
            return this.name;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public int getColumnWidth() {
            return this.columnWidth;
        }
    }
}

