/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.ui.composites;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.experimental.chart.swt.ChartComposite;

public class VisibilityPassSpacecraftPositionHistoryAzElComposite
extends Composite {
    private VisibilityPassSpacecraftPositionHistory positionHistory = null;
    private JFreeChart chart;
    private XYSeriesCollection xySeriesCollection = null;
    private XYSeries currentDataSeries = null;

    public VisibilityPassSpacecraftPositionHistoryAzElComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        new ChartComposite((Composite)this, 0, this.getChart(), true);
    }

    public VisibilityPassSpacecraftPositionHistory getPositionHistory() {
        return this.positionHistory;
    }

    public void setPositionHistory(VisibilityPassSpacecraftPositionHistory positionHistory) {
        this.getCurrentDataSeries().clear();
        this.positionHistory = positionHistory;
        if (positionHistory != null) {
            this.populateDataSeries(this.getCurrentDataSeries(), positionHistory);
        }
    }

    protected JFreeChart getChart() {
        if (this.chart == null) {
            this.chart = ChartFactory.createPolarChart((String)"Elevation vs Azimuth", (XYDataset)this.getXYSeriesCollection(), (boolean)false, (boolean)false, (boolean)false);
            PolarPlot plot = (PolarPlot)this.chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.white);
            plot.setAngleGridlinePaint((Paint)Color.black);
            plot.setAngleLabelPaint((Paint)Color.black);
            plot.setRadiusGridlinePaint((Paint)Color.black);
            plot.setRadiusGridlinesVisible(true);
            plot.setNoDataMessage("No Data.");
            plot.getAxis().setAutoRange(false);
            plot.getAxis().setInverted(true);
            plot.getAxis().setRange(new Range(0.0, 90.0));
            plot.getAxis().setAxisLineStroke((Stroke)new BasicStroke(2.0f));
            plot.getAxis().setAxisLinePaint((Paint)Color.black);
            DefaultPolarItemRenderer defaultPolarItemRenderer = new DefaultPolarItemRenderer(){
                private static final long serialVersionUID = 3822995919130258873L;

                public void drawSeries(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, PolarPlot plot, XYDataset dataset, int seriesIndex) {
                    g2.setPaint(this.lookupSeriesPaint(seriesIndex));
                    g2.setStroke(this.lookupSeriesStroke(seriesIndex));
                    GeneralPath polyline = new GeneralPath();
                    int numPoints = dataset.getItemCount(seriesIndex);
                    Point point = null;
                    Point previousPoint = null;
                    int i = 0;
                    while (i < numPoints - 1) {
                        double theta = dataset.getXValue(seriesIndex, i);
                        double radius = dataset.getYValue(seriesIndex, i);
                        point = plot.translateValueThetaRadiusToJava2D(theta, radius, dataArea);
                        if (i == 0) {
                            polyline.moveTo(point.x, point.y);
                        } else {
                            polyline.lineTo(point.x, point.y);
                        }
                        if (i + 1 < numPoints - 1) {
                            previousPoint = point;
                        }
                        ++i;
                    }
                    g2.draw(polyline);
                    if (point != null) {
                        double deltaX = point.x - previousPoint.x;
                        double deltaY = point.y - previousPoint.y;
                        double theta = VisibilityPassSpacecraftPositionHistoryAzElComposite.this.getRotationAngle(deltaX, deltaY);
                        g2.translate(point.x, point.y);
                        g2.rotate(theta);
                        int[] nArray = new int[3];
                        nArray[1] = -20;
                        nArray[2] = -20;
                        int[] x1Points = nArray;
                        int[] nArray2 = new int[3];
                        nArray2[1] = 5;
                        nArray2[2] = -5;
                        int[] y1Points = nArray2;
                        Polygon polygon = new Polygon(x1Points, y1Points, x1Points.length);
                        g2.draw(polygon);
                        g2.fillPolygon(polygon);
                        g2.rotate(-theta);
                        g2.translate(-point.x, -point.y);
                    }
                }
            };
            plot.setRenderer((PolarItemRenderer)defaultPolarItemRenderer);
        }
        return this.chart;
    }

    private double getRotationAngle(double deltaX, double deltaY) {
        double theta = 0.0;
        theta = deltaX > 0.0 ? (deltaY > 0.0 ? Math.atan(Math.abs(deltaY) / Math.abs(deltaX)) : -1.0 * Math.atan(Math.abs(deltaY) / Math.abs(deltaX))) : (deltaY > 0.0 ? Math.PI - Math.atan(Math.abs(deltaY) / Math.abs(deltaX)) : Math.atan(Math.abs(deltaY) / Math.abs(deltaX)) - Math.PI);
        return theta;
    }

    protected XYSeriesCollection getXYSeriesCollection() {
        if (this.xySeriesCollection == null) {
            this.xySeriesCollection = new XYSeriesCollection();
            this.xySeriesCollection.addSeries(this.getCurrentDataSeries());
        }
        return this.xySeriesCollection;
    }

    protected XYSeries getCurrentDataSeries() {
        if (this.currentDataSeries == null) {
            this.currentDataSeries = new XYSeries((Comparable)((Object)"Pass"), false);
            if (this.getPositionHistory() != null) {
                this.populateDataSeries(this.currentDataSeries, this.getPositionHistory());
            }
        }
        return this.currentDataSeries;
    }

    protected void populateDataSeries(XYSeries xySeries, VisibilityPassSpacecraftPositionHistory positionHistory) {
        for (VisibilityPassSpacecraftPosition position : positionHistory.getPositions()) {
            double azimuth = Math.toDegrees(position.getAzimuth());
            double elevation = 90.0 - Math.toDegrees(position.getElevation());
            xySeries.add(azimuth, elevation);
        }
    }
}

