/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.ui.impl;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.AnnotationAttributes;
import gov.nasa.worldwind.render.BasicShapeAttributes;
import gov.nasa.worldwind.render.GlobeAnnotation;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Renderable;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.render.SurfaceCircle;
import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import org.eclipse.apogy.common.emf.Timed;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.ApogyCorePackage;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.ui.impl.AbstractSpacecraftLocationWorldWindLayerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSpacecraftLocationWorldWindLayerCustomImpl
extends AbstractSpacecraftLocationWorldWindLayerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractSpacecraftLocationWorldWindLayerImpl.class);
    public static final String DEGREE_STRING = "\u00b0";
    private Adapter timedAdapter = null;

    @Override
    public void setTimeSource(Timed newTimeSource) {
        if (this.timeSource != null) {
            this.timeSource.eAdapters().remove((Object)this.getTimedAdapter());
        }
        super.setTimeSource(newTimeSource);
        if (newTimeSource != null) {
            if (this.isAutoUpdateEnabled()) {
                try {
                    this.update();
                }
                catch (Exception e) {
                    Logger.error(e.getMessage(), (Throwable)e);
                }
            }
            newTimeSource.eAdapters().add((Object)this.getTimedAdapter());
        }
    }

    @Override
    public void setShowGroundProjection(boolean newShowGroundProjection) {
        super.setShowGroundProjection(newShowGroundProjection);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void setShowLatLon(boolean newShowLatLon) {
        super.setShowLatLon(newShowLatLon);
        if (this.isAutoUpdateEnabled()) {
            try {
                this.update();
            }
            catch (Exception e) {
                Logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void setName(String newName) {
        super.setName(newName);
        this.updateRenderableLayer();
    }

    public void dispose() {
        if (this.getTimeSource() != null) {
            this.getTimeSource().eAdapters().remove((Object)this.getTimedAdapter());
        }
        super.dispose();
    }

    protected void updateRenderableLayer() {
        if (!this.isUpdating()) {
            ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)true);
            final RenderableLayer layer = this.getRenderableLayer();
            layer.removeAllRenderables();
            Job job = new Job("AbstractSpacecraftLocationWorldWindLayer updateRenderableLayer"){

                protected IStatus run(IProgressMonitor monitor) {
                    if (AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.isVisible() && !AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.isDisposed() && AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.getOrbitModel() != null && AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.getTimeSource() != null) {
                        try {
                            SpacecraftState ss = AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.getOrbitModel().propagate(AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.getTimeSource().getTime());
                            GeographicCoordinates coord = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.convertToGeographicCoordinates((OreKitBackedSpacecraftState)ss);
                            Angle latitude = Angle.fromRadiansLatitude((double)coord.getLatitude());
                            Angle longitude = Angle.fromRadiansLongitude((double)coord.getLongitude());
                            double elevation = coord.getElevation();
                            if (AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.isShowGroundProjection()) {
                                elevation = 0.0;
                            }
                            Position position = new Position(latitude, longitude, elevation);
                            String text = AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.getDisplayedText(ss, coord);
                            GlobeAnnotation annotation = new GlobeAnnotation(text, position);
                            AnnotationAttributes annotationAttributes = new AnnotationAttributes();
                            annotationAttributes.setVisible(true);
                            Font font = annotationAttributes.getFont();
                            font = font.deriveFont(1, 16.0f);
                            annotationAttributes.setFont(font);
                            Color transparent = new Color(0.0f, 0.0f, 1.0f, 0.3f);
                            annotationAttributes.setBackgroundColor(transparent);
                            annotationAttributes.setTextColor(Color.RED);
                            annotation.setAttributes(annotationAttributes);
                            layer.addRenderable((Renderable)annotation);
                            if (AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.isShowGroundProjection()) {
                                BasicShapeAttributes attributes = new BasicShapeAttributes();
                                attributes.setDrawInterior(true);
                                Material mat = new Material(Color.RED);
                                attributes.setInteriorMaterial(mat);
                                SurfaceCircle surfaceCircle = new SurfaceCircle((ShapeAttributes)attributes, (LatLon)position, 50000.0, 24);
                                surfaceCircle.setVisible(true);
                                layer.addRenderable((Renderable)surfaceCircle);
                            }
                        }
                        catch (Exception e) {
                            Logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.getRenderableLayer().firePropertyChange("gov.nasa.worldwind.avkey.LayerObject", null, (Object)this);
                    ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)AbstractSpacecraftLocationWorldWindLayerCustomImpl.this, (EStructuralFeature)ApogyCorePackage.Literals.UPDATABLE__UPDATING, (Object)false, true);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    protected String getDisplayedText(SpacecraftState ss, GeographicCoordinates coord) {
        String text = this.getName();
        if (this.isShowLatLon()) {
            DecimalFormat latLongDecimalFormat = new DecimalFormat("0.000");
            double lat = Math.toDegrees(coord.getLatitude());
            double lon = Math.toDegrees(coord.getLongitude());
            DecimalFormat altitudeDecimalFormat = new DecimalFormat("0.0");
            double altitude = coord.getElevation() * 0.001;
            text = String.valueOf(text) + "\n lat " + latLongDecimalFormat.format(lat) + DEGREE_STRING + ", lon " + latLongDecimalFormat.format(lon) + DEGREE_STRING + ", alt " + altitudeDecimalFormat.format(altitude) + " km";
        }
        return text;
    }

    protected Adapter getTimedAdapter() {
        if (this.timedAdapter == null) {
            this.timedAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Timed) {
                        int featureId = msg.getFeatureID(Timed.class);
                        switch (featureId) {
                            case 0: {
                                if (!AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.isAutoUpdateEnabled()) break;
                                try {
                                    AbstractSpacecraftLocationWorldWindLayerCustomImpl.this.update();
                                }
                                catch (Exception e) {
                                    Logger.error(e.getMessage(), (Throwable)e);
                                }
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.timedAdapter;
    }
}

