/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth;

import java.util.Date;
import java.util.List;
import java.util.SortedSet;
import org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.orbit.Orbit;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.TimedStampedAngularCoordinates;
import org.eclipse.apogy.core.environment.orbit.TimedStampedPVACoordinates;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFactory;
import org.eclipse.apogy.core.environment.orbit.earth.CartesianEarthOrbit;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitPropagator;
import org.eclipse.apogy.core.environment.orbit.earth.Eclipse;
import org.eclipse.apogy.core.environment.orbit.earth.ElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.GroundStation;
import org.eclipse.apogy.core.environment.orbit.earth.KeplerianEarthOrbit;
import org.eclipse.apogy.core.environment.orbit.earth.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.TLE;
import org.eclipse.apogy.core.environment.orbit.earth.TLEEarthOrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPositionHistory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.Propagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.TimeStampedAngularCoordinates;
import org.orekit.utils.TimeStampedPVCoordinates;

public interface ApogyCoreEnvironmentOrbitEarthFacade
extends EObject {
    public static final ApogyCoreEnvironmentOrbitEarthFacade INSTANCE = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createApogyCoreEnvironmentOrbitEarthFacade();

    public double getMu();

    public AbsoluteDate createAbsoluteDate(Date var1);

    public Date createDate(AbsoluteDate var1);

    public GeographicCoordinates getSpacecraftEarthSubPoint(OreKitBackedSpacecraftState var1) throws Exception;

    public double getSpacecraftElevationAngle(SpacecraftState var1, EarthSurfaceLocation var2) throws Exception;

    public double getSpacecraftAzimuthAngle(SpacecraftState var1, EarthSurfaceLocation var2) throws Exception;

    public double getRange(SpacecraftState var1, EarthSurfaceLocation var2) throws Exception;

    public SpacecraftState createSpacecraftState(Orbit var1, org.orekit.propagation.SpacecraftState var2);

    public OreKitBackedSpacecraftState createOreKitBackedSpacecraftState(Orbit var1, org.orekit.propagation.SpacecraftState var2);

    public TimedStampedPVACoordinates createTimedStampedPVACoordinates(TimeStampedPVCoordinates var1);

    public TimedStampedAngularCoordinates createTimedStampedAngularCoordinates(TimeStampedAngularCoordinates var1);

    public Matrix3x3 createMatrix3x3(Rotation var1);

    public Rotation createRotation(Matrix3x3 var1);

    public KeplerianEarthOrbit createKeplerianOrbit(EarthOrbitPropagator var1) throws Exception;

    public CartesianEarthOrbit createCartesianEarthOrbit(EarthOrbitPropagator var1) throws Exception;

    public KeplerianEarthOrbit createKeplerianOrbit(KeplerianOrbit var1) throws Exception;

    public CartesianEarthOrbit createCartesianEarthOrbit(CartesianOrbit var1) throws Exception;

    public GeographicCoordinates convertToGeographicCoordinates(OreKitBackedSpacecraftState var1) throws Exception;

    public List<SpacecraftState> getSpacecraftStates(Propagator var1, Date var2, Date var3, double var4) throws Exception;

    public List<VisibilityPass> getTargetPasses(EarthOrbitModel var1, EarthSurfaceLocation var2, Date var3, Date var4, ElevationMask var5) throws Exception;

    public List<VisibilityPass> getTargetPasses(EarthOrbitModel var1, List<EarthSurfaceLocation> var2, Date var3, Date var4, ElevationMask var5, IProgressMonitor var6) throws Exception;

    public List<VisibilityPass> getGroundStationPasses(EarthOrbitModel var1, GroundStation var2, Date var3, Date var4) throws Exception;

    public List<VisibilityPass> getGroundStationPasses(EarthOrbitModel var1, List<GroundStation> var2, Date var3, Date var4, IProgressMonitor var5) throws Exception;

    public List<Eclipse> getEclipses(EarthOrbitModel var1, Date var2, Date var3) throws Exception;

    public SortedSet<VisibilityPass> getVisibilityPassSortedByStartDate(List<VisibilityPass> var1);

    public SortedSet<VisibilityPass> getVisibilityPassSortedByDuration(List<VisibilityPass> var1);

    public SortedSet<VisibilityPassSpacecraftPosition> getVisibilityPassSpacecraftPositionSortedByElevation(List<VisibilityPassSpacecraftPosition> var1);

    public SortedSet<VisibilityPassSpacecraftPosition> getVisibilityPassSpacecraftPositionSortedBySpacecraftCrossTrackAngle(List<VisibilityPassSpacecraftPosition> var1);

    public TLE loadTLE(String var1) throws Exception;

    public void exportTLE(TLE var1, String var2) throws Exception;

    public TLEEarthOrbitModel createTLEEarthOrbitModel(TLE var1) throws Exception;

    public String exportAsCSV(VisibilityPassSpacecraftPositionHistory var1, boolean var2);
}

