/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EclipseEventType implements Enumerator
{
    PENUMBRA_ENTRY(0, "PENUMBRA_ENTRY", "Penumbra Entry"),
    PENUMBRA_EXIT(1, "PENUMBRA_EXIT", "Penumbra Exit"),
    UMBRA_ENTRY(2, "UMBRA_ENTRY", "Umbra Entry"),
    UMBRA_EXIT(3, "UMBRA_EXIT", "Umbra Exit");

    public static final int PENUMBRA_ENTRY_VALUE = 0;
    public static final int PENUMBRA_EXIT_VALUE = 1;
    public static final int UMBRA_ENTRY_VALUE = 2;
    public static final int UMBRA_EXIT_VALUE = 3;
    private static final EclipseEventType[] VALUES_ARRAY;
    public static final List<EclipseEventType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new EclipseEventType[]{PENUMBRA_ENTRY, PENUMBRA_EXIT, UMBRA_ENTRY, UMBRA_EXIT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static EclipseEventType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EclipseEventType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EclipseEventType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            EclipseEventType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static EclipseEventType get(int value) {
        switch (value) {
            case 0: {
                return PENUMBRA_ENTRY;
            }
            case 1: {
                return PENUMBRA_EXIT;
            }
            case 2: {
                return UMBRA_ENTRY;
            }
            case 3: {
                return UMBRA_EXIT;
            }
        }
        return null;
    }

    private EclipseEventType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

