/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.orbit.Orbit;
import org.eclipse.apogy.core.environment.orbit.SpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFactory;
import org.eclipse.apogy.core.environment.orbit.earth.ConstantElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbit;
import org.eclipse.apogy.core.environment.orbit.earth.Eclipse;
import org.eclipse.apogy.core.environment.orbit.earth.EclipseEvent;
import org.eclipse.apogy.core.environment.orbit.earth.EclipseEventType;
import org.eclipse.apogy.core.environment.orbit.earth.ElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.GroundStation;
import org.eclipse.apogy.core.environment.orbit.earth.OreKitBackedSpacecraftState;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.core.environment.orbit.earth.impl.EarthOrbitPropagatorImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.CelestialBody;
import org.orekit.bodies.CelestialBodyFactory;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.PropagationException;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.TopocentricFrame;
import org.orekit.orbits.CartesianOrbit;
import org.orekit.orbits.KeplerianOrbit;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.events.EclipseDetector;
import org.orekit.propagation.events.ElevationDetector;
import org.orekit.propagation.events.EventDetector;
import org.orekit.propagation.events.handlers.EventHandler;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinatesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EarthOrbitPropagatorCustomImpl
extends EarthOrbitPropagatorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(EarthOrbitPropagatorImpl.class);

    @Override
    public abstract Propagator getOreKitPropagator();

    @Override
    public List<SpacecraftState> getSpacecraftStates(final Date startDate, final Date endDate, double timeInterval) throws Exception {
        if (!this.getInitialOrbitBasedEarthOrbitModel().isDateInValidRange(startDate)) {
            String message = "Start date is outside the validity range.";
            Logger.error(message);
            throw new Exception(message);
        }
        if (!this.getInitialOrbitBasedEarthOrbitModel().isDateInValidRange(endDate)) {
            String message = "End date is outside the validity range.";
            Logger.error(message);
            throw new Exception(message);
        }
        Propagator propagator = this.getOreKitPropagator();
        double duration = (double)(endDate.getTime() - startDate.getTime()) * 0.001;
        final ArrayList<SpacecraftState> states = new ArrayList<SpacecraftState>();
        propagator.setMasterMode(timeInterval, new OrekitFixedStepHandler(){

            public void init(org.orekit.propagation.SpacecraftState spacecraftState, AbsoluteDate arg1) throws PropagationException {
            }

            public void handleStep(org.orekit.propagation.SpacecraftState spacecraftState, boolean arg1) throws PropagationException {
                try {
                    Date date = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(spacecraftState.getDate());
                    if (date.getTime() >= startDate.getTime() && endDate.getTime() >= date.getTime()) {
                        EarthOrbit orbit = null;
                        if (spacecraftState.getOrbit() instanceof KeplerianOrbit) {
                            orbit = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createKeplerianOrbit((KeplerianOrbit)spacecraftState.getOrbit());
                        } else if (spacecraftState.getOrbit() instanceof CartesianOrbit) {
                            orbit = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createCartesianEarthOrbit((CartesianOrbit)spacecraftState.getOrbit());
                        }
                        OreKitBackedSpacecraftState ss = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createOreKitBackedSpacecraftState(orbit, spacecraftState);
                        states.add(ss);
                    }
                }
                catch (PropagationException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new PropagationException((Throwable)e, null, new Object[]{this});
                }
            }
        });
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        try {
            propagator.propagate(new AbsoluteDate(startAbsoluteDate, duration));
            SpacecraftState startState = this.propagate(startDate);
            states.add(0, startState);
            SpacecraftState endState = this.propagate(endDate);
            states.add(endState);
        }
        catch (PropagationException e) {
            Logger.error("Error occured during execution.", (Throwable)e);
            throw e;
        }
        return states;
    }

    @Override
    public List<VisibilityPass> getTargetPasses(final EarthSurfaceLocation earthSurfaceLocation, Date startDate, Date endDate, ElevationMask elevationMask) throws Exception {
        final ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
        GeodeticPoint target = new GeodeticPoint(earthSurfaceLocation.getLatitude(), earthSurfaceLocation.getLongitude(), earthSurfaceLocation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        String name = "?";
        if (earthSurfaceLocation.getName() != null) {
            name = earthSurfaceLocation.getName();
        }
        TopocentricFrame targetFrame = new TopocentricFrame((BodyShape)earth, target, name);
        EventHandler<ElevationDetector> eventHandler = new EventHandler<ElevationDetector>(){
            VisibilityPass lastPass = null;

            public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState s, ElevationDetector detector, boolean increasing) throws OrekitException {
                if (increasing) {
                    if (this.lastPass == null) {
                        this.lastPass = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createVisibilityPass();
                        this.lastPass.setStartTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                        this.lastPass.setSurfaceLocation(earthSurfaceLocation);
                        this.lastPass.setOrbitModel(EarthOrbitPropagatorCustomImpl.this.getInitialOrbitBasedEarthOrbitModel());
                    }
                } else if (this.lastPass != null) {
                    this.lastPass.setEndTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                    passes.add(this.lastPass);
                    this.lastPass.getPositionHistory().updateHistory();
                    this.lastPass = null;
                }
                return EventHandler.Action.CONTINUE;
            }

            public org.orekit.propagation.SpacecraftState resetState(ElevationDetector detector, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
                return oldState;
            }
        };
        double convergenceThreshold = 0.001;
        ElevationDetector detector = null;
        if (elevationMask instanceof ConstantElevationMask) {
            double elevation = ((ConstantElevationMask)elevationMask).getConstantElevation();
            detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withConstantElevation(elevation).withHandler((EventHandler)eventHandler);
        } else {
            detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withElevationMask(elevationMask.getOreKitElevationMask()).withHandler((EventHandler)eventHandler);
        }
        Propagator propagator = this.getOreKitPropagator();
        propagator.setSlaveMode();
        propagator.addEventDetector((EventDetector)detector);
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        return passes;
    }

    @Override
    public List<VisibilityPass> getGroundStationPasses(final GroundStation groundStation, Date startDate, Date endDate) throws Exception {
        final ArrayList<VisibilityPass> passes = new ArrayList<VisibilityPass>();
        GeodeticPoint target = new GeodeticPoint(groundStation.getLatitude(), groundStation.getLongitude(), groundStation.getElevation());
        FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
        OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
        String name = "?";
        if (groundStation.getName() != null) {
            name = groundStation.getName();
        }
        TopocentricFrame targetFrame = new TopocentricFrame((BodyShape)earth, target, name);
        EventHandler<ElevationDetector> eventHandler = new EventHandler<ElevationDetector>(){
            VisibilityPass lastPass = null;

            public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState s, ElevationDetector detector, boolean increasing) throws OrekitException {
                if (increasing) {
                    if (this.lastPass == null) {
                        this.lastPass = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createVisibilityPass();
                        this.lastPass.setSurfaceLocation(groundStation);
                        this.lastPass.setStartTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                        this.lastPass.setOrbitModel(EarthOrbitPropagatorCustomImpl.this.getInitialOrbitBasedEarthOrbitModel());
                    }
                } else if (this.lastPass != null) {
                    this.lastPass.setEndTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(s.getDate()));
                    passes.add(this.lastPass);
                    this.lastPass.getPositionHistory().updateHistory();
                    this.lastPass = null;
                }
                return EventHandler.Action.CONTINUE;
            }

            public org.orekit.propagation.SpacecraftState resetState(ElevationDetector detector, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
                return oldState;
            }
        };
        double convergenceThreshold = 0.001;
        ElevationDetector detector = null;
        if (groundStation.getElevationMask() instanceof ConstantElevationMask) {
            double elevation = ((ConstantElevationMask)groundStation.getElevationMask()).getConstantElevation();
            detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withConstantElevation(elevation).withHandler((EventHandler)eventHandler);
        } else {
            detector = (ElevationDetector)new ElevationDetector(1.0, convergenceThreshold, targetFrame).withElevationMask(groundStation.getElevationMask().getOreKitElevationMask()).withHandler((EventHandler)eventHandler);
        }
        Propagator propagator = this.getOreKitPropagator();
        propagator.setSlaveMode();
        propagator.addEventDetector((EventDetector)detector);
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        return passes;
    }

    @Override
    public List<Eclipse> getEclipses(Date startDate, Date endDate) throws Exception {
        final ArrayList<Eclipse> eclipses = new ArrayList<Eclipse>();
        final ArrayList eclipseEvents = new ArrayList();
        CelestialBody earth = CelestialBodyFactory.getEarth();
        CelestialBody sun = CelestialBodyFactory.getSun();
        EventHandler<EclipseDetector> eventHandler = new EventHandler<EclipseDetector>(){
            Eclipse latestEclipse = null;

            public EventHandler.Action eventOccurred(org.orekit.propagation.SpacecraftState ss, EclipseDetector eclipseDetector, boolean increasing) throws OrekitException {
                if (this.latestEclipse == null) {
                    this.latestEclipse = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipse();
                    eclipses.add(this.latestEclipse);
                }
                if (eclipseDetector.getTotalEclipse()) {
                    if (increasing) {
                        EclipseEvent umbraExit = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipseEvent();
                        umbraExit.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(ss.getDate()));
                        umbraExit.setType(EclipseEventType.UMBRA_EXIT);
                        this.setGeographicCoordinates(umbraExit, ss);
                        this.latestEclipse.setUmbraExit(umbraExit);
                        eclipseEvents.add(umbraExit);
                    } else {
                        EclipseEvent umbraEntry = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipseEvent();
                        umbraEntry.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(ss.getDate()));
                        umbraEntry.setType(EclipseEventType.UMBRA_ENTRY);
                        this.setGeographicCoordinates(umbraEntry, ss);
                        this.latestEclipse.setUmbraEntry(umbraEntry);
                        eclipseEvents.add(umbraEntry);
                    }
                } else if (increasing) {
                    EclipseEvent penumbraExit = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipseEvent();
                    penumbraExit.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(ss.getDate()));
                    penumbraExit.setType(EclipseEventType.PENUMBRA_EXIT);
                    this.setGeographicCoordinates(penumbraExit, ss);
                    this.latestEclipse.setPenumbraExit(penumbraExit);
                    this.latestEclipse = null;
                    eclipseEvents.add(penumbraExit);
                } else {
                    EclipseEvent penumbraEntry = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createEclipseEvent();
                    penumbraEntry.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(ss.getDate()));
                    penumbraEntry.setType(EclipseEventType.PENUMBRA_ENTRY);
                    this.setGeographicCoordinates(penumbraEntry, ss);
                    this.latestEclipse.setPenumbraEntry(penumbraEntry);
                    eclipseEvents.add(penumbraEntry);
                }
                return EventHandler.Action.CONTINUE;
            }

            public org.orekit.propagation.SpacecraftState resetState(EclipseDetector arg0, org.orekit.propagation.SpacecraftState oldState) throws OrekitException {
                return oldState;
            }

            private void setGeographicCoordinates(EclipseEvent eclipseEvent, org.orekit.propagation.SpacecraftState ss) {
                try {
                    OreKitBackedSpacecraftState oreKitBackedSpacecraftState = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createOreKitBackedSpacecraftState();
                    oreKitBackedSpacecraftState.setOreKitSpacecraftState(ss);
                    GeographicCoordinates geographicCoordinates = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.convertToGeographicCoordinates(oreKitBackedSpacecraftState);
                    eclipseEvent.setElevation(geographicCoordinates.getElevation());
                    eclipseEvent.setLatitude(geographicCoordinates.getLatitude());
                    eclipseEvent.setLongitude(geographicCoordinates.getLongitude());
                }
                catch (Throwable t) {
                    Logger.error(t.getMessage(), t);
                }
            }
        };
        EclipseDetector umbraDetector = (EclipseDetector)new EclipseDetector((PVCoordinatesProvider)sun, 6.96E8, (PVCoordinatesProvider)earth, 6378137.0).withUmbra().withHandler((EventHandler)eventHandler);
        EclipseDetector penumbraDetector = (EclipseDetector)new EclipseDetector((PVCoordinatesProvider)sun, 6.96E8, (PVCoordinatesProvider)earth, 6378137.0).withPenumbra().withHandler((EventHandler)eventHandler);
        Propagator propagator = this.getOreKitPropagator();
        propagator.setSlaveMode();
        propagator.addEventDetector((EventDetector)umbraDetector);
        propagator.addEventDetector((EventDetector)penumbraDetector);
        AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(startDate);
        AbsoluteDate endAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(endDate);
        propagator.propagate(startAbsoluteDate, endAbsoluteDate);
        SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        for (EclipseEvent event : eclipseEvents) {
            Logger.debug(String.valueOf(event.getType().getName()) + "," + dateFormat.format(event.getTime()) + ", ");
            Logger.debug(String.valueOf(event.getElevation()) + " m , ");
            Logger.debug(String.valueOf(Math.toDegrees(event.getLatitude())) + " lat , ");
            Logger.debug(String.valueOf(Math.toDegrees(event.getLongitude())) + " lon");
        }
        return eclipses;
    }

    @Override
    public Date getToValidDate() {
        return this.getValidToDate();
    }

    @Override
    public SpacecraftState propagate(Date targetDate) throws Exception {
        if (this.getInitialOrbitBasedEarthOrbitModel().isDateInValidRange(targetDate)) {
            Propagator propagator = this.getOreKitPropagator();
            AbsoluteDate targetAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(targetDate);
            propagator.setSlaveMode();
            org.orekit.propagation.SpacecraftState ss = propagator.propagate(targetAbsoluteDate);
            Orbit orbitCopy = (Orbit)EcoreUtil.copy((EObject)this.getInitialOrbit());
            return ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createSpacecraftState(orbitCopy, ss);
        }
        String message = "Target date is outside the validity range.";
        Logger.error(message);
        throw new Exception(message);
    }
}

