/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Line;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.eclipse.apogy.core.environment.earth.ApogyEarthFacade;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFactory;
import org.eclipse.apogy.core.environment.orbit.earth.Corridor;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.impl.SpacecraftSwathCorridorImpl;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.errors.OrekitException;
import org.orekit.errors.PropagationException;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.Transform;
import org.orekit.propagation.Propagator;
import org.orekit.propagation.SpacecraftState;
import org.orekit.propagation.sampling.OrekitFixedStepHandler;
import org.orekit.time.AbsoluteDate;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.TimeStampedPVCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacecraftSwathCorridorCustomImpl
extends SpacecraftSwathCorridorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SpacecraftSwathCorridorImpl.class);
    protected static final Date START_TIME_EDEFAULT = null;

    @Override
    public boolean getDefaultAutoUpdateEnabled() {
        return false;
    }

    @Override
    public void update() {
        try {
            EarthOrbitModel earthOrbitModel = (EarthOrbitModel)this.getOrbitModel();
            Propagator propagator = earthOrbitModel.getOreKitPropagator();
            Corridor corridor = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createCorridor();
            if (!earthOrbitModel.isDateInValidRange(this.getStartTime())) {
                String message = "Start date is outside the validity range !";
                Logger.error("Start date is outside the validity range !");
                throw new Exception(message);
            }
            if (!earthOrbitModel.isDateInValidRange(this.getEndTime())) {
                String message = "End date is outside the validity range !";
                Logger.error(message);
                throw new Exception(message);
            }
            double duration = (double)(this.getEndTime().getTime() - this.getStartTime().getTime()) * 0.001;
            CorridorHandler corridorHandler = new CorridorHandler(this.getStartTime(), this.getEndTime(), this.leftSwathAngle, this.rightSwathAngle);
            propagator.setMasterMode(this.getTimeInterval(), (OrekitFixedStepHandler)corridorHandler);
            AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(this.getStartTime());
            try {
                propagator.propagate(new AbsoluteDate(startAbsoluteDate, duration));
                for (CorridorPoint point : corridorHandler.getCorridor()) {
                    AbsoluteDate absoluteDate = point.getDate();
                    Date date = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(absoluteDate);
                    GeodeticPoint left = point.getLeft();
                    GeographicCoordinates leftCoord = ApogyEarthFacade.INSTANCE.createGeographicCoordinates(left.getLongitude(), left.getLatitude(), left.getAltitude());
                    GeodeticPoint center = point.getCenter();
                    GeographicCoordinates centerCoord = ApogyEarthFacade.INSTANCE.createGeographicCoordinates(center.getLongitude(), center.getLatitude(), center.getAltitude());
                    GeodeticPoint right = point.getRight();
                    GeographicCoordinates rightCoord = ApogyEarthFacade.INSTANCE.createGeographicCoordinates(right.getLongitude(), right.getLatitude(), right.getAltitude());
                    org.eclipse.apogy.core.environment.orbit.earth.CorridorPoint newPoint = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createCorridorPoint();
                    newPoint.setTime(date);
                    newPoint.setLeft(leftCoord);
                    newPoint.setCenter(centerCoord);
                    newPoint.setRight(rightCoord);
                    corridor.getPoints().add((Object)newPoint);
                }
                this.setCorridor(corridor);
            }
            catch (PropagationException e1) {
                Logger.error("Error occured during execution.", (Throwable)e1);
                throw e1;
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private static class CorridorHandler
    implements OrekitFixedStepHandler {
        private final Date startDate;
        private final Date endDate;
        private double leftSwathAngle = 0.0;
        private double rightSwathAngle = 0.0;
        private final BodyShape earth;
        private final List<CorridorPoint> corridor;

        public CorridorHandler(Date startDate, Date endDate, double leftSwathAngle, double rightSwathAngle) throws OrekitException {
            this.startDate = startDate;
            this.endDate = endDate;
            this.leftSwathAngle = leftSwathAngle;
            this.rightSwathAngle = rightSwathAngle;
            this.earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)false));
            this.corridor = new ArrayList<CorridorPoint>();
        }

        public void init(SpacecraftState arg0, AbsoluteDate absoluteDate) throws PropagationException {
        }

        public void handleStep(SpacecraftState currentState, boolean isLast) throws PropagationException {
            try {
                Date currentDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(currentState.getDate());
                if (currentDate.getTime() >= this.startDate.getTime() && this.endDate.getTime() >= currentDate.getTime()) {
                    AbsoluteDate date = currentState.getDate();
                    TimeStampedPVCoordinates pvInert = currentState.getPVCoordinates();
                    Transform t = currentState.getFrame().getTransformTo(this.earth.getBodyFrame(), date);
                    Vector3D p = t.transformPosition(pvInert.getPosition());
                    Vector3D v = t.transformVector(pvInert.getVelocity());
                    Vector3D nadir = p.normalize().negate();
                    Line centerLine = new Line(p, new Vector3D(0.0, 0.0, 0.0));
                    GeodeticPoint centerPoint = this.earth.getIntersectionPoint(centerLine, p, this.earth.getBodyFrame(), date);
                    Vector3D crossTrack = p.crossProduct((Vector)v).normalize();
                    double r = p.getNorm();
                    double deltaR = Math.cos(this.leftSwathAngle) * r;
                    double deltaC = Math.sin(this.leftSwathAngle) * r;
                    Line leftLine = new Line(p, new Vector3D(1.0, p, deltaR, nadir, deltaC, crossTrack));
                    GeodeticPoint left = this.earth.getIntersectionPoint(leftLine, p, this.earth.getBodyFrame(), date);
                    deltaR = Math.cos(this.rightSwathAngle) * r;
                    deltaC = Math.sin(this.rightSwathAngle) * r;
                    Line rightLine = new Line(p, new Vector3D(1.0, p, deltaR, nadir, -deltaC, crossTrack));
                    GeodeticPoint right = this.earth.getIntersectionPoint(rightLine, p, this.earth.getBodyFrame(), date);
                    this.corridor.add(new CorridorPoint(date, left, centerPoint, right));
                }
            }
            catch (OrekitException oe) {
                throw new PropagationException(oe);
            }
        }

        public List<CorridorPoint> getCorridor() {
            return this.corridor;
        }
    }

    private static class CorridorPoint {
        private final AbsoluteDate date;
        private final GeodeticPoint left;
        private final GeodeticPoint center;
        private final GeodeticPoint right;

        public CorridorPoint(AbsoluteDate date, GeodeticPoint left, GeodeticPoint center, GeodeticPoint right) {
            this.date = date;
            this.left = left;
            this.center = center;
            this.right = right;
        }

        public AbsoluteDate getDate() {
            return this.date;
        }

        public GeodeticPoint getLeft() {
            return this.left;
        }

        public GeodeticPoint getCenter() {
            return this.center;
        }

        public GeodeticPoint getRight() {
            return this.right;
        }
    }
}

