/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.eclipse.apogy.core.environment.orbit.OrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.GroundStation;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.core.environment.orbit.earth.impl.SpacecraftsVisibilitySetImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpacecraftsVisibilitySetCustomImpl
extends SpacecraftsVisibilitySetImpl {
    private static final Logger Logger = LoggerFactory.getLogger(SpacecraftsVisibilitySetImpl.class);
    protected boolean autoUpdateEnabled = this.getDefaultAutoUpdateEnabled();
    protected static final Date END_TIME_EDEFAULT = null;

    @Override
    public Date getStartTime() {
        Date tmp = super.getStartTime();
        if (tmp == null) {
            tmp = new Date();
            this.setStartTime(tmp);
        }
        return tmp;
    }

    @Override
    public void setStartTime(Date newStartTime) {
        super.setStartTime(newStartTime);
        if (this.isAutoUpdateEnabled()) {
            this.update();
        }
    }

    @Override
    public Date getEndTime() {
        Date tmp = super.getEndTime();
        if (tmp == null) {
            tmp = new Date(this.getStartTime().getTime() + 86400000L);
            this.setEndTime(tmp);
            if (this.isAutoUpdateEnabled()) {
                this.update();
            }
        }
        return tmp;
    }

    @Override
    public void setEndTime(Date newEndTime) {
        super.setEndTime(newEndTime);
        if (this.isAutoUpdateEnabled()) {
            this.update();
        }
    }

    @Override
    public boolean getDefaultAutoUpdateEnabled() {
        return false;
    }

    @Override
    public synchronized void update() {
        if (!this.isUpdating()) {
            this.setUpdating(true);
            Job job = new Job("SpacecraftsVisibilitySet update."){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        monitor.beginTask("SpacecraftsVisibilitySet update.", SpacecraftsVisibilitySetCustomImpl.this.getGroundStations().size());
                        ArrayList allPasses = new ArrayList();
                        HashMap<GroundStation, List<VisibilityPass>> map = new HashMap<GroundStation, List<VisibilityPass>>();
                        for (GroundStation groundStation : SpacecraftsVisibilitySetCustomImpl.this.getGroundStations()) {
                            Logger.info("Computing passes for GroundStation <" + groundStation.getName() + ">.");
                            ArrayList<VisibilityPass> groundStationPasses = new ArrayList<VisibilityPass>();
                            for (OrbitModel model : SpacecraftsVisibilitySetCustomImpl.this.getOrbitModels()) {
                                try {
                                    if (!(model instanceof EarthOrbitModel)) continue;
                                    EarthOrbitModel earthOrbitModel = (EarthOrbitModel)model;
                                    groundStationPasses.addAll(earthOrbitModel.getGroundStationPasses(groundStation, SpacecraftsVisibilitySetCustomImpl.this.getStartTime(), SpacecraftsVisibilitySetCustomImpl.this.getEndTime()));
                                }
                                catch (Throwable t) {
                                    Logger.error(t.getMessage(), t);
                                }
                            }
                            Logger.info("Found <" + groundStationPasses.size() + "> passes for GroundStation <" + groundStation.getName() + ">.");
                            allPasses.addAll(groundStationPasses);
                            map.put(groundStation, groundStationPasses);
                            monitor.worked(1);
                        }
                        SpacecraftsVisibilitySetCustomImpl.this.getPasses().clear();
                        SpacecraftsVisibilitySetCustomImpl.this.getPasses().addAll(allPasses);
                        SpacecraftsVisibilitySetCustomImpl.this.setGroundStationToVisibilityMap(map);
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                    SpacecraftsVisibilitySetCustomImpl.this.setUpdating(false);
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

