/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.TLE;
import org.eclipse.apogy.core.environment.orbit.earth.impl.URLBasedTLEEarthOrbitPropagatorImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLBasedTLEEarthOrbitPropagatorCustomImpl
extends URLBasedTLEEarthOrbitPropagatorImpl {
    private static final Logger Logger = LoggerFactory.getLogger(URLBasedTLEEarthOrbitPropagatorImpl.class);

    @Override
    public void setTleURL(String newTleURL) {
        super.setTleURL(newTleURL);
        this.updateTLE();
    }

    private void updateTLE() {
        try {
            TLE newTLE = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.loadTLE(this.getTleURL());
            this.setTle(newTLE);
            Logger.info("Sucessfully loaded Two-Lines Element from <" + this.getTleURL() + ">.");
        }
        catch (Throwable t) {
            Logger.error(ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(this.getClass()), new Object[]{this, "Failed to load Two-Lines Element from <" + this.getTleURL() + ">.", t});
        }
    }
}

