/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.orbit.earth.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.geometry.Vector;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.eclipse.apogy.core.environment.earth.ApogyEarthFacade;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.earth.GeographicCoordinates;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFactory;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPassSpacecraftPosition;
import org.eclipse.apogy.core.environment.orbit.earth.impl.VisibilityPassSpacecraftPositionHistoryImpl;
import org.orekit.bodies.BodyShape;
import org.orekit.bodies.GeodeticPoint;
import org.orekit.bodies.OneAxisEllipsoid;
import org.orekit.frames.FactoryManagedFrame;
import org.orekit.frames.Frame;
import org.orekit.frames.FramesFactory;
import org.orekit.frames.LOFType;
import org.orekit.frames.LocalOrbitalFrame;
import org.orekit.frames.TopocentricFrame;
import org.orekit.propagation.Propagator;
import org.orekit.time.AbsoluteDate;
import org.orekit.time.TimeScale;
import org.orekit.time.TimeScalesFactory;
import org.orekit.time.UTCScale;
import org.orekit.utils.IERSConventions;
import org.orekit.utils.PVCoordinates;
import org.orekit.utils.PVCoordinatesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VisibilityPassSpacecraftPositionHistoryCustomImpl
extends VisibilityPassSpacecraftPositionHistoryImpl {
    private static final Logger Logger = LoggerFactory.getLogger(VisibilityPassSpacecraftPositionHistoryImpl.class);

    @Override
    public VisibilityPassSpacecraftPosition getClosestRangePosition() {
        VisibilityPassSpacecraftPosition smallestRangePosition = null;
        if (!this.getPositions().isEmpty()) {
            double closestRange = Double.POSITIVE_INFINITY;
            for (VisibilityPassSpacecraftPosition p : this.getPositions()) {
                if (!(p.getRange() < closestRange)) continue;
                closestRange = p.getRange();
                smallestRangePosition = p;
            }
        }
        return smallestRangePosition;
    }

    @Override
    public VisibilityPassSpacecraftPosition getHighestElevationPosition() {
        VisibilityPassSpacecraftPosition higestElevationPosition = null;
        if (!this.getPositions().isEmpty()) {
            double highestElevation = Double.NEGATIVE_INFINITY;
            for (VisibilityPassSpacecraftPosition p : this.getPositions()) {
                if (!(p.getElevation() > highestElevation)) continue;
                highestElevation = p.getElevation();
                higestElevationPosition = p;
            }
        }
        return higestElevationPosition;
    }

    @Override
    public VisibilityPassSpacecraftPosition getSmallestSpacecraftCrossTrackAnglePosition() {
        VisibilityPassSpacecraftPosition smallestSpacecraftCrossTrackAnglePosition = null;
        if (!this.getPositions().isEmpty()) {
            double smallestCrossTrackAngle = Double.MAX_VALUE;
            for (VisibilityPassSpacecraftPosition p : this.getPositions()) {
                double crossTrackAngle = Math.abs(p.getSpacecraftCrossTrackAngle());
                if (!(crossTrackAngle < smallestCrossTrackAngle)) continue;
                smallestCrossTrackAngle = crossTrackAngle;
                smallestSpacecraftCrossTrackAnglePosition = p;
            }
        }
        return smallestSpacecraftCrossTrackAnglePosition;
    }

    @Override
    public void updateHistory() {
        this.getPositions().clear();
        List<VisibilityPassSpacecraftPosition> pos = this.getVisibilityPassPositionHistory(this.getVisibilityPass(), this.getTimeInterval());
        this.getPositions().addAll(pos);
    }

    protected List<VisibilityPassSpacecraftPosition> getVisibilityPassPositionHistory(VisibilityPass pass, double timeInterval) {
        ArrayList<VisibilityPassSpacecraftPosition> positions = new ArrayList<VisibilityPassSpacecraftPosition>();
        try {
            Propagator propagator = pass.getOrbitModel().getOreKitPropagator();
            FactoryManagedFrame inertialFrame = FramesFactory.getEME2000();
            LocalOrbitalFrame lof = new LocalOrbitalFrame((Frame)inertialFrame, LOFType.QSW, (PVCoordinatesProvider)propagator, "QSW");
            EarthSurfaceLocation coord = pass.getSurfaceLocation();
            GeodeticPoint location = new GeodeticPoint(coord.getLatitude(), coord.getLongitude(), coord.getElevation());
            FactoryManagedFrame earthFrame = FramesFactory.getITRF((IERSConventions)IERSConventions.IERS_2010, (boolean)true);
            OneAxisEllipsoid earth = new OneAxisEllipsoid(6378137.0, 0.0033528106647474805, (Frame)earthFrame);
            TopocentricFrame loc = new TopocentricFrame((BodyShape)earth, location, "location");
            UTCScale utc = TimeScalesFactory.getUTC();
            AbsoluteDate startAbsoluteDate = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createAbsoluteDate(pass.getStartTime());
            AbsoluteDate endAbsoluteDate = new AbsoluteDate(startAbsoluteDate, pass.getDuration());
            AbsoluteDate extrapDate = startAbsoluteDate;
            while (extrapDate.compareTo(endAbsoluteDate) <= 0) {
                PVCoordinates pv = lof.getTransformTo((Frame)loc, extrapDate).transformPVCoordinates(PVCoordinates.ZERO);
                double range = pv.getPosition().getNorm();
                double rangeRate = Vector3D.dotProduct((Vector3D)pv.getPosition(), (Vector3D)pv.getVelocity()) / pv.getPosition().getNorm();
                double azimuth = Math.atan2(pv.getPosition().getX(), pv.getPosition().getY());
                double l = Math.sqrt(pv.getPosition().getX() * pv.getPosition().getX() + pv.getPosition().getY() * pv.getPosition().getY());
                double elevation = Math.atan2(pv.getPosition().getZ(), l);
                PVCoordinates sc = lof.getTransformTo(earth.getBodyFrame(), extrapDate).transformPVCoordinates(PVCoordinates.ZERO);
                PVCoordinates tgt = loc.getTransformTo(earth.getBodyFrame(), extrapDate).transformPVCoordinates(PVCoordinates.ZERO);
                Vector3D p = sc.getPosition();
                Vector3D v = sc.getVelocity();
                Vector3D crossTrack = p.crossProduct((Vector)v);
                Vector3D target = tgt.getPosition();
                Vector3D scToTarget = p.subtract((Vector)target);
                Vector3D scToTargetOntoOrbitalPlane = this.projectOntoPlane(scToTarget, crossTrack.normalize());
                Vector3D scToTargetOntoCrossTrackPlane = this.projectOntoPlane(scToTarget, v.normalize());
                double scAlongTrackAngle = this.getAlongTrackAngle(p, scToTargetOntoOrbitalPlane, crossTrack);
                double scCrossTrackAngle = this.getCrossTrackAngle(p, scToTargetOntoCrossTrackPlane, v);
                VisibilityPassSpacecraftPosition position = ApogyCoreEnvironmentOrbitEarthFactory.eINSTANCE.createVisibilityPassSpacecraftPosition();
                position.setTime(ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.createDate(extrapDate));
                position.setRange(range);
                position.setRangeRate(rangeRate);
                position.setAzimuth(azimuth);
                position.setElevation(elevation);
                position.setSpacecraftCrossTrackAngle(scCrossTrackAngle);
                position.setSpacecraftAlongTrackAngle(scAlongTrackAngle);
                GeodeticPoint scCoords = earth.transform(sc.getPosition(), earth.getBodyFrame(), extrapDate);
                GeographicCoordinates geo = ApogyEarthFacade.INSTANCE.createGeographicCoordinates(scCoords.getLongitude(), scCoords.getLatitude(), scCoords.getAltitude());
                position.setSpacecraftCoordinates(geo);
                positions.add(position);
                extrapDate = new AbsoluteDate(extrapDate, timeInterval, (TimeScale)utc);
            }
            propagator.propagate(new AbsoluteDate(startAbsoluteDate, pass.getDuration()));
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        return positions;
    }

    private double getAlongTrackAngle(Vector3D p, Vector3D scToTargetOntoOrbitalPlane, Vector3D crossTrackVector) {
        double angle = this.getAngle(p, scToTargetOntoOrbitalPlane);
        Vector3D rotation = p.crossProduct((Vector)scToTargetOntoOrbitalPlane).normalize();
        double dotProduct = rotation.dotProduct((Vector)crossTrackVector.normalize());
        if (dotProduct < 0.0) {
            angle = -angle;
        }
        return Math.abs(angle);
    }

    private double getCrossTrackAngle(Vector3D p, Vector3D scToTargetOntoCrossTrackPlane, Vector3D alongTrackVector) {
        double angle = this.getAngle(p, scToTargetOntoCrossTrackPlane);
        Vector3D rotation = p.crossProduct((Vector)scToTargetOntoCrossTrackPlane).normalize();
        double dotProduct = rotation.dotProduct((Vector)alongTrackVector.normalize());
        if (dotProduct > 0.0) {
            angle = -angle;
        }
        return angle;
    }

    private double getAngle(Vector3D v1, Vector3D v2) {
        double dotProduct = v1.dotProduct((Vector)v2);
        return Math.acos(dotProduct / (v1.getNorm() * v2.getNorm()));
    }

    private Vector3D projectOntoPlane(Vector3D u, Vector3D planeNormal) {
        double projUOnNormalLenght = u.dotProduct((Vector)planeNormal) / planeNormal.getNormSq();
        Vector3D projUOnNormal = planeNormal.scalarMultiply(projUOnNormalLenght);
        return u.subtract((Vector)projUOnNormal);
    }
}

