/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.composites;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.core.ApogyCoreFacade;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFacade;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentFactory;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeaturesOfInterestMapLayersListComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(FeaturesOfInterestMapLayersListComposite.class);
    public static String path = System.getProperty("user.home");
    private Map map;
    private final Tree tree;
    private final TreeViewer treeViewer;
    private final Button btnNew;
    private final Button btnDelete;
    private final Button btnImport;
    private final Button btnExport;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;

    public FeaturesOfInterestMapLayersListComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, false, true, 1, 1);
        gd_tree.minimumWidth = 200;
        gd_tree.widthHint = 200;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CustomContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FeaturesOfInterestMapLayersListComposite.this.newFeaturesOfInterestMapLayerSelected((FeaturesOfInterestMapLayer)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS, (EObject)FeaturesOfInterestMapLayersListComposite.this.getMap(), null, ApogySurfaceEnvironmentPackage.Literals.FEATURES_OF_INTEREST_MAP_LAYER);
                    WizardDialog dialog = new WizardDialog(FeaturesOfInterestMapLayersListComposite.this.getShell(), (IWizard)wizard);
                    dialog.open();
                    if (!FeaturesOfInterestMapLayersListComposite.this.treeViewer.isBusy()) {
                        FeaturesOfInterestMapLayersListComposite.this.treeViewer.setInput((Object)FeaturesOfInterestMapLayersListComposite.this.getMap());
                    }
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String foiMapLayersToDeleteMessage = "";
                Iterator<FeaturesOfInterestMapLayer> foiMapsLayers = FeaturesOfInterestMapLayersListComposite.this.getSelectedFeatureOfInterestMapLayers().iterator();
                while (foiMapsLayers.hasNext()) {
                    FeaturesOfInterestMapLayer foiMapLayer = foiMapsLayers.next();
                    foiMapLayersToDeleteMessage = String.valueOf(foiMapLayersToDeleteMessage) + foiMapLayer.getName();
                    if (!foiMapsLayers.hasNext()) continue;
                    foiMapLayersToDeleteMessage = String.valueOf(foiMapLayersToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected FOI Map Layers", null, "Are you sure to delete these FOI Map Layers: " + foiMapLayersToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (FeaturesOfInterestMapLayer layer : FeaturesOfInterestMapLayersListComposite.this.getSelectedFeatureOfInterestMapLayers()) {
                        try {
                            ApogySurfaceEnvironmentFacade.INSTANCE.deleteLayerFromMap(layer.getMap(), (AbstractMapLayer)layer);
                        }
                        catch (Exception e) {
                            Logger.error("Unable to delete the FOI Map Layer <" + layer.getName() + ">.", (Throwable)e);
                        }
                    }
                }
                if (!FeaturesOfInterestMapLayersListComposite.this.treeViewer.isBusy()) {
                    FeaturesOfInterestMapLayersListComposite.this.treeViewer.setInput((Object)FeaturesOfInterestMapLayersListComposite.this.getMap());
                }
            }
        });
        new Label(composite, 0);
        this.btnImport = new Button(composite, 0);
        this.btnImport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnImport.setSize(74, 29);
        this.btnImport.setText("Import");
        this.btnImport.setToolTipText("Import a list of Feature Of Interest from file.");
        this.btnImport.setEnabled(true);
        this.btnImport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(FeaturesOfInterestMapLayersListComposite.this.getShell(), 4096);
                fd.setFilterPath(path);
                fd.setFilterExtensions(new String[]{"*.csv"});
                fd.setOverwrite(true);
                String filePath = fd.open();
                if (filePath != null) {
                    String urlString = "file://localhost/" + filePath.replace("\\", "/");
                    try {
                        List foiList = ApogyCoreFacade.INSTANCE.loadFeatureOfInterestFromFile(urlString);
                        if (foiList.size() > 0) {
                            Logger.info("Loaded <" + foiList.size() + "> Feature of Interest from file<" + urlString + ">.");
                            FeaturesOfInterestMapLayer layer = ApogySurfaceEnvironmentFactory.eINSTANCE.createFeaturesOfInterestMapLayer();
                            layer.setFeatures(ApogyCoreFactory.eINSTANCE.createFeatureOfInterestList());
                            layer.getFeatures().getFeaturesOfInterest().addAll((Collection)foiList);
                            layer.setName(ApogyCommonEMFFacade.INSTANCE.getDefaultName((EObject)FeaturesOfInterestMapLayersListComposite.this.getMap(), (EObject)layer, (ETypedElement)ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS));
                            layer.setDescription("Feature Of Interest imported from file <" + filePath + ">.");
                            ApogyCommonTransactionFacade.INSTANCE.basicAdd((EObject)FeaturesOfInterestMapLayersListComposite.this.getMap(), (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.MAP__LAYERS, (Object)layer);
                            if (!FeaturesOfInterestMapLayersListComposite.this.treeViewer.isBusy()) {
                                FeaturesOfInterestMapLayersListComposite.this.treeViewer.setInput((Object)FeaturesOfInterestMapLayersListComposite.this.getMap());
                            }
                        } else {
                            Logger.error("Could not load any Feature of Interest from file<" + urlString + ">.");
                        }
                    }
                    catch (Exception ex) {
                        Logger.error("Failed to import Feature of Interests from file<" + urlString + ">.", (Throwable)ex);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.btnExport = new Button(composite, 0);
        this.btnExport.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnExport.setSize(74, 29);
        this.btnExport.setText("Export");
        this.btnExport.setToolTipText("Export the selected list of Feature Of Interest to file.");
        this.btnExport.setEnabled(false);
        this.btnExport.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (FeaturesOfInterestMapLayer foiMapLayer : FeaturesOfInterestMapLayersListComposite.this.getSelectedFeatureOfInterestMapLayers()) {
                    FileDialog fd = new FileDialog(FeaturesOfInterestMapLayersListComposite.this.getShell(), 8192);
                    fd.setText("Save Features Of Interest Map Layer named <" + foiMapLayer.getName() + ">.");
                    fd.setFilterPath(path);
                    fd.setFilterExtensions(new String[]{"*.csv"});
                    fd.setFileName("unnamed.csv");
                    fd.setOverwrite(true);
                    String filePath = fd.open();
                    if (filePath == null) continue;
                    String urlString = "file://localhost/" + filePath.replace("\\", "/");
                    try {
                        ApogyCoreFacade.INSTANCE.saveFeatureOfInterestToFile(filePath, (List)foiMapLayer.getFeatures().getFeaturesOfInterest());
                    }
                    catch (Exception ex) {
                        Logger.error("Failed to export Feature of Interests from file<" + urlString + ">.", (Throwable)ex);
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FeaturesOfInterestMapLayersListComposite.this.m_bindingContext != null) {
                    FeaturesOfInterestMapLayersListComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public Map getMap() {
        return this.map;
    }

    public void setMap(Map newMap) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.map = newMap;
        if (newMap != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.treeViewer.setInput((Object)newMap);
            List<FeaturesOfInterestMapLayer> layers = this.filterMap(newMap);
            if (!layers.isEmpty()) {
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)layers.get(0)), true);
            } else {
                this.treeViewer.setSelection(null, true);
            }
        }
    }

    public List<FeaturesOfInterestMapLayer> getSelectedFeatureOfInterestMapLayers() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void newFeaturesOfInterestMapLayerSelected(FeaturesOfInterestMapLayer newFeaturesOfInterestMapLayer) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        ISWTObservableValue observeEnabledBtnExportObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnExport);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnExportObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    protected List<FeaturesOfInterestMapLayer> filterMap(Map map) {
        ArrayList<FeaturesOfInterestMapLayer> layers = new ArrayList<FeaturesOfInterestMapLayer>();
        for (AbstractMapLayer layer : map.getLayers()) {
            if (!(layer instanceof FeaturesOfInterestMapLayer)) continue;
            layers.add((FeaturesOfInterestMapLayer)layer);
        }
        return layers;
    }

    private class CustomContentProvider
    implements ITreeContentProvider {
        private CustomContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return FeaturesOfInterestMapLayersListComposite.this.filterMap(map).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map) {
                Map map = (Map)parentElement;
                return FeaturesOfInterestMapLayersListComposite.this.filterMap(map).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Map) {
                Map map = (Map)element;
                return !FeaturesOfInterestMapLayersListComposite.this.filterMap(map).isEmpty();
            }
            return false;
        }
    }
}

