/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.core.ApogyCoreFactory;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.MapsList;
import org.eclipse.apogy.core.environment.surface.SurfaceWorksite;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class FeatureOfInterestCreationDialog
extends Dialog {
    private Matrix4x4 pose;
    private Text nameText;
    private Text descriptionText;
    private FeaturesOfInterestMapLayer selectedFeaturesOfInterestMapLayer = null;
    private FeatureOfInterest foi = null;
    private List<FeaturesOfInterestMapLayer> availableFeaturesOfInterestMapLayer;
    private Combo featuresOfInterestMapLayerCombo;

    public FeatureOfInterestCreationDialog(Shell parentShell) {
        super(parentShell);
    }

    public FeatureOfInterestCreationDialog(Shell parentShell, Matrix4x4 pose) {
        this(parentShell);
        this.pose = pose;
    }

    public FeatureOfInterestCreationDialog(Shell parentShell, Matrix4x4 pose, FeaturesOfInterestMapLayer featuresOfInterestMapLayer) {
        this(parentShell);
        this.pose = pose;
        this.selectedFeaturesOfInterestMapLayer = featuresOfInterestMapLayer;
        this.availableFeaturesOfInterestMapLayer = this.findFeaturesOfInterestMapLayers(featuresOfInterestMapLayer);
    }

    public FeatureOfInterestCreationDialog(Shell parentShell, Matrix4x4 pose, InvocatorSession invocatorSession) {
        this(parentShell);
        this.pose = pose;
        this.availableFeaturesOfInterestMapLayer = this.findFeaturesOfInterestMapLayers(invocatorSession);
    }

    public FeatureOfInterest getFeatureOfInterest() {
        return this.foi;
    }

    public FeaturesOfInterestMapLayer getSelectedFeaturesOfInterestMapLayer() {
        return this.selectedFeaturesOfInterestMapLayer;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Create A Feature Of Interest");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Label layerLabel = new Label(container, 0);
        layerLabel.setText("Features Of Interest Map Layer:");
        this.featuresOfInterestMapLayerCombo = this.createFeaturesOfInterestMapLayerCombo(container, this.selectedFeaturesOfInterestMapLayer);
        GridData featuresOfInterestMapLayerComboGridData = new GridData(4, 0x1000000, true, false);
        this.featuresOfInterestMapLayerCombo.setLayoutData((Object)featuresOfInterestMapLayerComboGridData);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText("Name:");
        this.nameText = new Text(container, 2048);
        GridData nameTextGridData = new GridData(4, 0x1000000, true, false);
        this.nameText.setLayoutData((Object)nameTextGridData);
        Label descriptionLabel = new Label(container, 0);
        descriptionLabel.setText("Description:");
        this.descriptionText = new Text(container, 2050);
        GridData descriptionTextGridData = new GridData(4, 4, true, false);
        descriptionTextGridData.heightHint = 200;
        descriptionTextGridData.minimumHeight = 200;
        descriptionTextGridData.widthHint = 400;
        descriptionTextGridData.minimumWidth = 400;
        this.descriptionText.setLayoutData((Object)descriptionTextGridData);
        return area;
    }

    protected void okPressed() {
        this.foi = ApogyCoreFactory.eINSTANCE.createFeatureOfInterest();
        this.foi.setPose(this.pose);
        this.foi.setName(this.nameText.getText());
        this.foi.setDescription(this.descriptionText.getText());
        super.okPressed();
    }

    private Combo createFeaturesOfInterestMapLayerCombo(Composite parent, FeaturesOfInterestMapLayer currentSelection) {
        final Combo combo = new Combo(parent, 8);
        String[] comboItems = new String[this.availableFeaturesOfInterestMapLayer.size()];
        int i = 0;
        while (i < this.availableFeaturesOfInterestMapLayer.size()) {
            FeaturesOfInterestMapLayer layer = this.availableFeaturesOfInterestMapLayer.get(i);
            comboItems[i] = layer.getName() != null && layer.getName().length() > 0 ? layer.getName() : "Features Of Interest Map Layer";
            ++i;
        }
        combo.setItems(comboItems);
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                FeatureOfInterestCreationDialog.this.selectedFeaturesOfInterestMapLayer = (FeaturesOfInterestMapLayer)FeatureOfInterestCreationDialog.this.availableFeaturesOfInterestMapLayer.get(index);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        if (currentSelection != null) {
            combo.select(this.availableFeaturesOfInterestMapLayer.indexOf(currentSelection));
        }
        return combo;
    }

    protected List<FeaturesOfInterestMapLayer> findFeaturesOfInterestMapLayers(InvocatorSession invocatorSession) {
        ApogyEnvironment apogyEnvironment;
        ArrayList<FeaturesOfInterestMapLayer> list = new ArrayList<FeaturesOfInterestMapLayer>();
        if (invocatorSession.getEnvironment() instanceof ApogyEnvironment && (apogyEnvironment = (ApogyEnvironment)invocatorSession.getEnvironment()).getActiveWorksite() instanceof SurfaceWorksite) {
            SurfaceWorksite surfaceWorksite = (SurfaceWorksite)apogyEnvironment.getActiveWorksite();
            MapsList mapList = surfaceWorksite.getMapsList();
            for (Map map : mapList.getMaps()) {
                for (AbstractMapLayer mapLayer : map.getLayers()) {
                    if (!(mapLayer instanceof FeaturesOfInterestMapLayer)) continue;
                    FeaturesOfInterestMapLayer featuresOfInterestMapLayer = (FeaturesOfInterestMapLayer)mapLayer;
                    list.add(featuresOfInterestMapLayer);
                }
            }
        }
        return list;
    }

    protected List<FeaturesOfInterestMapLayer> findFeaturesOfInterestMapLayers(FeaturesOfInterestMapLayer featuresOfInterestMapLayer) {
        InvocatorSession invocatorSession = this.resolveInvocatorSession((EObject)featuresOfInterestMapLayer);
        if (invocatorSession != null) {
            return this.findFeaturesOfInterestMapLayers(invocatorSession);
        }
        return new ArrayList<FeaturesOfInterestMapLayer>();
    }

    protected InvocatorSession resolveInvocatorSession(EObject eObject) {
        InvocatorSession invocatorSession = null;
        while (invocatorSession == null && eObject != null) {
            if (eObject instanceof InvocatorSession) {
                invocatorSession = (InvocatorSession)eObject;
                continue;
            }
            eObject = eObject.eContainer();
        }
        return invocatorSession;
    }
}

