/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.environment.surface.FeaturesOfInterestMapLayer;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class FeatureOfInterestSelectionDialog
extends Dialog {
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private List<FeaturesOfInterestMapLayer> availableLayers = null;
    private final List<FeatureOfInterest> selectedFeatureOfInterestList = new ArrayList<FeatureOfInterest>();
    private TreeViewer treeViewer;

    public FeatureOfInterestSelectionDialog(Shell parentShell, List<FeaturesOfInterestMapLayer> layers) {
        super(parentShell);
        this.availableLayers = layers;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Select one or more Feature Of Interest(s)");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridData containerGridData = new GridData(4, 4, true, true);
        containerGridData.minimumHeight = 300;
        containerGridData.heightHint = 300;
        container.setLayoutData((Object)containerGridData);
        GridLayout layout = new GridLayout(1, false);
        container.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(container, 68098);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        tree.setLinesVisible(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    FeatureOfInterestSelectionDialog.this.selectedFeatureOfInterestList.clear();
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
                    for (Object next : iStructuredSelection) {
                        if (!(next instanceof FeatureOfInterest)) continue;
                        FeatureOfInterestSelectionDialog.this.selectedFeatureOfInterestList.add((FeatureOfInterest)next);
                    }
                }
            }
        });
        TreeViewerColumn treeViewerColumnName = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnName = treeViewerColumnName.getColumn();
        trclmnName.setText("Layer");
        trclmnName.setWidth(350);
        TreeViewerColumn treeViewerFoiDescription = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn trclmnFOIDescription = treeViewerFoiDescription.getColumn();
        trclmnFOIDescription.setText("FOI Description");
        trclmnFOIDescription.setWidth(150);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory){
            private final int LAYER_COLUMN_ID = 0;
            private final int FOI_COLUMN__DESCRIPTION_ID = 1;
            {
                this.LAYER_COLUMN_ID = 0;
                this.FOI_COLUMN__DESCRIPTION_ID = 1;
            }

            public String getColumnText(Object object, int columnIndex) {
                String str = "<undefined>";
                switch (columnIndex) {
                    case 0: {
                        str = super.getColumnText(object, columnIndex);
                        break;
                    }
                    case 1: {
                        if (object instanceof FeatureOfInterest) {
                            str = ((FeatureOfInterest)object).getDescription();
                            break;
                        }
                        str = "";
                        break;
                    }
                }
                return str;
            }

            public Image getColumnImage(Object object, int columnIndex) {
                Image image = null;
                switch (columnIndex) {
                    case 0: {
                        image = super.getColumnImage(object, columnIndex);
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                return image;
            }
        });
        this.treeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory){

            public Object[] getElements(Object object) {
                if (object instanceof List) {
                    return ((List)object).toArray();
                }
                if (object instanceof FeatureOfInterest) {
                    return null;
                }
                return super.getChildren(object);
            }

            public Object[] getChildren(Object object) {
                if (object instanceof List) {
                    return ((List)object).toArray();
                }
                if (object instanceof FeatureOfInterest) {
                    return null;
                }
                return super.getChildren(object);
            }
        });
        if (this.availableLayers != null) {
            this.treeViewer.setInput(this.availableLayers);
        }
        return area;
    }

    public List<FeatureOfInterest> getSelectedFeatureOfInterest() {
        return this.selectedFeatureOfInterestList;
    }

    protected void cancelPressed() {
        this.selectedFeatureOfInterestList.clear();
        super.cancelPressed();
    }
}

