/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.dialogs;

import java.util.HashMap;
import org.eclipse.apogy.core.environment.AbstractWorksite;
import org.eclipse.apogy.core.environment.ApogyEnvironment;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.MapsList;
import org.eclipse.apogy.core.environment.surface.SurfaceWorksite;
import org.eclipse.apogy.core.invocator.Context;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MapSelectionDialog
extends Dialog {
    protected Context context;
    protected Map selectedMap;
    private final HashMap<Integer, Map> indexToMapMap = new HashMap();

    public MapSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public MapSelectionDialog(Shell parentShell, Context context) {
        this(parentShell);
        this.context = context;
    }

    public Map getSelectedMap() {
        return this.selectedMap;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Map Selection");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout(2, false);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)layout);
        Label mapLabel = new Label(container, 0);
        mapLabel.setText("Selected Map:");
        Combo combo = this.createMapSelectionCombo(container, this.context);
        GridData comboGridData = new GridData(4, 0x1000000, false, false);
        comboGridData.minimumWidth = 200;
        comboGridData.widthHint = 200;
        combo.setLayoutData((Object)comboGridData);
        return area;
    }

    protected Combo createMapSelectionCombo(Composite parent, Context context) {
        SurfaceWorksite surfaceWorksite;
        MapsList mapList;
        ApogyEnvironment apogyEnvironment;
        AbstractWorksite worksite;
        final Combo combo = new Combo(parent, 0);
        if (context.getEnvironment() instanceof ApogyEnvironment && (worksite = (apogyEnvironment = (ApogyEnvironment)context.getEnvironment()).getActiveWorksite()) instanceof SurfaceWorksite && (mapList = (surfaceWorksite = (SurfaceWorksite)worksite).getMapsList()) != null && mapList.getMaps() != null && mapList.getMaps().size() > 0) {
            String[] items = new String[mapList.getMaps().size()];
            int i = 0;
            for (Map map : mapList.getMaps()) {
                String itemName = map.getName();
                if (itemName == null) {
                    itemName = Integer.toString(i);
                }
                items[i] = itemName;
                this.indexToMapMap.put(i, map);
                ++i;
            }
            combo.setItems(items);
        }
        combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = combo.getSelectionIndex();
                MapSelectionDialog.this.selectedMap = (Map)MapSelectionDialog.this.indexToMapMap.get(index);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return combo;
    }
}

