/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.core.environment.surface.AbstractMapLayer;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshDiscreteSlopeImageMapLayer;
import org.eclipse.apogy.core.environment.surface.CartesianTriangularMeshMapLayer;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.apogy.core.environment.surface.Map;
import org.eclipse.apogy.core.environment.surface.SlopeRange;
import org.eclipse.apogy.core.environment.surface.ui.ImageMapLayerUISettings;
import org.eclipse.apogy.core.environment.surface.ui.composites.ImageMapLayerPreviewComposite;
import org.eclipse.apogy.core.environment.surface.ui.composites.SlopeRangeComposite;
import org.eclipse.apogy.core.environment.surface.ui.composites.SlopeRangeListComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class CartesianTriangularMeshDiscreteSlopeImageMapLayerWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.CartesianTriangularMeshDiscreteSlopeImageMapLayerWizardPage";
    private final CartesianTriangularMeshDiscreteSlopeImageMapLayer cartesianTriangularMeshDiscreteSlopeImageMapLayer;
    private final ImageMapLayerUISettings uiSettings;
    private ImageMapLayerPreviewComposite imagePreviewComposite;
    private SlopeRangeListComposite slopeRangeListComposite;
    private SlopeRangeComposite slopeRangeComposite;
    private DataBindingContext m_bindingContext;

    public CartesianTriangularMeshDiscreteSlopeImageMapLayerWizardPage(CartesianTriangularMeshDiscreteSlopeImageMapLayer cartesianTriangularMeshDiscreteSlopeImageMapLayer, ImageMapLayerUISettings uiSettings) {
        super(WIZARD_PAGE_ID);
        this.cartesianTriangularMeshDiscreteSlopeImageMapLayer = cartesianTriangularMeshDiscreteSlopeImageMapLayer;
        this.uiSettings = uiSettings;
        this.setTitle("Discrete Slope Image Layer");
        this.setDescription("Configure the discrete slope ranges used to generate the slope image.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Group slopeRangesListGroup = new Group(container, 2048);
        slopeRangesListGroup.setLayout((Layout)new GridLayout(1, false));
        slopeRangesListGroup.setLayoutData((Object)new GridData(16384, 4, false, false, 1, 1));
        slopeRangesListGroup.setText("Slope Ranges");
        this.slopeRangeListComposite = new SlopeRangeListComposite((Composite)slopeRangesListGroup, 0){

            @Override
            protected void newSlopeRangeSelected(SlopeRange newSlopeRange) {
                if (CartesianTriangularMeshDiscreteSlopeImageMapLayerWizardPage.this.slopeRangeComposite != null) {
                    CartesianTriangularMeshDiscreteSlopeImageMapLayerWizardPage.this.slopeRangeComposite.setSlopeRange(newSlopeRange);
                }
            }
        };
        GridData gd_slopeRangeListComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_slopeRangeListComposite.heightHint = 150;
        gd_slopeRangeListComposite.minimumHeight = 150;
        this.slopeRangeListComposite.setLayoutData(gd_slopeRangeListComposite);
        this.slopeRangeListComposite.setCartesianTriangularMeshDiscreteSlopeImageMapLayer(this.cartesianTriangularMeshDiscreteSlopeImageMapLayer);
        Group selectedSlopeRangeGroup = new Group(container, 2048);
        selectedSlopeRangeGroup.setLayout((Layout)new GridLayout(1, false));
        selectedSlopeRangeGroup.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        selectedSlopeRangeGroup.setText("Slope Range Details");
        this.slopeRangeComposite = new SlopeRangeComposite((Composite)selectedSlopeRangeGroup, 0);
        this.slopeRangeComposite.setLayoutData(new GridData(16384, 128, false, false, 1, 1));
        this.slopeRangeComposite.setSlopeRange(this.slopeRangeListComposite.getSelectedSlopeRange());
        Group imageGroup = new Group(container, 2048);
        imageGroup.setLayout((Layout)new GridLayout(1, false));
        imageGroup.setLayoutData((Object)new GridData(4, 128, false, false, 2, 1));
        imageGroup.setText("Derived Image");
        this.imagePreviewComposite = new ImageMapLayerPreviewComposite((Composite)imageGroup, 0, (ImageMapLayer)this.cartesianTriangularMeshDiscreteSlopeImageMapLayer);
        GridData gd_imagePreviewComposite = new GridData(4, 4, true, true, 1, 1);
        gd_imagePreviewComposite.widthHint = 350;
        gd_imagePreviewComposite.heightHint = 350;
        gd_imagePreviewComposite.minimumHeight = 350;
        gd_imagePreviewComposite.minimumWidth = 350;
        this.imagePreviewComposite.setLayoutData(gd_imagePreviewComposite);
        this.imagePreviewComposite.setImageMapLayer((ImageMapLayer)this.cartesianTriangularMeshDiscreteSlopeImageMapLayer);
        this.setControl((Control)container);
        this.m_bindingContext = this.initDataBindingsCustom();
        this.validate();
        container.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CartesianTriangularMeshDiscreteSlopeImageMapLayerWizardPage.this.m_bindingContext != null) {
                    CartesianTriangularMeshDiscreteSlopeImageMapLayerWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }

    public class CompositeFilterContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Map) {
                Map map = (Map)inputElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Map) {
                Map map = (Map)parentElement;
                return this.filterMap(map).toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Map) {
                Map map = (Map)element;
                return !this.filterMap(map).isEmpty();
            }
            return false;
        }

        protected List<CartesianTriangularMeshMapLayer> filterMap(Map map) {
            ArrayList<CartesianTriangularMeshMapLayer> imageMapLayers = new ArrayList<CartesianTriangularMeshMapLayer>();
            for (AbstractMapLayer layer : map.getLayers()) {
                if (!(layer instanceof CartesianTriangularMeshMapLayer)) continue;
                imageMapLayers.add((CartesianTriangularMeshMapLayer)layer);
            }
            return imageMapLayers;
        }
    }
}

