/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.core.environment.surface.AbstractShapeImageLayer;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.ImageMapLayer;
import org.eclipse.apogy.core.environment.surface.RectangleShapeImageLayer;
import org.eclipse.apogy.core.environment.surface.ui.composites.AbstractShapeImageLayerComposite;
import org.eclipse.apogy.core.environment.surface.ui.composites.ImageMapLayerPreviewComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RectangleShapeImageLayerWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.RectangleShapeImageLayerWizardPage";
    private AbstractShapeImageLayerComposite abstractShapeImageLayerComposite;
    private Text txtRectangleWidth;
    private Text txtRectangleHeight;
    private Button btnShowCenterLines;
    private final RectangleShapeImageLayer rectangleShapeImageLayer;
    private ImageMapLayerPreviewComposite imageMapLayerPreviewComposite;
    private DataBindingContext m_bindingContext;

    public RectangleShapeImageLayerWizardPage(RectangleShapeImageLayer rectangleShapeImageLayer) {
        super(WIZARD_PAGE_ID);
        this.rectangleShapeImageLayer = rectangleShapeImageLayer;
        this.setTitle("Rectangle Image Layer Settings.");
        this.setDescription("Sets the Rectangle Image Layer settings.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(2, false));
        Group layerSizeGroup = new Group(top, 0);
        layerSizeGroup.setLayout((Layout)new GridLayout(2, false));
        layerSizeGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        layerSizeGroup.setText("Layer General Settings");
        this.abstractShapeImageLayerComposite = new AbstractShapeImageLayerComposite((Composite)layerSizeGroup, 0, (AbstractShapeImageLayer)this.rectangleShapeImageLayer, false){

            @Override
            protected void imageResolutionChanged(double newImageWidth) {
                RectangleShapeImageLayerWizardPage.this.validate();
            }

            @Override
            protected void imageHeightChanged(double newImageWidth) {
                RectangleShapeImageLayerWizardPage.this.validate();
            }

            @Override
            protected void imageWidthChanged(double newImageWidth) {
                RectangleShapeImageLayerWizardPage.this.validate();
            }
        };
        Group ellipseGroup = new Group(top, 0);
        ellipseGroup.setLayout((Layout)new GridLayout(2, false));
        ellipseGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ellipseGroup.setText("Rectangle Parameters");
        Label lblEllipseWidth = new Label((Composite)ellipseGroup, 0);
        lblEllipseWidth.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEllipseWidth.setText("Rectangle Width (m):");
        this.txtRectangleWidth = new Text((Composite)ellipseGroup, 2048);
        this.txtRectangleWidth.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRectangleWidth.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                RectangleShapeImageLayerWizardPage.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                RectangleShapeImageLayerWizardPage.this.validate();
            }
        });
        Label lblEllipseHeight = new Label((Composite)ellipseGroup, 0);
        lblEllipseHeight.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblEllipseHeight.setText("Rectangle Width (m):");
        this.txtRectangleHeight = new Text((Composite)ellipseGroup, 2048);
        this.txtRectangleHeight.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.txtRectangleHeight.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                RectangleShapeImageLayerWizardPage.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                RectangleShapeImageLayerWizardPage.this.validate();
            }
        });
        Label lblShowCenterLines = new Label((Composite)ellipseGroup, 0);
        lblShowCenterLines.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblShowCenterLines.setText("Show Center Lines:");
        this.btnShowCenterLines = new Button((Composite)ellipseGroup, 32);
        this.btnShowCenterLines.setAlignment(131072);
        this.btnShowCenterLines.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        this.btnShowCenterLines.setText("");
        this.btnShowCenterLines.setToolTipText("Whether or not to show the center lines.");
        Group grImagePreview = new Group(top, 2048);
        grImagePreview.setText("Image Preview");
        grImagePreview.setLayout((Layout)new GridLayout(3, false));
        grImagePreview.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.imageMapLayerPreviewComposite = new ImageMapLayerPreviewComposite((Composite)grImagePreview, 2048, (ImageMapLayer)this.rectangleShapeImageLayer);
        this.imageMapLayerPreviewComposite.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        this.setControl((Control)top);
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RectangleShapeImageLayerWizardPage.this.m_bindingContext != null) {
                    RectangleShapeImageLayerWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.rectangleShapeImageLayer.getRequiredResolution() <= 0.0) {
            this.setErrorMessage("Invalid image resolution specified <" + this.rectangleShapeImageLayer.getRequiredResolution() + "> must be larger than zero.");
        }
        if (this.rectangleShapeImageLayer.getRectangleWidth() <= 0.0) {
            this.setErrorMessage("Invalid Rectangle Width specified <" + this.rectangleShapeImageLayer.getRectangleWidth() + "> must be larger than zero.");
        }
        if (this.rectangleShapeImageLayer.getRectangleHeight() <= 0.0) {
            this.setErrorMessage("Invalid Rectangle Height specified <" + this.rectangleShapeImageLayer.getRectangleHeight() + "> must be larger than zero.");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observEllipseWidthInMeters = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.rectangleShapeImageLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.RECTANGLE_SHAPE_IMAGE_LAYER__RECTANGLE_WIDTH})).observe((Object)this.rectangleShapeImageLayer);
        ISWTObservableValue observeTxtEllipseWidth = WidgetProperties.text((int)24).observe((Widget)this.txtRectangleWidth);
        bindingContext.bindValue((IObservableValue)observeTxtEllipseWidth, observEllipseWidthInMeters, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        IObservableValue observEllipseHeightInMeters = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.rectangleShapeImageLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.RECTANGLE_SHAPE_IMAGE_LAYER__RECTANGLE_HEIGHT})).observe((Object)this.rectangleShapeImageLayer);
        ISWTObservableValue observeTxtEllipseHeight = WidgetProperties.text((int)24).observe((Widget)this.txtRectangleHeight);
        bindingContext.bindValue((IObservableValue)observeTxtEllipseHeight, observEllipseHeightInMeters, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        return bindingContext;
    }
}

