/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.core.environment.surface.ui.wizards;

import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.URLEImage;
import org.eclipse.apogy.common.images.ui.composites.ImageDisplayComposite;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.apogy.core.environment.surface.ApogySurfaceEnvironmentPackage;
import org.eclipse.apogy.core.environment.surface.URLImageMapLayer;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLImageMapLayerWizardPage
extends WizardPage {
    private static final Logger Logger = LoggerFactory.getLogger(URLImageMapLayerWizardPage.class);
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.core.environment.surface.ui.wizards.URLImageMapLayerWizardPage";
    private Text imageWidthInMeters;
    private Text imageHeightInMeters;
    private final URLImageMapLayer urlImageMapLayer;
    private URLSelectionComposite urlSelectionComposite;
    private ImageDisplayComposite imageDisplayComposite;
    private Label lblImageWidthValue;
    private Label lblImageHeightValue;
    private DataBindingContext m_bindingContext;
    private String urlString = null;

    public URLImageMapLayerWizardPage(URLImageMapLayer urlImageMapLayer) {
        super(WIZARD_PAGE_ID);
        this.urlImageMapLayer = urlImageMapLayer;
        if (urlImageMapLayer != null) {
            this.urlString = urlImageMapLayer.getUrl();
        }
        this.setTitle("Image Layer : URL selection");
        this.setDescription("Sets the Image Layer URL.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        Composite settingComposite = new Composite(top, 0);
        settingComposite.setLayout((Layout)new GridLayout(2, false));
        settingComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Label lblimageWidthInMeters = new Label(settingComposite, 0);
        lblimageWidthInMeters.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblimageWidthInMeters.setText("Image width (m):");
        this.imageWidthInMeters = new Text(settingComposite, 2048);
        this.imageWidthInMeters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.imageWidthInMeters.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                URLImageMapLayerWizardPage.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                URLImageMapLayerWizardPage.this.validate();
            }
        });
        Label lblimageHeightInMeters = new Label(settingComposite, 0);
        lblimageHeightInMeters.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblimageHeightInMeters.setText("Image height (m):");
        this.imageHeightInMeters = new Text(settingComposite, 2048);
        this.imageHeightInMeters.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.imageHeightInMeters.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                URLImageMapLayerWizardPage.this.validate();
            }

            public void keyPressed(KeyEvent e) {
                URLImageMapLayerWizardPage.this.validate();
            }
        });
        this.urlSelectionComposite = new URLSelectionComposite(top, 0, new String[]{"*.gif", "*.png", "*.jpg", "*.jpeg"}, true, true, true){

            protected void urlStringSelected(String newURLString) {
                URLImageMapLayerWizardPage.this.urlString = newURLString;
                URLImageMapLayerWizardPage.this.validate();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)URLImageMapLayerWizardPage.this.urlImageMapLayer, (EStructuralFeature)ApogySurfaceEnvironmentPackage.Literals.URL_MAP_LAYER__URL, (Object)newURLString);
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.urlImageMapLayer != null && this.urlImageMapLayer.getUrl() != null) {
            this.urlSelectionComposite.setUrlString(this.urlImageMapLayer.getUrl());
        }
        Group grImagePreview = new Group(top, 2048);
        grImagePreview.setText("Image Preview");
        grImagePreview.setLayout((Layout)new GridLayout(2, false));
        grImagePreview.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite imageSizeComposite = new Composite((Composite)grImagePreview, 0);
        imageSizeComposite.setLayout((Layout)new GridLayout(2, false));
        imageSizeComposite.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        Label lblImageWidth = new Label(imageSizeComposite, 0);
        lblImageWidth.setText("Image Width (pixels):");
        lblImageWidth.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.lblImageWidthValue = new Label(imageSizeComposite, 2048);
        GridData gd_lblImageWidthValue = new GridData(16384, 128, false, false, 1, 1);
        gd_lblImageWidthValue.widthHint = 100;
        gd_lblImageWidthValue.minimumWidth = 100;
        this.lblImageWidthValue.setLayoutData((Object)gd_lblImageWidthValue);
        Label lblImageHeight = new Label(imageSizeComposite, 0);
        lblImageHeight.setText("Image Height (pixels):");
        lblImageHeight.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        this.lblImageHeightValue = new Label(imageSizeComposite, 2048);
        GridData gd_lblImageHeightValue = new GridData(16384, 128, false, false, 1, 1);
        gd_lblImageHeightValue.widthHint = 100;
        gd_lblImageHeightValue.minimumWidth = 100;
        this.lblImageHeightValue.setLayoutData((Object)gd_lblImageHeightValue);
        new Label((Composite)grImagePreview, 0);
        this.imageDisplayComposite = new ImageDisplayComposite((Composite)grImagePreview, 2048);
        this.imageDisplayComposite.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.imageDisplayComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                URLImageMapLayerWizardPage.this.imageDisplayComposite.fitImage();
            }
        });
        this.setControl((Control)top);
        this.urlSelectionComposite.setFocus();
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (URLImageMapLayerWizardPage.this.m_bindingContext != null) {
                    URLImageMapLayerWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void updateImagePreview(String urlString) {
        try {
            URLEImage urlEImage = ApogyCommonImagesFactory.eINSTANCE.createURLEImage();
            urlEImage.setUrl(urlString);
            this.lblImageWidthValue.setText(Integer.toString(urlEImage.getWidth()));
            this.lblImageHeightValue.setText(Integer.toString(urlEImage.getHeight()));
            ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(urlEImage.asBufferedImage());
            this.imageDisplayComposite.setImageData(imageData);
            this.imageDisplayComposite.fitImage();
        }
        catch (Exception e) {
            Logger.error(e.getMessage(), (Throwable)e);
            this.setErrorMessage("Failed to load image !");
            this.imageDisplayComposite.setImageData(null);
        }
    }

    protected void validate() {
        boolean urlValid;
        this.setErrorMessage(null);
        if (this.urlImageMapLayer.getHeight() <= 0.0) {
            this.setErrorMessage("Invalid image Height specified <" + this.urlImageMapLayer.getHeight() + "> must be larger than zero.");
        }
        if (this.urlImageMapLayer.getWidth() <= 0.0) {
            this.setErrorMessage("Invalid image Width specified <" + this.urlImageMapLayer.getWidth() + "> must be larger than zero.");
            return;
        }
        boolean bl = urlValid = this.urlString != null && this.urlString.length() > 0;
        if (urlValid) {
            this.updateImagePreview(this.urlString);
        } else {
            this.setErrorMessage("Invalid URL specified !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        IObservableValue observeImageWidthResolution = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.urlImageMapLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__WIDTH})).observe((Object)this.urlImageMapLayer);
        ISWTObservableValue observeImageWidthText = WidgetProperties.text((int)24).observe((Widget)this.imageWidthInMeters);
        bindingContext.bindValue((IObservableValue)observeImageWidthText, observeImageWidthResolution, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        IObservableValue observeImageHeight = EMFEditProperties.value((EditingDomain)ApogyCommonTransactionFacade.INSTANCE.getTransactionalEditingDomain((EObject)this.urlImageMapLayer), (FeaturePath)FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogySurfaceEnvironmentPackage.Literals.IMAGE_MAP_LAYER__HEIGHT})).observe((Object)this.urlImageMapLayer);
        ISWTObservableValue observeImageHeightText = WidgetProperties.text((int)24).observe((Widget)this.imageHeightInMeters);
        bindingContext.bindValue((IObservableValue)observeImageHeightText, observeImageHeight, new UpdateValueStrategy().setConverter((IConverter)new Converter(String.class, Double.class){

            public Object convert(Object fromObject) {
                return Double.parseDouble((String)fromObject);
            }
        }), new UpdateValueStrategy().setConverter((IConverter)new Converter(Double.class, String.class){

            public Object convert(Object fromObject) {
                return ((Double)fromObject).toString();
            }
        }));
        return bindingContext;
    }
}

